/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.restlet.data.CacheDirective;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.freemarker.ContextTemplateLoader;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.AuthorizationBaseServerResource;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public class AuthPageServerResource
extends AuthorizationBaseServerResource {
    private static final String ACTION_ACCEPT = "Accept";
    private static final String ACTION_REJECT = "Reject";

    @Get(value="html")
    public Representation showPage() throws OAuthException {
        String action = this.getQuery().getFirstValue("action");
        if (action != null) {
            String[] scopes = this.getQuery().getValuesArray("scope");
            this.handleAction(action, scopes);
            return new EmptyRepresentation();
        }
        String authPage = HttpOAuthHelper.getAuthPageTemplate(this.getContext());
        this.getLogger().fine("this is auth page: " + authPage);
        if (authPage != null && authPage.length() > 0) {
            this.getLogger().fine("loading authPage: " + authPage);
            boolean sameScope = HttpOAuthHelper.getAuthSkipApproved(this.getContext());
            if (sameScope) {
                String[] scopesArray = this.getQuery().getValuesArray("scope");
                List<String> scopes = Arrays.asList(scopesArray);
                List<String> previousScopes = Arrays.asList(this.getQuery().getValuesArray("grantedScope"));
                if (previousScopes.containsAll(scopes)) {
                    this.getLogger().fine("All scopes already approved. - skip auth page.");
                    this.handleAction(ACTION_ACCEPT, scopesArray);
                    return new EmptyRepresentation();
                }
            }
            AuthPageServerResource.addCacheDirective(this.getResponse(), CacheDirective.noCache());
            return this.getPage(authPage);
        }
        this.getLogger().fine("accepting scopes since no authPage: " + authPage);
        this.handleAction(ACTION_ACCEPT, this.getQuery().getValuesArray("scope"));
        this.getLogger().fine("action handled");
        return new EmptyRepresentation();
    }

    protected void handleAction(String action, String[] scopes) throws OAuthException {
        ResponseType flow;
        AuthSession session = this.getAuthSession();
        if (action.equals(ACTION_REJECT)) {
            this.getLogger().fine("Rejected.");
            throw new OAuthException(OAuthError.access_denied, "Rejected.", null);
        }
        this.getLogger().fine("Accepting scopes - in handleAction");
        Client client = session.getClient();
        String id = session.getScopeOwner();
        String redirUrl = session.getDynamicCallbackURI();
        this.getLogger().fine("OAuth2 get dynamic callback = " + redirUrl);
        if (redirUrl == null || redirUrl.isEmpty()) {
            redirUrl = client.getRedirectUri();
        }
        AuthenticatedUser user = client.containsUser(id) ? client.findUser(id) : client.createUser(id);
        HashSet<String> scopeSet = new HashSet<String>();
        scopeSet.addAll(Arrays.asList(scopes));
        user.revokeRoles();
        for (String s : scopeSet) {
            this.getLogger().fine("Adding scope = " + s + " to user = " + id);
            user.addRole(this.getRole(s), "");
        }
        user.persist();
        Reference location = new Reference(redirUrl);
        String state = session.getState();
        if (state != null && !state.isEmpty()) {
            location.addQueryParameter("state", state);
        }
        if ((flow = session.getAuthFlow()).equals((Object)ResponseType.token)) {
            Token token = this.generator.generateToken(user, this.tokenTimeSec);
            location.addQueryParameter("token_type", "Bearer");
            location.addQueryParameter("access_token", token.getToken());
            long expiresIn = token.getExpirePeriod();
            if (expiresIn != 0L) {
                location.addQueryParameter("expires_in", Long.toString(expiresIn));
            }
            Object[] granted = scopeSet.toArray(new String[0]);
            if (!Arrays.equals(session.getRequestedScope(), granted)) {
                location.addQueryParameter("scope", Scopes.toString((String[])granted));
            }
        } else if (flow.equals((Object)ResponseType.code)) {
            String code = this.generator.generateCode(user);
            location.addQueryParameter("code", code);
        }
        session.setState(null);
        if (flow.equals((Object)ResponseType.token)) {
            location.setFragment(location.getQuery());
            location.setQuery("");
        }
        this.getLogger().fine("Redirecting to -> " + location);
        this.redirectTemporary(location);
    }

    protected Representation getPage(String authPage) {
        String clientId = this.getQuery().getFirstValue("client");
        Client client = this.clients.findById(clientId);
        String[] scopes = this.getQuery().getValuesArray("scope");
        String[] previousScopes = this.getQuery().getValuesArray("grantedScope");
        Configuration config = new Configuration();
        ContextTemplateLoader ctl = new ContextTemplateLoader(this.getContext(), "clap:///");
        config.setTemplateLoader((TemplateLoader)ctl);
        this.getLogger().fine("loading: " + authPage);
        TemplateRepresentation result = new TemplateRepresentation(authPage, config, MediaType.TEXT_HTML);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("target", this.getRootRef() + HttpOAuthHelper.getAuthPage(this.getContext()));
        data.put("clientId", clientId);
        data.put("clientDescription", client.toString());
        data.put("clientCallback", client.getRedirectUri());
        data.put("clientName", client.getApplicationName());
        data.put("requestingScopes", scopes);
        data.put("grantedScopes", previousScopes);
        result.setDataModel(data);
        return result;
    }
}

