/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Context;
import org.restlet.representation.Representation;
import org.restlet.security.User;

public class OAuthUser
extends User {
    private final String accessToken;
    private final long expiresIn;
    private final String refreshToken;
    private volatile String state;

    public static OAuthUser createJson(Representation body) {
        return OAuthUser.createJson(null, body);
    }

    public static OAuthUser createJson(User toCopy, Representation body) {
        Logger log = Context.getCurrentLogger();
        try {
            JSONObject answer = new JSONObject(body.getText());
            log.fine("Got answer on JSON = " + answer.toString());
            String accessToken = null;
            if (answer.has("access_token")) {
                accessToken = answer.getString("access_token");
                log.fine("AccessToken = " + accessToken);
            }
            String refreshToken = null;
            if (answer.has("refresh_token")) {
                refreshToken = answer.getString("refresh_token");
                log.fine("RefreshToken = " + refreshToken);
            }
            long expiresIn = 0L;
            if (answer.has("expires_in")) {
                expiresIn = answer.getLong("expires_in");
                log.fine("ExpiresIn = " + expiresIn);
            }
            return new OAuthUser(toCopy, accessToken, refreshToken, expiresIn);
        }
        catch (JSONException e) {
            log.log(Level.WARNING, "Error parsing JSON", e);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error creating representation JSON", e);
        }
        return null;
    }

    public OAuthUser(String user, String accessToken) {
        this(user, accessToken, null, 0L);
    }

    public OAuthUser(String user, String accessToken, String refreshToken, long expiresIn) {
        super(user, accessToken);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }

    public OAuthUser(User user, String accessToken) {
        this(user, accessToken, null, 0L);
    }

    public OAuthUser(User user, String accessToken, String refreshToken, long expiresIn) {
        this(user != null ? user.getIdentifier() : null, accessToken, refreshToken, expiresIn);
        if (user != null) {
            this.setEmail(user.getEmail());
            this.setFirstName(user.getFirstName());
            this.setLastName(user.getLastName());
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getState() {
        return this.state;
    }

    public boolean isExpireToken() {
        return this.refreshToken != null;
    }

    public void setState(String state) {
        this.state = state;
    }
}

