/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid;

import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Status;
import org.restlet.security.Authenticator;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class RedirectAuthenticator
extends Authenticator {
    public static final String DEFAULT_IDENTIFIER_COOKIE = "session_id";
    public static final String DEFAULT_ORIGINAL_REF_COOKIE = "original_ref";
    public static final String ORIGINAL_REF_ATTRIBUTE = "origRef";
    private Restlet forbiddenResource;
    private final String identifierCookie;
    private final String origRefCookie;
    private final Verifier verifier;

    public static void clearIdentifierCookie(String cookieId, Request req, Response res) {
        Cookie cookie = (Cookie)req.getCookies().getFirst(cookieId);
        CookieSetting identifierCookie = (CookieSetting)res.getCookieSettings().getFirst(cookieId);
        if (identifierCookie == null && cookie != null) {
            identifierCookie = new CookieSetting(cookieId, null);
            res.getCookieSettings().add((Object)identifierCookie);
        }
        if (identifierCookie != null) {
            identifierCookie.setMaxAge(0);
        }
    }

    public static void clearIdentiiferCookie(Request req, Response res) {
        RedirectAuthenticator.clearIdentifierCookie(DEFAULT_IDENTIFIER_COOKIE, req, res);
    }

    public RedirectAuthenticator(Context context, Verifier verifier, Restlet forbiddenResource) {
        super(context);
        this.forbiddenResource = forbiddenResource;
        this.verifier = verifier;
        this.origRefCookie = DEFAULT_ORIGINAL_REF_COOKIE;
        this.identifierCookie = DEFAULT_IDENTIFIER_COOKIE;
    }

    public RedirectAuthenticator(Context context, Verifier verifier, String identifierCookie, String origRefCookie, Restlet forbiddenResource) {
        super(context);
        this.forbiddenResource = forbiddenResource;
        this.verifier = verifier;
        this.identifierCookie = identifierCookie != null ? identifierCookie : DEFAULT_IDENTIFIER_COOKIE;
        this.origRefCookie = origRefCookie != null ? origRefCookie : DEFAULT_ORIGINAL_REF_COOKIE;
    }

    protected boolean authenticate(Request request, Response response) {
        String origRef;
        User u = request.getClientInfo().getUser();
        String identifier = request.getCookies().getFirstValue(this.identifierCookie);
        if (identifier != null) {
            u = new User(identifier);
            request.getClientInfo().setUser(u);
            return true;
        }
        if (request.getCookies().getFirstValue(this.origRefCookie) == null) {
            origRef = request.getResourceRef().toString();
            response.getCookieSettings().add(this.origRefCookie, request.getResourceRef().toString());
        } else {
            origRef = request.getCookies().getFirstValue(this.origRefCookie);
        }
        int verified = this.verifier.verify(request, response);
        this.getLogger().fine("VERIFIED: " + verified);
        if (verified == 4) {
            response.getCookieSettings().removeAll(this.identifierCookie);
            response.getCookieSettings().add(this.identifierCookie, request.getClientInfo().getUser().getIdentifier());
            this.handleUser(request.getClientInfo().getUser());
            request.getCookies().removeAll(this.origRefCookie);
            response.getCookieSettings().removeAll(this.origRefCookie);
            if (origRef != null) {
                response.redirectPermanent(origRef);
            }
            return true;
        }
        response.getCookieSettings().removeAll(this.identifierCookie);
        if (verified == 5 || verified == -1) {
            origRef = response.getCookieSettings().getFirstValue(this.origRefCookie);
            if (origRef == null) {
                origRef = request.getCookies().getFirstValue(this.origRefCookie);
            }
            this.forbid(origRef, request, response);
        }
        return false;
    }

    public void forbid(String origRef, Request request, Response response) {
        if (this.forbiddenResource == null) {
            response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        } else {
            this.getLogger().fine("sending to error resource");
            this.forbiddenResource.handle(request, response);
        }
    }

    protected void handleUser(User user) {
        this.getLogger().info("Handle User: " + user.getIdentifier() + " " + user.getEmail());
    }

    protected int unauthenticated(Request request, Response response) {
        int ret = super.unauthenticated(request, response);
        return ret;
    }

    protected int authenticated(Request request, Response response) {
        int ret = super.authenticated(request, response);
        if (response != null && response.getStatus().isRedirection()) {
            return 2;
        }
        return ret;
    }
}

