/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.simple.SimpleServerHelper;
import org.restlet.ext.simple.internal.SimpleContainer;
import org.restlet.ext.simple.internal.SimpleServer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;

public class HttpsServerHelper
extends SimpleServerHelper {
    private SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void start() throws Exception {
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        SSLContext sslContext = sslContextFactory.createSslContext();
        String addr = ((Server)this.getHelped()).getAddress();
        if (addr != null) {
            InetAddress iaddr = InetAddress.getByName(addr);
            this.setAddress(new InetSocketAddress(iaddr, ((Server)this.getHelped()).getPort()));
        } else {
            int port = ((Server)this.getHelped()).getPort();
            if (port > 0) {
                this.setAddress(new InetSocketAddress(((Server)this.getHelped()).getPort()));
            }
        }
        SimpleContainer container = new SimpleContainer(this);
        ContainerServer server = new ContainerServer((Container)container, this.getDefaultThreads());
        SimpleServer filter = new SimpleServer((org.simpleframework.transport.Server)server);
        SocketConnection connection = new SocketConnection((org.simpleframework.transport.Server)filter);
        this.setSslContext(sslContext);
        this.setConfidential(true);
        this.setContainerServer(server);
        this.setConnection((Connection)connection);
        InetSocketAddress address = (InetSocketAddress)this.getConnection().connect((SocketAddress)this.getAddress(), this.getSslContext());
        this.setEphemeralPort(address.getPort());
        super.start();
    }
}

