/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.util.List;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.ext.sip.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressWriter
extends HeaderWriter<Address> {
    private final boolean includingTag;

    public AddressWriter() {
        this(true);
    }

    public AddressWriter(boolean includingTag) {
        this.includingTag = includingTag;
    }

    public static String write(Address address) {
        return AddressWriter.write(address, true);
    }

    public static String write(Address address, boolean includeTag) {
        return new AddressWriter(includeTag).append(address).toString();
    }

    public static String write(List<Address> addresses) {
        return new AddressWriter(true).append(addresses).toString();
    }

    public HeaderWriter<Address> append(Address address) {
        if (address != null) {
            if (address.getDisplayName() != null) {
                this.appendQuotedString(address.getDisplayName());
                this.append(" ");
            }
            this.append("<");
            this.append(address.getReference().toString());
            this.append("> ");
            if (!address.getParameters().isEmpty()) {
                for (Parameter param : address.getParameters()) {
                    if (!this.includingTag && "tag".equals(param.getName())) continue;
                    this.appendParameterSeparator();
                    this.appendExtension(param);
                }
            }
        }
        return this;
    }
}

