/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.engine.header.PreferenceWriter;
import org.restlet.ext.sip.ContactInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactInfoWriter
extends HeaderWriter<ContactInfo> {
    public static String write(ContactInfo contact) {
        return new ContactInfoWriter().append(contact).toString();
    }

    public static String write(List<ContactInfo> contacts) {
        return new ContactInfoWriter().append(contacts).toString();
    }

    public HeaderWriter<ContactInfo> append(ContactInfo contact) {
        if (contact != null) {
            if (contact.getDisplayName() != null) {
                this.appendQuotedString(contact.getDisplayName());
                this.append(" <");
                this.append(contact.getReference().toString());
                this.append("> ");
            }
            if (!contact.getParameters().isEmpty()) {
                if (contact.getQuality() < 1.0f) {
                    this.appendParameterSeparator();
                    this.append("q=");
                    this.appendQuality(contact.getQuality());
                }
                if (contact.getExpires() != null) {
                    this.appendParameterSeparator();
                    this.append("expires=");
                    this.append(contact.getExpires());
                }
                for (Parameter param : contact.getParameters()) {
                    this.appendParameterSeparator();
                    this.appendExtension(param);
                }
            }
        }
        return this;
    }

    public ContactInfoWriter appendQuality(float quality) {
        if (!PreferenceWriter.isValidQuality((float)quality)) {
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        formatter.setMaximumFractionDigits(2);
        this.append(formatter.format(quality));
        return this;
    }
}

