/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.GrammarsInfo;
import org.restlet.ext.wadl.IncludeInfo;
import org.restlet.ext.wadl.LinkInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.OptionInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResourceTypeInfo;
import org.restlet.ext.wadl.ResourcesInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WadlRepresentation
extends SaxRepresentation {
    public static final String APP_NAMESPACE = "http://wadl.dev.java.net/2009/02";
    private ApplicationInfo application;

    public WadlRepresentation() {
        super(MediaType.APPLICATION_WADL);
    }

    public WadlRepresentation(ApplicationInfo application) {
        super(MediaType.APPLICATION_WADL);
        this.application = application;
    }

    public WadlRepresentation(Representation xmlRepresentation) throws IOException {
        super(xmlRepresentation);
        this.setMediaType(MediaType.APPLICATION_WADL);
        this.parse(new ContentReader(this));
    }

    public WadlRepresentation(ResourceInfo resource) {
        super(MediaType.APPLICATION_WADL);
        String titleResource;
        this.application = new ApplicationInfo();
        if (!resource.getDocumentations().isEmpty() && (titleResource = resource.getDocumentations().get(0).getTitle()) != null && !"".equals(titleResource)) {
            DocumentationInfo doc = null;
            if (this.application.getDocumentations().isEmpty()) {
                doc = new DocumentationInfo();
                this.application.getDocumentations().add(doc);
            } else {
                doc = this.application.getDocumentations().get(0);
            }
            doc.setTitle(titleResource);
        }
        ResourcesInfo resources = new ResourcesInfo();
        this.application.setResources(resources);
        resources.getResources().add(resource);
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        return null;
    }

    public ApplicationInfo getApplication() {
        return this.application;
    }

    public Representation getHtmlRepresentation() {
        TransformRepresentation representation = null;
        URL wadlHtmlXsltUrl = Engine.getResource((String)"org/restlet/ext/wadl/htmlConvert.xsl");
        if (wadlHtmlXsltUrl != null) {
            try {
                InputRepresentation xslRep = new InputRepresentation(wadlHtmlXsltUrl.openStream(), MediaType.APPLICATION_W3C_XSLT);
                representation = new TransformRepresentation(Context.getCurrent(), (Representation)this, (Representation)xslRep);
                representation.setMediaType(MediaType.TEXT_HTML);
            }
            catch (IOException e) {
                Context.getCurrent().getLogger().log(Level.WARNING, "Unable to generate the WADL HTML representation", e);
            }
        }
        return representation;
    }

    public SAXSource getSaxSource() throws IOException {
        return XmlRepresentation.getSaxSource((Representation)this);
    }

    public void setApplication(ApplicationInfo application) {
        this.application = application;
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.forceNSDecl(APP_NAMESPACE, "");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.processingInstruction("xml", "version=\"1.0\" standalone=\"yes\"");
            writer.processingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"wadl_documentation.xsl\"");
            this.application.writeElement(writer);
            writer.endDocument();
        }
        catch (SAXException e) {
            Context.getCurrentLogger().log(Level.SEVERE, "Error when writing the WADL Representation.", e);
        }
    }

    private static class ContentReader
    extends DefaultHandler
    implements LexicalHandler {
        private ApplicationInfo currentApplication;
        private DocumentationInfo currentDocumentation;
        private GrammarsInfo currentGrammars;
        private IncludeInfo currentInclude;
        private LinkInfo currentLink;
        private MethodInfo currentMethod;
        private CDATASection currentMixedContentCDataSection;
        private Node currentMixedContentNode;
        private OptionInfo currentOption;
        private ParameterInfo currentParameter;
        private RepresentationInfo currentRepresentation;
        private RequestInfo currentRequest;
        private ResourcesInfo currentResources;
        private final List<ResourceInfo> currentResourcesList;
        private ResourceTypeInfo currentResourceType;
        private ResponseInfo currentResponse;
        private Document mixedContentDocument;
        private final List<MixedContentState> mixedContentStates;
        private Node mixedContentTopNode;
        private Map<String, String> namespaces;
        private final List<State> states = new ArrayList<State>();
        private final WadlRepresentation wadlRepresentation;

        public ContentReader(WadlRepresentation wadlRepresentation) {
            this.states.add(State.NONE);
            this.mixedContentStates = new ArrayList<MixedContentState>();
            this.mixedContentStates.add(MixedContentState.NONE);
            this.currentApplication = null;
            this.currentDocumentation = null;
            this.currentGrammars = null;
            this.currentInclude = null;
            this.currentLink = null;
            this.currentMethod = null;
            this.currentOption = null;
            this.currentParameter = null;
            this.currentRepresentation = null;
            this.currentRequest = null;
            this.currentResourcesList = new ArrayList<ResourceInfo>();
            this.currentResources = null;
            this.currentResourceType = null;
            this.currentResponse = null;
            try {
                this.mixedContentDocument = new DomRepresentation(MediaType.TEXT_XML).getDocument();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentMixedContentCDataSection = null;
            this.namespaces = new HashMap<String, String>();
            this.wadlRepresentation = wadlRepresentation;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.getState() == State.DOCUMENTATION) {
                if (this.getMixedContentState() == MixedContentState.CDATA) {
                    this.currentMixedContentCDataSection.appendData(new String(ch, start, length));
                } else if (this.getMixedContentState() != MixedContentState.ENTITY) {
                    this.currentMixedContentNode.appendChild(this.mixedContentDocument.createTextNode(new String(ch, start, length)));
                }
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.getState() == State.DOCUMENTATION) {
                this.currentMixedContentNode.appendChild(this.mixedContentDocument.createComment(new String(ch, start, length)));
            }
        }

        public void endCDATA() throws SAXException {
            if (this.getState() == State.DOCUMENTATION) {
                this.popMixedContentState();
            }
        }

        public void endDocument() throws SAXException {
            this.popState();
            if (this.namespaces != null && !this.namespaces.isEmpty() && this.currentApplication != null) {
                this.currentApplication.setNamespaces(this.namespaces);
            }
            this.wadlRepresentation.setApplication(this.currentApplication);
        }

        public void endDTD() throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (uri.equalsIgnoreCase(WadlRepresentation.APP_NAMESPACE)) {
                if (localName.equals("application")) {
                    this.popState();
                } else if (localName.equals("doc")) {
                    this.currentDocumentation.setMixedContent(this.mixedContentTopNode);
                    this.popState();
                } else if (localName.equals("fault")) {
                    this.popState();
                } else if (localName.equals("grammars")) {
                    this.popState();
                } else if (localName.equals("include")) {
                    this.popState();
                } else if (localName.equals("link")) {
                    this.popState();
                } else if (localName.equals("method")) {
                    this.popState();
                } else if (localName.equals("option")) {
                    this.popState();
                } else if (localName.equals("param")) {
                    this.popState();
                } else if (localName.equals("representation")) {
                    this.popState();
                } else if (localName.equals("request")) {
                    this.popState();
                } else if (localName.equals("resource")) {
                    this.currentResourcesList.remove(0);
                    this.popState();
                } else if (localName.equals("resources")) {
                    this.popState();
                } else if (localName.equals("resource_type")) {
                    this.popState();
                } else if (localName.equals("response")) {
                    this.popState();
                }
            } else if (this.getState() == State.DOCUMENTATION) {
                this.popMixedContentState();
                this.currentMixedContentNode = this.currentMixedContentNode.getParentNode();
            }
        }

        public void endEntity(String name) throws SAXException {
            this.popMixedContentState();
        }

        private MixedContentState getMixedContentState() {
            MixedContentState result = this.mixedContentStates.get(0);
            return result;
        }

        public ParameterStyle getParameterStyle(String parameterStyle) {
            ParameterStyle result = null;
            if ("header".equalsIgnoreCase(parameterStyle)) {
                result = ParameterStyle.HEADER;
            } else if ("matrix".equalsIgnoreCase(parameterStyle)) {
                result = ParameterStyle.MATRIX;
            } else if ("plain".equalsIgnoreCase(parameterStyle)) {
                result = ParameterStyle.PLAIN;
            } else if ("query".equalsIgnoreCase(parameterStyle)) {
                result = ParameterStyle.QUERY;
            } else if ("template".equalsIgnoreCase(parameterStyle)) {
                result = ParameterStyle.TEMPLATE;
            }
            return result;
        }

        private State getState() {
            State result = this.states.get(0);
            return result;
        }

        private MixedContentState popMixedContentState() {
            return this.mixedContentStates.remove(0);
        }

        private State popState() {
            return this.states.remove(0);
        }

        private void pushMixedContentState(MixedContentState state) {
            this.mixedContentStates.add(0, state);
        }

        private void pushState(State state) {
            this.states.add(0, state);
        }

        public void startCDATA() throws SAXException {
            if (this.getState() == State.DOCUMENTATION) {
                this.pushMixedContentState(MixedContentState.CDATA);
                this.currentMixedContentCDataSection = this.mixedContentDocument.createCDATASection("");
                this.currentMixedContentNode.appendChild(this.currentMixedContentCDataSection);
            }
        }

        public void startDocument() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (uri.equalsIgnoreCase(WadlRepresentation.APP_NAMESPACE)) {
                if (localName.equals("application")) {
                    this.currentApplication = new ApplicationInfo();
                    this.pushState(State.APPLICATION);
                } else if (localName.equals("doc")) {
                    this.currentDocumentation = new DocumentationInfo();
                    this.currentMixedContentNode = this.mixedContentTopNode = this.mixedContentDocument.createDocumentFragment();
                    this.currentMixedContentCDataSection = null;
                    if (attrs.getIndex("xml:lang") != -1) {
                        this.currentDocumentation.setLanguage(Language.valueOf((String)attrs.getValue("xml:lang")));
                    }
                    if (attrs.getIndex("lang") != -1) {
                        this.currentDocumentation.setLanguage(Language.valueOf((String)attrs.getValue("lang")));
                    }
                    if (attrs.getIndex("title") != -1) {
                        this.currentDocumentation.setTitle(attrs.getValue("title"));
                    }
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.GRAMMARS) {
                        this.currentGrammars.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.INCLUDE) {
                        this.currentInclude.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.LINK) {
                        this.currentLink.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.METHOD) {
                        this.currentMethod.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.OPTION) {
                        this.currentOption.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.PARAMETER) {
                        this.currentParameter.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.REPRESENTATION) {
                        this.currentRepresentation.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.REQUEST) {
                        this.currentRequest.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.RESOURCE) {
                        this.currentResourcesList.get(0).getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.RESOURCES) {
                        this.currentResources.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.RESOURCETYPE) {
                        this.currentResourceType.getDocumentations().add(this.currentDocumentation);
                    } else if (this.getState() == State.RESPONSE) {
                        this.currentResponse.getDocumentations().add(this.currentDocumentation);
                    }
                    this.pushState(State.DOCUMENTATION);
                } else if (localName.equals("grammars")) {
                    this.currentGrammars = new GrammarsInfo();
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.setGrammars(this.currentGrammars);
                    }
                    this.pushState(State.GRAMMARS);
                } else if (localName.equals("include")) {
                    this.currentInclude = new IncludeInfo();
                    if (attrs.getIndex("href") != -1) {
                        this.currentInclude.setTargetRef(new Reference(attrs.getValue("href")));
                    }
                    if (this.getState() == State.GRAMMARS) {
                        this.currentGrammars.getIncludes().add(this.currentInclude);
                    }
                    this.pushState(State.INCLUDE);
                } else if (localName.equals("link")) {
                    this.currentLink = new LinkInfo();
                    if (attrs.getIndex("rel") != -1) {
                        this.currentLink.setRelationship(attrs.getValue("rel"));
                    }
                    if (attrs.getIndex("rev") != -1) {
                        this.currentLink.setReverseRelationship(attrs.getValue("rev"));
                    }
                    if (attrs.getIndex("resource_type") != -1) {
                        this.currentLink.setResourceType(new Reference(attrs.getValue("resource_type")));
                    }
                    if (this.getState() == State.PARAMETER) {
                        this.currentParameter.setLink(this.currentLink);
                    }
                    this.pushState(State.LINK);
                } else if (localName.equals("method")) {
                    this.currentMethod = new MethodInfo();
                    if (attrs.getIndex("href") != -1) {
                        this.currentMethod.setTargetRef(new Reference(attrs.getValue("href")));
                    }
                    if (attrs.getIndex("id") != -1) {
                        this.currentMethod.setIdentifier(attrs.getValue("id"));
                    }
                    if (attrs.getIndex("name") != -1) {
                        this.currentMethod.setName(Method.valueOf((String)attrs.getValue("name")));
                    }
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.getMethods().add(this.currentMethod);
                    } else if (this.getState() == State.RESOURCE) {
                        this.currentResourcesList.get(0).getMethods().add(this.currentMethod);
                    } else if (this.getState() == State.RESOURCETYPE) {
                        this.currentResourceType.getMethods().add(this.currentMethod);
                    }
                    this.pushState(State.METHOD);
                } else if (localName.equals("option")) {
                    this.currentOption = new OptionInfo();
                    if (attrs.getIndex("value") != -1) {
                        this.currentOption.setValue(attrs.getValue("value"));
                    }
                    if (this.getState() == State.PARAMETER) {
                        this.currentParameter.getOptions().add(this.currentOption);
                    }
                    this.pushState(State.OPTION);
                } else if (localName.equals("param")) {
                    this.currentParameter = new ParameterInfo();
                    if (attrs.getIndex("default") != -1) {
                        this.currentParameter.setDefaultValue(attrs.getValue("default"));
                    }
                    if (attrs.getIndex("fixed") != -1) {
                        this.currentParameter.setFixed(attrs.getValue("fixed"));
                    }
                    if (attrs.getIndex("id") != -1) {
                        this.currentParameter.setIdentifier(attrs.getValue("id"));
                    }
                    if (attrs.getIndex("path") != -1) {
                        this.currentParameter.setPath(attrs.getValue("path"));
                    }
                    if (attrs.getIndex("style") != -1) {
                        this.currentParameter.setStyle(this.getParameterStyle(attrs.getValue("style")));
                    }
                    if (attrs.getIndex("name") != -1) {
                        this.currentParameter.setName(attrs.getValue("name"));
                    }
                    if (attrs.getIndex("type") != -1) {
                        this.currentParameter.setType(attrs.getValue("type"));
                    }
                    if (attrs.getIndex("repeating") != -1) {
                        this.currentParameter.setRepeating(Boolean.parseBoolean(attrs.getValue("repeating")));
                    }
                    if (attrs.getIndex("required") != -1) {
                        this.currentParameter.setRequired(Boolean.parseBoolean(attrs.getValue("required")));
                    }
                    if (this.getState() == State.REPRESENTATION) {
                        this.currentRepresentation.getParameters().add(this.currentParameter);
                    } else if (this.getState() == State.REQUEST) {
                        this.currentRequest.getParameters().add(this.currentParameter);
                    } else if (this.getState() == State.RESOURCE) {
                        this.currentResourcesList.get(0).getParameters().add(this.currentParameter);
                    } else if (this.getState() == State.RESOURCETYPE) {
                        this.currentRequest.getParameters().add(this.currentParameter);
                    } else if (this.getState() == State.RESPONSE) {
                        this.currentRequest.getParameters().add(this.currentParameter);
                    }
                    this.pushState(State.PARAMETER);
                } else if (localName.equals("representation")) {
                    this.currentRepresentation = new RepresentationInfo();
                    if (attrs.getIndex("id") != -1) {
                        this.currentRepresentation.setIdentifier(attrs.getValue("id"));
                    }
                    if (attrs.getIndex("mediaType") != -1) {
                        this.currentRepresentation.setMediaType(MediaType.valueOf((String)attrs.getValue("mediaType")));
                    }
                    if (attrs.getIndex("element") != -1) {
                        this.currentRepresentation.setXmlElement(attrs.getValue("element"));
                    }
                    if (attrs.getIndex("profile") != -1) {
                        String[] profiles;
                        for (String string : profiles = attrs.getValue("profile").split(" ")) {
                            this.currentRepresentation.getProfiles().add(new Reference(string));
                        }
                    }
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.getRepresentations().add(this.currentRepresentation);
                    } else if (this.getState() == State.REQUEST) {
                        this.currentRequest.getRepresentations().add(this.currentRepresentation);
                    } else if (this.getState() == State.RESPONSE) {
                        this.currentResponse.getRepresentations().add(this.currentRepresentation);
                    }
                    this.pushState(State.REPRESENTATION);
                } else if (localName.equals("request")) {
                    this.currentRequest = new RequestInfo();
                    if (this.getState() == State.METHOD) {
                        this.currentMethod.setRequest(this.currentRequest);
                    }
                    this.pushState(State.REQUEST);
                } else if (localName.equals("resource")) {
                    ResourceInfo resourceInfo = new ResourceInfo();
                    if (attrs.getIndex("id") != -1) {
                        resourceInfo.setIdentifier(attrs.getValue("id"));
                    }
                    if (attrs.getIndex("path") != -1) {
                        resourceInfo.setPath(attrs.getValue("path"));
                    }
                    if (attrs.getIndex("queryType") != -1) {
                        resourceInfo.setQueryType(MediaType.valueOf((String)attrs.getValue("queryType")));
                    }
                    if (attrs.getIndex("type") != -1) {
                        String[] type;
                        for (String string : type = attrs.getValue("type").split(" ")) {
                            resourceInfo.getType().add(new Reference(string));
                        }
                    }
                    if (this.getState() == State.RESOURCE) {
                        this.currentResourcesList.get(0).getChildResources().add(resourceInfo);
                    } else if (this.getState() == State.RESOURCES) {
                        this.currentResources.getResources().add(resourceInfo);
                    }
                    this.currentResourcesList.add(0, resourceInfo);
                    this.pushState(State.RESOURCE);
                } else if (localName.equals("resources")) {
                    this.currentResources = new ResourcesInfo();
                    if (attrs.getIndex("base") != -1) {
                        this.currentResources.setBaseRef(new Reference(attrs.getValue("base")));
                    }
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.setResources(this.currentResources);
                    }
                    this.pushState(State.RESOURCES);
                } else if (localName.equals("resource_type")) {
                    this.currentResourceType = new ResourceTypeInfo();
                    if (attrs.getIndex("id") != -1) {
                        this.currentResourceType.setIdentifier(attrs.getValue("id"));
                    }
                    if (this.getState() == State.APPLICATION) {
                        this.currentApplication.getResourceTypes().add(this.currentResourceType);
                    }
                    this.pushState(State.RESOURCETYPE);
                } else if (localName.equals("response")) {
                    this.currentResponse = new ResponseInfo();
                    if (attrs.getIndex("status") != -1) {
                        String[] statuses;
                        for (String string : statuses = attrs.getValue("status").split(" ")) {
                            this.currentResponse.getStatuses().add(Status.valueOf((int)Integer.parseInt(string)));
                        }
                    }
                    if (this.getState() == State.METHOD) {
                        this.currentMethod.getResponses().add(this.currentResponse);
                    }
                    this.pushState(State.RESPONSE);
                }
            } else if (this.getState() == State.DOCUMENTATION) {
                this.pushMixedContentState(MixedContentState.ELEMENT);
                Element node = null;
                node = "".equals(qName) || qName == null ? this.mixedContentDocument.createElementNS(uri, localName) : this.mixedContentDocument.createElementNS(uri, qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = this.mixedContentDocument.createAttributeNS(attrs.getURI(i), attrs.getLocalName(i));
                    attr.setNodeValue(attrs.getValue(i));
                    node.getAttributes().setNamedItemNS(attr);
                }
                this.currentMixedContentNode.appendChild(node);
                this.currentMixedContentNode = node;
            }
        }

        public void startEntity(String name) throws SAXException {
            this.pushMixedContentState(MixedContentState.ENTITY);
            this.currentMixedContentNode.appendChild(this.mixedContentDocument.createEntityReference(name));
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.namespaces.put(arg1, arg0);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum State {
            APPLICATION,
            DOCUMENTATION,
            FAULT,
            GRAMMARS,
            INCLUDE,
            LINK,
            METHOD,
            NONE,
            OPTION,
            PARAMETER,
            REPRESENTATION,
            REQUEST,
            RESOURCE,
            RESOURCES,
            RESOURCETYPE,
            RESPONSE;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum MixedContentState {
            CDATA,
            COMMENT,
            ELEMENT,
            ENTITY,
            NONE,
            TEXT;

        }
    }
}

