/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeInfo
extends DocumentedInfo {
    private String identifier;
    private List<MethodInfo> methods;
    private List<ParameterInfo> parameters;

    public ResourceTypeInfo() {
    }

    public ResourceTypeInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ResourceTypeInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ResourceTypeInfo(String documentation) {
        super(documentation);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodInfo> getMethods() {
        List<MethodInfo> m = this.methods;
        if (m == null) {
            ResourceTypeInfo resourceTypeInfo = this;
            synchronized (resourceTypeInfo) {
                m = this.methods;
                if (m == null) {
                    this.methods = m = new ArrayList<MethodInfo>();
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            ResourceTypeInfo resourceTypeInfo = this;
            synchronized (resourceTypeInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMethods(List<MethodInfo> methods) {
        this.methods = methods;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        for (MethodInfo methodInfo : this.getMethods()) {
            methodInfo.updateNamespaces(namespaces);
        }
        for (ParameterInfo parameterInfo : this.getParameters()) {
            parameterInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getDocumentations().isEmpty() && this.getMethods().isEmpty() && this.getParameters().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "resource_type", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "resource_type", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (MethodInfo methodInfo : this.getMethods()) {
                methodInfo.writeElement(writer);
            }
            for (ParameterInfo parameterInfo : this.getParameters()) {
                parameterInfo.writeElement(writer);
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "resource_type");
        }
    }
}

