/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;
import org.w3c.dom.Document;

public class XmlConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, Document.class);
            result = this.addObjectClass(result, DomRepresentation.class);
            result = this.addObjectClass(result, SaxRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (Document.class.isAssignableFrom(source) || DomRepresentation.class.isAssignableFrom(source) || SaxRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof Document) {
            result = target == null ? 0.5f : (MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)target.getMediaType()) ? 0.8f : (MediaType.APPLICATION_XML.isCompatible((Metadata)target.getMediaType()) ? 0.9f : (MediaType.TEXT_XML.isCompatible((Metadata)target.getMediaType()) ? 0.9f : 0.5f)));
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null && (Document.class.isAssignableFrom(target) || DomRepresentation.class.isAssignableFrom(target) || SaxRepresentation.class.isAssignableFrom(target))) {
            result = MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)source.getMediaType()) ? 0.8f : (MediaType.APPLICATION_XML.isCompatible((Metadata)source.getMediaType()) ? 0.9f : (MediaType.TEXT_XML.isCompatible((Metadata)source.getMediaType()) ? 0.9f : 0.5f));
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        Object result = null;
        if (Document.class.isAssignableFrom(target)) {
            result = new DomRepresentation(source).getDocument();
        } else if (DomRepresentation.class.isAssignableFrom(target)) {
            result = new DomRepresentation(source);
        } else if (SaxRepresentation.class.isAssignableFrom(target)) {
            result = new SaxRepresentation(source);
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        Object result = null;
        if (source instanceof Document) {
            result = new DomRepresentation(target.getMediaType(), (Document)source);
        } else if (source instanceof Representation) {
            result = (Representation)source;
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (Document.class.isAssignableFrom(entity) || DomRepresentation.class.isAssignableFrom(entity) || SaxRepresentation.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 0.8f);
            this.updatePreferences(preferences, MediaType.APPLICATION_XML, 0.9f);
            this.updatePreferences(preferences, MediaType.TEXT_XML, 0.9f);
        }
    }
}

