/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta.instrumentation;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.instrumentation.util.BloatUtil;
import com.db4o.instrumentation.util.LabelGenerator;
import com.db4o.ta.Activatable;

class InjectTAInfrastructureEdit
implements BloatClassEdit {
    private final LocalVariable THIS_VAR = new LocalVariable(0);
    private final ClassFilter _instrumentedClassesFilter;

    public InjectTAInfrastructureEdit(ClassFilter instrumentedClassesFilter) {
        this._instrumentedClassesFilter = instrumentedClassesFilter;
    }

    public InstrumentationStatus enhance(ClassEditor ce, ClassLoader origLoader, BloatLoaderContext loaderContext) {
        if (this.isActivatableItself(ce)) {
            return InstrumentationStatus.FAILED;
        }
        if (this.isAlreadyInstrumented(ce, loaderContext)) {
            return InstrumentationStatus.NOT_INSTRUMENTED;
        }
        try {
            Class clazz = BloatUtil.classForEditor((ClassEditor)ce, (ClassLoader)origLoader);
            Class<?> activatableClazz = origLoader.loadClass(Activatable.class.getName());
            if (activatableClazz.isAssignableFrom(clazz)) {
                return InstrumentationStatus.NOT_INSTRUMENTED;
            }
            if (!this._instrumentedClassesFilter.accept(clazz)) {
                return InstrumentationStatus.NOT_INSTRUMENTED;
            }
            String superClassName = BloatUtil.normalizeClassName((Type)ce.superclass());
            Class<?> superClazz = origLoader.loadClass(superClassName);
            if (!this._instrumentedClassesFilter.accept(superClazz)) {
                ce.addInterface(Activatable.class);
                this.createActivatorField(ce);
                this.createBindMethod(ce);
                this.createActivateMethod(ce);
                ce.commit();
                return InstrumentationStatus.INSTRUMENTED;
            }
            return InstrumentationStatus.NOT_INSTRUMENTED;
        }
        catch (ClassNotFoundException exc) {
            return InstrumentationStatus.FAILED;
        }
    }

    private boolean isEnum(Class clazz) {
        return clazz.isEnum();
    }

    private boolean isActivatableItself(ClassEditor ce) {
        return BloatUtil.implementsDirectly((ClassEditor)ce, Activatable.class);
    }

    private boolean isAlreadyInstrumented(ClassEditor ce, BloatLoaderContext context) {
        try {
            return BloatUtil.implementsInHierarchy((ClassEditor)ce, Activatable.class, (BloatLoaderContext)context);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void createActivatorField(ClassEditor ce) {
        FieldEditor fieldEditor = new FieldEditor(ce, 130, Type.getType(Activator.class), "_db4o$$ta$$activator");
        fieldEditor.commit();
    }

    private void createBindMethod(ClassEditor ce) {
        Type activatorType = Type.getType(Activator.class);
        String methodName = "bind";
        Type[] paramTypes = new Type[]{activatorType};
        MethodEditor methodEditor = new MethodEditor(ce, 1, Type.VOID, methodName, paramTypes, new Type[0]);
        LabelGenerator labelGen = new LabelGenerator();
        Label startLabel = labelGen.createLabel(true);
        Label differentActivatorLabel = labelGen.createLabel(true);
        Label setActivatorLabel = labelGen.createLabel(true);
        LocalVariable activatorArg = new LocalVariable(1);
        methodEditor.addLabel(startLabel);
        this.loadActivatorFieldOnStack(methodEditor);
        methodEditor.addInstruction(25, (Object)activatorArg);
        methodEditor.addInstruction(166, (Object)differentActivatorLabel);
        methodEditor.addInstruction(177);
        methodEditor.addLabel(differentActivatorLabel);
        methodEditor.addInstruction(25, (Object)activatorArg);
        methodEditor.addInstruction(198, (Object)setActivatorLabel);
        this.loadActivatorFieldOnStack(methodEditor);
        methodEditor.addInstruction(198, (Object)setActivatorLabel);
        this.throwException(methodEditor, IllegalStateException.class);
        methodEditor.addLabel(setActivatorLabel);
        this.loadThisOnStack(methodEditor);
        methodEditor.addInstruction(25, (Object)activatorArg);
        methodEditor.addInstruction(181, (Object)this.createFieldReference(ce.type(), "_db4o$$ta$$activator", activatorType));
        methodEditor.addInstruction(177);
        methodEditor.commit();
    }

    private void throwException(MethodEditor methodEditor, Class exceptionType) {
        Type illegalStateExceptionType = Type.getType((Class)exceptionType);
        methodEditor.addInstruction(187, (Object)illegalStateExceptionType);
        methodEditor.addInstruction(89);
        methodEditor.addInstruction(183, (Object)this.createMethodReference(illegalStateExceptionType, "<init>", new Type[0], Type.VOID));
        methodEditor.addInstruction(191);
    }

    private void createActivateMethod(ClassEditor ce) {
        Type activationPurpose = Type.getType(ActivationPurpose.class);
        Type activatorType = Type.getType(Activator.class);
        String methodName = "activate";
        MethodEditor methodEditor = new MethodEditor(ce, 1, Type.VOID, methodName, new Type[]{activationPurpose}, new Type[0]);
        LabelGenerator labelGen = new LabelGenerator();
        Label startLabel = labelGen.createLabel(true);
        Label activateLabel = labelGen.createLabel(true);
        methodEditor.addLabel(startLabel);
        this.loadActivatorFieldOnStack(methodEditor);
        methodEditor.addInstruction(199, (Object)activateLabel);
        methodEditor.addInstruction(177);
        methodEditor.addLabel(activateLabel);
        this.loadActivatorFieldOnStack(methodEditor);
        methodEditor.addInstruction(25, (Object)new LocalVariable(1));
        methodEditor.addInstruction(185, (Object)this.createMethodReference(activatorType, "activate", new Type[]{activationPurpose}, Type.VOID));
        methodEditor.addInstruction(177);
        methodEditor.commit();
    }

    private void loadThisOnStack(MethodEditor methodEditor) {
        methodEditor.addInstruction(25, (Object)this.THIS_VAR);
    }

    private void loadActivatorFieldOnStack(MethodEditor methodEditor) {
        Type activatorType = Type.getType(Activator.class);
        this.loadThisOnStack(methodEditor);
        methodEditor.addInstruction(180, (Object)this.createFieldReference(methodEditor.declaringClass().type(), "_db4o$$ta$$activator", activatorType));
    }

    private MemberRef createMethodReference(Type parent, String name, Type[] args, Type ret) {
        return this.createMemberRef(parent, name, Type.getType((Type[])args, (Type)ret));
    }

    private MemberRef createMemberRef(Type parent, String name, Type type) {
        NameAndType nameAndType = new NameAndType(name, type);
        return new MemberRef(parent, nameAndType);
    }

    private MemberRef createFieldReference(Type parent, String name, Type type) {
        return this.createMemberRef(parent, name, type);
    }
}

