/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.DefragmentServices;
import com.db4o.defragment.IDMappingCollector;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.mapping.IdSource;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;
import com.db4o.io.FileStorage;
import com.db4o.io.NonFlushingStorage;
import com.db4o.io.Storage;
import com.db4o.typehandlers.TypeHandler4;
import java.io.IOException;

public class DefragmentServicesImpl
implements DefragmentServices {
    public static final DbSelector SOURCEDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._sourceDb;
        }
    };
    public static final DbSelector TARGETDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._targetDb;
        }
    };
    public final LocalObjectContainer _sourceDb;
    final LocalObjectContainer _targetDb;
    private final ContextIDMapping _mapping;
    private DefragmentListener _listener;
    private Queue4 _unindexed = new NonblockingQueue();
    private final Hashtable4 _hasFieldIndexCache = new Hashtable4();
    private DefragmentConfig _defragConfig;
    private Hashtable4 _classIndices = new Hashtable4(16);

    public DefragmentServicesImpl(DefragmentConfig defragConfig, DefragmentListener listener) throws IOException {
        this._listener = listener;
        Config4Impl originalConfig = (Config4Impl)defragConfig.db4oConfig();
        Config4Impl sourceConfig = (Config4Impl)originalConfig.deepClone(null);
        sourceConfig.weakReferences(false);
        Storage storage = defragConfig.backupStorage();
        if (defragConfig.readOnly()) {
            storage = new NonFlushingStorage(storage);
        }
        sourceConfig.storage(storage);
        sourceConfig.readOnly(defragConfig.readOnly());
        this._sourceDb = (LocalObjectContainer)Db4o.openFile(sourceConfig, defragConfig.tempPath()).ext();
        this._sourceDb.showInternalClasses(true);
        this._targetDb = DefragmentServicesImpl.freshTargetFile(defragConfig);
        this._mapping = defragConfig.mapping();
        this._mapping.open();
        this._defragConfig = defragConfig;
    }

    static LocalObjectContainer freshTempFile(String fileName, int blockSize) throws IOException {
        FileStorage storage = new FileStorage();
        storage.delete(fileName);
        Configuration db4oConfig = DefragmentConfig.vanillaDb4oConfig(blockSize);
        db4oConfig.storage(storage);
        return (LocalObjectContainer)Db4o.openFile(db4oConfig, fileName).ext();
    }

    static LocalObjectContainer freshTargetFile(DefragmentConfig config) throws IOException {
        config.db4oConfig().storage().delete(config.origPath());
        return (LocalObjectContainer)Db4o.openFile(config.clonedDb4oConfig(), config.origPath()).ext();
    }

    public int mappedID(int oldID, int defaultID) {
        int mapped = this.internalMappedID(oldID, false);
        return mapped != 0 ? mapped : defaultID;
    }

    public int mappedID(int oldID) throws MappingNotFoundException {
        int mapped = this.internalMappedID(oldID, false);
        if (mapped == 0) {
            throw new MappingNotFoundException(oldID);
        }
        return mapped;
    }

    public int mappedID(int id, boolean lenient) throws MappingNotFoundException {
        if (id == 0) {
            return 0;
        }
        int mapped = this.internalMappedID(id, lenient);
        if (mapped == 0) {
            this._listener.notifyDefragmentInfo(new DefragmentInfo("No mapping found for ID " + id));
            return 0;
        }
        return mapped;
    }

    private int internalMappedID(int oldID, boolean lenient) throws MappingNotFoundException {
        if (oldID == 0) {
            return 0;
        }
        if (this._sourceDb.handlers().isSystemHandler(oldID)) {
            return oldID;
        }
        return this._mapping.mappedID(oldID, lenient);
    }

    public void mapIDs(int oldID, int newID, boolean isClassID) {
        this._mapping.mapIDs(oldID, newID, isClassID);
    }

    public void close() {
        this._sourceDb.close();
        this._targetDb.close();
        this._mapping.close();
    }

    public ByteArrayBuffer bufferByID(DbSelector selector, int id) {
        Slot slot = this.readPointer(selector, id);
        return this.bufferByAddress(selector, slot.address(), slot.length());
    }

    public ByteArrayBuffer sourceBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(SOURCEDB, address, length);
    }

    public ByteArrayBuffer targetBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(TARGETDB, address, length);
    }

    public ByteArrayBuffer bufferByAddress(DbSelector selector, int address, int length) {
        return selector.db(this).decryptedBufferByAddress(address, length);
    }

    public StatefulBuffer targetStatefulBufferByAddress(int address, int length) throws IllegalArgumentException {
        return this._targetDb.readWriterByAddress(TARGETDB.transaction(this), address, length);
    }

    public Slot allocateTargetSlot(int length) {
        return this._targetDb.getSlot(length);
    }

    public void targetWriteBytes(DefragmentContextImpl context, int address) {
        context.write(this._targetDb, address);
    }

    public void targetWriteBytes(ByteArrayBuffer reader, int address) {
        this._targetDb.writeBytes(reader, address, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        db.showInternalClasses(true);
        try {
            StoredClass[] storedClassArray = db.classCollection().storedClasses();
            return storedClassArray;
        }
        finally {
            db.showInternalClasses(false);
        }
    }

    public LatinStringIO stringIO() {
        return this._sourceDb.stringIO();
    }

    public void targetCommit() {
        this._targetDb.commit();
    }

    public TypeHandler4 sourceHandler(int id) {
        return this._sourceDb.typeHandlerForClassMetadataID(id);
    }

    public int sourceClassCollectionID() {
        return this._sourceDb.classCollection().getID();
    }

    public int classIndexID(ClassMetadata classMetadata) {
        return this.classIndex(classMetadata).id();
    }

    public void traverseAll(ClassMetadata classMetadata, Visitor4 command) {
        if (!classMetadata.hasClassIndex()) {
            return;
        }
        classMetadata.index().traverseAll(SOURCEDB.transaction(this), command);
    }

    public void traverseAllIndexSlots(ClassMetadata classMetadata, Visitor4 command) {
        Iterator4 slotIDIter = classMetadata.index().allSlotIDs(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    public void traverseAllIndexSlots(BTree btree, Visitor4 command) {
        Iterator4 slotIDIter = btree.allNodeIds(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    public void registerBTreeIDs(BTree btree, final IDMappingCollector collector) {
        collector.createIDMapping(this, btree.getID(), false);
        this.traverseAllIndexSlots(btree, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                collector.createIDMapping(DefragmentServicesImpl.this, id, false);
            }
        });
    }

    public int databaseIdentityID(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        Db4oDatabase identity = db.identity();
        if (identity == null) {
            return 0;
        }
        return identity.getID(selector.transaction(this));
    }

    private ClassIndexStrategy classIndex(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndex = (ClassIndexStrategy)this._classIndices.get(classMetadata);
        if (classIndex == null) {
            classIndex = new BTreeClassIndexStrategy(classMetadata);
            this._classIndices.put(classMetadata, (Object)classIndex);
            classIndex.initialize(this._targetDb);
        }
        return classIndex;
    }

    public Transaction systemTrans() {
        return SOURCEDB.transaction(this);
    }

    public void copyIdentity() {
        this._targetDb.setIdentity(this._sourceDb.identity());
    }

    public void targetClassCollectionID(int newClassCollectionID) {
        this._targetDb.systemData().classCollectionID(newClassCollectionID);
    }

    public ByteArrayBuffer sourceBufferByID(int sourceID) {
        return this.bufferByID(SOURCEDB, sourceID);
    }

    public BTree sourceUuidIndex() {
        if (this.sourceUuidIndexID() == 0) {
            return null;
        }
        return this._sourceDb.uUIDIndex().getIndex(this.systemTrans());
    }

    public void targetUuidIndexID(int id) {
        this._targetDb.systemData().uuidIndexId(id);
    }

    public int sourceUuidIndexID() {
        return this._sourceDb.systemData().uuidIndexId();
    }

    public ClassMetadata classMetadataForId(int id) {
        return this._sourceDb.classMetadataForID(id);
    }

    public void registerUnindexed(int id) {
        this._unindexed.add(new Integer(id));
    }

    public IdSource unindexedIDs() {
        return new IdSource(this._unindexed);
    }

    public ObjectHeader sourceObjectHeader(ByteArrayBuffer buffer) {
        return new ObjectHeader(this._sourceDb, (ReadWriteBuffer)buffer);
    }

    private Slot readPointer(DbSelector selector, int id) {
        ByteArrayBuffer reader = selector.db(this).rawBufferByAddress(id, 8);
        int address = reader.readInt();
        int length = reader.readInt();
        return new Slot(address, length);
    }

    public boolean hasFieldIndex(ClassMetadata clazz) {
        TernaryBool cachedHasFieldIndex = (TernaryBool)this._hasFieldIndexCache.get(clazz);
        if (cachedHasFieldIndex != null) {
            return cachedHasFieldIndex.definiteYes();
        }
        final BooleanByRef hasFieldIndex = new BooleanByRef(false);
        for (ClassMetadata curClazz = clazz; !hasFieldIndex.value && curClazz != null; curClazz = curClazz.getAncestor()) {
            curClazz.traverseDeclaredFields(new Procedure4(){

                public void apply(Object arg) {
                    FieldMetadata curField = (FieldMetadata)arg;
                    if (curField.hasIndex() && Handlers4.isIndirectedIndexed(curField.getHandler())) {
                        hasFieldIndex.value = true;
                    }
                }
            });
        }
        this._hasFieldIndexCache.put(clazz, (Object)TernaryBool.forBoolean(hasFieldIndex.value));
        return hasFieldIndex.value;
    }

    public int blockSize() {
        return this._sourceDb.config().blockSize();
    }

    public int sourceAddressByID(int sourceID) {
        return this.readPointer(SOURCEDB, sourceID).address();
    }

    public boolean accept(StoredClass klass) {
        return this._defragConfig.storedClassFilter().accept(klass);
    }

    public static abstract class DbSelector {
        DbSelector() {
        }

        abstract LocalObjectContainer db(DefragmentServicesImpl var1);

        Transaction transaction(DefragmentServicesImpl context) {
            return this.db(context).systemTransaction();
        }
    }
}

