/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.io.Path4;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class File4 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String fname) throws FileNotFoundException, IOException {
        File file = new File(fname);
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        try {
            fis.read(bytes);
        }
        finally {
            fis.close();
        }
        return bytes;
    }

    public static void rename(String oldPath, String newPath) throws IOException {
        if (!new File(oldPath).renameTo(new File(newPath))) {
            throw new IOException("Could not rename '" + oldPath + "' to '" + newPath + "'.");
        }
    }

    public static void copy(String source, String target) throws IOException {
        File sourceFile = new File(source);
        File targetFile = new File(target);
        targetFile.mkdirs();
        targetFile.delete();
        if (sourceFile.isDirectory()) {
            File4.copyDirectory(sourceFile, targetFile);
        } else {
            File4.copyFile(sourceFile, targetFile);
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        int numRead;
        int bufferSize = 64000;
        RandomAccessFile rafIn = new RandomAccessFile(source.getAbsolutePath(), "r");
        RandomAccessFile rafOut = new RandomAccessFile(target.getAbsolutePath(), "rw");
        long len = rafIn.length();
        byte[] bytes = new byte[64000];
        for (long totalRead = 0L; totalRead < len; totalRead += (long)numRead) {
            numRead = rafIn.read(bytes, 0, 64000);
            rafOut.write(bytes, 0, numRead);
        }
        rafIn.close();
        rafOut.close();
    }

    private static void copyDirectory(File source, File target) throws IOException {
        String[] files = source.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File4.copy(Path4.combine(source.getAbsolutePath(), files[i]), Path4.combine(target.getAbsolutePath(), files[i]));
            }
        }
    }

    public static void delete(String fname) {
        File file = new File(fname);
        if (!file.exists()) {
            return;
        }
        File4.translateDeleteFailureToException(file);
    }

    static void translateDeleteFailureToException(File file) {
        if (!file.delete()) {
            throw new Db4oIOException("Could not delete '" + file.getName() + "'.");
        }
    }

    public static boolean exists(String fname) {
        return new File(fname).exists();
    }

    public static void mkdirs(String path) {
        new File(path).mkdirs();
    }

    public static long size(String filePath) {
        File f = new File(filePath);
        return f.length();
    }
}

