/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.ObjectTranslator;
import com.db4o.config.TCollection;
import com.db4o.config.THashtable;
import com.db4o.config.TMap;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ActiveObjectReference;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.JDKReflect;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceQueue4;
import com.db4o.internal.TypeHandlerConfigurationJDK_1_2;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.net.NetDateTime;
import com.db4o.internal.handlers.net.NetDecimal;
import com.db4o.internal.handlers.net.NetSByte;
import com.db4o.internal.handlers.net.NetUInt;
import com.db4o.internal.handlers.net.NetULong;
import com.db4o.internal.handlers.net.NetUShort;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericReflector;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class JDK_1_2
extends JDKReflect {
    JDK_1_2() {
    }

    public Class loadClass(String className, Object loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return Class.forName(className, false, (ClassLoader)loader);
    }

    Object createReferenceQueue() {
        return new ReferenceQueue4();
    }

    public Object createWeakReference(Object obj) {
        return new WeakReference<Object>(obj);
    }

    Object createActivateObjectReference(Object referenceQueue, ObjectReference objectReference, Object obj) {
        return new ActiveObjectReference(referenceQueue, objectReference, obj);
    }

    public void extendConfiguration(Config4Impl config) {
        new TypeHandlerConfigurationJDK_1_2(config).apply();
    }

    void forEachCollectionElement(Object a_object, Visitor4 a_visitor) {
        Iterator<Object> i = null;
        if (a_object instanceof Collection) {
            i = ((Collection)a_object).iterator();
        } else if (a_object instanceof Map) {
            i = ((Map)a_object).keySet().iterator();
        }
        if (i != null) {
            while (i.hasNext()) {
                a_visitor.visit(i.next());
            }
        }
    }

    Object getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    Object getYapRefObject(Object a_object) {
        if (a_object instanceof ActiveObjectReference) {
            return ((ActiveObjectReference)a_object).get();
        }
        return a_object;
    }

    boolean isCollectionTranslator(Config4Class config) {
        ObjectTranslator ot;
        if (config != null && (ot = config.getTranslator()) != null) {
            return ot instanceof TCollection || ot instanceof TMap || ot instanceof THashtable;
        }
        return false;
    }

    public int ver() {
        return 2;
    }

    void killYapRef(Object obj) {
        if (obj instanceof ActiveObjectReference) {
            ((ActiveObjectReference)obj)._referent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollReferenceQueue(ObjectContainerBase container, Object referenceQueue) {
        if (referenceQueue == null) {
            return;
        }
        ReferenceQueue4 queue = (ReferenceQueue4)referenceQueue;
        Object object = container.lock();
        synchronized (object) {
            ActiveObjectReference ref;
            while ((ref = queue.pollObjectReference()) != null) {
                container.removeFromAllReferenceSystems(ref._referent);
            }
        }
    }

    public void registerCollections(GenericReflector reflector) {
        reflector.registerCollection(Collection.class);
        reflector.registerCollection(Map.class);
    }

    void setAccessible(Object a_accessible) {
        try {
            ((AccessibleObject)a_accessible).setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public NetTypeHandler[] netTypes(Reflector reflector) {
        return new NetTypeHandler[]{new NetDateTime(reflector), new NetDecimal(reflector), new NetSByte(reflector), new NetUInt(reflector), new NetULong(reflector), new NetUShort(reflector)};
    }

    public Object weakReferenceTarget(Object weakRef) {
        if (weakRef instanceof WeakReference) {
            return ((WeakReference)weakRef).get();
        }
        return weakRef;
    }
}

