/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.Debug4;
import com.db4o.Internal4;
import com.db4o.ObjectSet;
import com.db4o.Rename;
import com.db4o.config.Configuration;
import com.db4o.config.Entry;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.CompositeDb4oException;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.Db4oIllegalStateException;
import com.db4o.ext.Db4oRecoverableException;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.InvalidSlotException;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.OldFormatException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Environment;
import com.db4o.foundation.Environments;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntIdGenerator;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.PersistentTimeStampIdGenerator;
import com.db4o.foundation.Tree;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataRepository;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.InCallback;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.MessageOutput;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectAnalyzer;
import com.db4o.internal.ObjectContainerSpec;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReflectorConfigurationImpl;
import com.db4o.internal.Renames;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.StoredClassImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.activation.ActivationContext4;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.activation.LegacyActivationDepth;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.callbacks.NullCallbacks;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.metadata.TraverseFieldCommand;
import com.db4o.internal.query.NativeQueryHandler;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.processor.QQueryBase;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.references.ReferenceSystemFactory;
import com.db4o.internal.references.ReferenceSystemRegistry;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.threading.ThreadPool4;
import com.db4o.internal.weakref.WeakReferenceSupport;
import com.db4o.internal.weakref.WeakReferenceSupportFactory;
import com.db4o.query.JdkComparatorWrapper;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.core.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.TypeHandler4;
import com.db4o.types.Db4oType;
import com.db4o.types.TransientClass;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectContainerBase
implements TransientClass,
Internal4,
ObjectContainerSpec,
InternalObjectContainer {
    protected ClassMetadataRepository _classCollection;
    protected Config4Impl _config;
    private int _stackDepth;
    private final ReferenceSystemRegistry _referenceSystemRegistry = new ReferenceSystemRegistry();
    private Tree _justPeeked;
    protected Object _lock;
    private List4 _pendingClassUpdates;
    int _showInternalClasses = 0;
    private List4 _stillToActivate;
    private List4 _stillToDeactivate;
    private List4 _stillToSet;
    private Transaction _systemTransaction;
    protected Transaction _transaction;
    public HandlerRegistry _handlers;
    int _replicationCallState;
    WeakReferenceSupport _references;
    private NativeQueryHandler _nativeQueryHandler;
    private Callbacks _callbacks = new NullCallbacks();
    protected final PersistentTimeStampIdGenerator _timeStampIdGenerator = new PersistentTimeStampIdGenerator();
    private int _topLevelCallId = 1;
    private IntIdGenerator _topLevelCallIdGenerator = new IntIdGenerator();
    private final Environment _environment;
    private ReferenceSystemFactory _referenceSystemFactory;
    private String _name;

    protected ObjectContainerBase(Configuration config) {
        this._lock = new Object();
        this._config = (Config4Impl)config;
        this._environment = this.createEnvironment(this._config);
    }

    private Environment createEnvironment(Config4Impl config) {
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.addAll(config.environmentContributions());
        bindings.add(this);
        bindings.add(config);
        return Environments.newConventionBasedEnvironment(bindings.toArray());
    }

    protected Environment environment() {
        return this._environment;
    }

    protected final void open() throws OldFormatException {
        this.withEnvironment(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean ok = false;
                Object object = ObjectContainerBase.this._lock;
                synchronized (object) {
                    try {
                        ObjectContainerBase.this._name = ObjectContainerBase.this.configImpl().nameProvider().name(ObjectContainerBase.this);
                        ObjectContainerBase.this.initializeReferenceSystemFactory(ObjectContainerBase.this._config);
                        ObjectContainerBase.this.initializeTransactions();
                        ObjectContainerBase.this.initialize1(ObjectContainerBase.this._config);
                        ObjectContainerBase.this.openImpl();
                        ObjectContainerBase.this.initializePostOpen();
                        ObjectContainerBase.this.callbacks().openOnFinished(ObjectContainerBase.this);
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            ObjectContainerBase.this.shutdownObjectContainer();
                        }
                    }
                }
            }
        });
    }

    private void initializeReferenceSystemFactory(Config4Impl config) {
        this._referenceSystemFactory = config.referenceSystemFactory();
    }

    public void withEnvironment(Runnable runnable) {
        Environments.runWith(this._environment, runnable);
    }

    protected abstract void openImpl() throws Db4oIOException;

    public ActivationDepth defaultActivationDepth(ClassMetadata classMetadata) {
        return this.activationDepthProvider().activationDepthFor(classMetadata, ActivationMode.ACTIVATE);
    }

    public ActivationDepthProvider activationDepthProvider() {
        return this.configImpl().activationDepthProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            this.activate(trans, obj, this.defaultActivationDepthForObject(obj));
        }
    }

    public final void deactivate(Transaction trans, Object obj) {
        this.deactivate(trans, obj, 1);
    }

    private final ActivationDepth defaultActivationDepthForObject(Object obj) {
        ClassMetadata classMetadata = this.classMetadataForObject(obj);
        return this.defaultActivationDepth(classMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate(Transaction trans, final Object obj, final ActivationDepth depth) {
        Object object = this._lock;
        synchronized (object) {
            this.asTopLevelCall(new Function4<Transaction, Object>(){

                @Override
                public Object apply(Transaction trans) {
                    ObjectContainerBase.this.stillToActivate(ObjectContainerBase.this.activationContextFor(trans, obj, depth));
                    ObjectContainerBase.this.activatePending(trans);
                    return null;
                }
            }, trans);
        }
    }

    final void activatePending(Transaction ta) {
        while (this._stillToActivate != null) {
            Iterator4Impl i = new Iterator4Impl(this._stillToActivate);
            this._stillToActivate = null;
            while (i.moveNext()) {
                PendingActivation item = (PendingActivation)i.current();
                ObjectReference ref = item.ref;
                Object obj = ref.getObject();
                if (obj == null) {
                    ta.removeReference(ref);
                    continue;
                }
                ref.activateInternal(this.activationContextFor(ta, obj, item.depth));
            }
        }
    }

    @Override
    public void backup(String path) throws DatabaseClosedException, Db4oIOException {
        this.backup(this.configImpl().storage(), path);
    }

    public ActivationContext4 activationContextFor(Transaction ta, Object obj, ActivationDepth depth) {
        return new ActivationContext4(ta, obj, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind(Transaction trans, Object obj, long id) throws ArgumentNullException, IllegalArgumentException {
        Object object = this._lock;
        synchronized (object) {
            if (obj == null) {
                throw new ArgumentNullException();
            }
            if (DTrace.enabled) {
                DTrace.BIND.log(id, " ihc " + System.identityHashCode(obj));
            }
            trans = this.checkTransaction(trans);
            int intID = (int)id;
            Object oldObject = this.getByID(trans, id);
            if (oldObject == null) {
                throw new IllegalArgumentException("id");
            }
            ObjectReference ref = trans.referenceForId(intID);
            if (ref == null) {
                throw new IllegalArgumentException("obj");
            }
            if (this.reflectorForObject(obj) != ref.classMetadata().classReflector()) {
                throw new Db4oException(Messages.get(57));
            }
            ObjectReference newRef = this.bind2(trans, ref, obj);
            newRef.virtualAttributes(trans, false);
        }
    }

    public final ObjectReference bind2(Transaction trans, ObjectReference oldRef, Object obj) {
        int id = oldRef.getID();
        trans.removeReference(oldRef);
        ObjectReference newRef = new ObjectReference(this.classMetadataForObject(obj), id);
        newRef.setObjectWeak(this, obj);
        newRef.setStateDirty();
        trans.referenceSystem().addExistingReference(newRef);
        return newRef;
    }

    public ClassMetadata classMetadataForObject(Object obj) {
        return this.produceClassMetadata(this.reflectorForObject(obj));
    }

    public abstract byte blockSize();

    public final int bytesToBlocks(long bytes) {
        byte blockLen = this.blockSize();
        return (int)((bytes + (long)blockLen - 1L) / (long)blockLen);
    }

    public final int blockAlignedBytes(int bytes) {
        return this.bytesToBlocks(bytes) * this.blockSize();
    }

    public final int blocksToBytes(int blocks) {
        return blocks * this.blockSize();
    }

    private final boolean breakDeleteForEnum(ObjectReference reference, boolean userCall) {
        if (userCall) {
            return false;
        }
        if (reference == null) {
            return false;
        }
        return Platform4.isEnum(this.reflector(), reference.classMetadata().classReflector());
    }

    boolean canUpdate() {
        return true;
    }

    public final void checkClosed() throws DatabaseClosedException {
        if (this._classCollection == null) {
            throw new DatabaseClosedException();
        }
    }

    protected final void checkReadOnly() throws DatabaseReadOnlyException {
        if (this._config.isReadOnly()) {
            throw new DatabaseReadOnlyException();
        }
    }

    final void processPendingClassUpdates() {
        if (this._pendingClassUpdates == null) {
            return;
        }
        Iterator4Impl i = new Iterator4Impl(this._pendingClassUpdates);
        while (i.moveNext()) {
            ClassMetadata classMetadata = (ClassMetadata)i.current();
            classMetadata.setStateDirty();
            classMetadata.write(this._systemTransaction);
        }
        this._pendingClassUpdates = null;
    }

    public final Transaction checkTransaction() {
        return this.checkTransaction(null);
    }

    public final Transaction checkTransaction(Transaction ta) {
        this.checkClosed();
        if (ta != null) {
            return ta;
        }
        return this.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean close() {
        Object object = this._lock;
        synchronized (object) {
            this.callbacks().closeOnStarted(this);
            if (DTrace.enabled) {
                DTrace.CLOSE_CALLED.log(this.toString());
            }
            this.close1();
            return true;
        }
    }

    protected void handleExceptionOnClose(Exception exc) {
        this.fatalException(exc);
    }

    private void close1() {
        if (this.isClosed()) {
            return;
        }
        this.processPendingClassUpdates();
        if (this.stateMessages()) {
            this.logMsg(2, this.toString());
        }
        this.close2();
    }

    protected abstract void close2();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownObjectContainer() {
        if (DTrace.enabled) {
            DTrace.CLOSE.log();
        }
        this.logMsg(3, this.toString());
        Object object = this._lock;
        synchronized (object) {
            this.closeTransaction();
            this.closeSystemTransaction();
            this.stopSession();
            this.shutdownDataStorage();
        }
    }

    protected abstract void closeTransaction();

    protected abstract void closeSystemTransaction();

    protected abstract void shutdownDataStorage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(Transaction trans) throws DatabaseReadOnlyException, DatabaseClosedException {
        Object object = this._lock;
        synchronized (object) {
            if (DTrace.enabled) {
                DTrace.COMMIT.log();
            }
            this.checkReadOnly();
            this.asTopLevelCall(new Function4<Transaction, Object>(){

                @Override
                public Object apply(Transaction trans) {
                    ObjectContainerBase.this.commit1(trans);
                    trans.commitReferenceSystem();
                    return null;
                }
            }, trans);
        }
    }

    private <R> R asTopLevelStore(Function4<Transaction, R> block, Transaction trans) {
        trans = this.checkTransaction(trans);
        R result = this.asTopLevelCall(block, trans);
        if (this._stackDepth == 0) {
            trans.processDeletes();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R asTopLevelCall(Function4<Transaction, R> block, Transaction trans) {
        trans = this.checkTransaction(trans);
        this.beginTopLevelCall();
        try {
            R r = block.apply(trans);
            return r;
        }
        catch (Db4oRecoverableException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            this.fatalShutdown(exc);
        }
        finally {
            this.endTopLevelCall();
        }
        throw new Db4oException();
    }

    public void fatalShutdown(Throwable origExc) {
        try {
            this.stopSession();
            this.fatalStorageShutdown();
        }
        catch (Throwable exc) {
            throw new CompositeDb4oException(origExc, exc);
        }
        Platform4.throwUncheckedException(origExc);
    }

    protected abstract void fatalStorageShutdown();

    public abstract void commit1(Transaction var1);

    @Override
    public Configuration configure() {
        return this.configImpl();
    }

    public Config4Impl config() {
        return this.configImpl();
    }

    public abstract int converterVersion();

    public abstract AbstractQueryResult newQueryResult(Transaction var1, QueryEvaluationMode var2);

    protected final void createStringIO(byte encoding) {
        this.stringIO(BuiltInStringEncoding.stringIoForEncoding(encoding, this.configImpl().stringEncoding()));
    }

    protected final void initializeTransactions() {
        this._systemTransaction = this.newTransaction(null, this.createReferenceSystem());
        this._transaction = this.newUserTransaction();
    }

    public abstract Transaction newTransaction(Transaction var1, ReferenceSystem var2);

    public Transaction newUserTransaction() {
        return this.newTransaction(this.systemTransaction(), this.createReferenceSystem());
    }

    public abstract long currentVersion();

    public boolean createClassMetadata(ClassMetadata classMeta, ReflectClass clazz, ClassMetadata superClassMeta) {
        return classMeta.init(superClassMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oType db4oTypeStored(Transaction trans, Object obj) {
        if (!(obj instanceof Db4oDatabase)) {
            return null;
        }
        Db4oDatabase database = (Db4oDatabase)obj;
        if (trans.referenceForObject(obj) != null) {
            return database;
        }
        this.showInternalClasses(true);
        try {
            Db4oDatabase db4oDatabase = database.query(trans);
            return db4oDatabase;
        }
        finally {
            this.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Transaction trans, final Object obj, final int depth) throws DatabaseClosedException {
        Object object = this._lock;
        synchronized (object) {
            this.asTopLevelCall(new Function4<Transaction, Object>(){

                @Override
                public Object apply(Transaction trans) {
                    ObjectContainerBase.this.deactivateInternal(trans, obj, ObjectContainerBase.this.activationDepthProvider().activationDepth(depth, ActivationMode.DEACTIVATE));
                    return null;
                }
            }, trans);
        }
    }

    private final void deactivateInternal(Transaction trans, Object obj, ActivationDepth depth) {
        this.stillToDeactivate(trans, obj, depth, true);
        this.deactivatePending(trans);
    }

    private void deactivatePending(Transaction trans) {
        while (this._stillToDeactivate != null) {
            Iterator4Impl i = new Iterator4Impl(this._stillToDeactivate);
            this._stillToDeactivate = null;
            while (i.moveNext()) {
                PendingActivation item = (PendingActivation)i.current();
                item.ref.deactivate(trans, item.depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(Transaction trans, Object obj) throws DatabaseReadOnlyException, DatabaseClosedException {
        if (null == obj) {
            throw new ArgumentNullException();
        }
        Object object = this.lock();
        synchronized (object) {
            trans = this.checkTransaction(trans);
            this.checkReadOnly();
            this.delete1(trans, obj, true);
            this.unregisterFromTransparentPersistence(trans, obj);
            trans.processDeletes();
        }
    }

    public final void delete1(Transaction trans, final Object obj, final boolean userCall) {
        if (obj == null) {
            return;
        }
        final ObjectReference ref = trans.referenceForObject(obj);
        if (ref == null) {
            return;
        }
        if (userCall) {
            this.generateCallIDOnTopLevel();
        }
        this.asTopLevelCall(new Function4<Transaction, Object>(){

            @Override
            public Object apply(Transaction trans) {
                ObjectContainerBase.this.delete2(trans, ref, obj, 0, userCall);
                return null;
            }
        }, trans);
    }

    public final void delete2(Transaction trans, ObjectReference ref, Object obj, int cascade, boolean userCall) {
        if (this.breakDeleteForEnum(ref, userCall)) {
            return;
        }
        if (obj instanceof Entry) {
            if (!this.flagForDelete(ref)) {
                return;
            }
            this.delete3(trans, ref, obj, cascade, userCall);
            return;
        }
        trans.delete(ref, ref.getID(), cascade);
    }

    final void delete3(Transaction trans, ObjectReference ref, Object obj, int cascade, boolean userCall) {
        if (ref == null || !ref.beginProcessing()) {
            return;
        }
        if (this.breakDeleteForEnum(ref, userCall)) {
            ref.endProcessing();
            return;
        }
        if (!ref.isFlaggedForDelete()) {
            ref.endProcessing();
            return;
        }
        ClassMetadata yc = ref.classMetadata();
        ref.endProcessing();
        this.activateForDeletionCallback(trans, yc, ref, obj);
        if (!this.objectCanDelete(trans, yc, ref)) {
            return;
        }
        ref.beginProcessing();
        if (DTrace.enabled) {
            DTrace.DELETE.log(ref.getID());
        }
        if (this.delete4(trans, ref, obj, cascade, userCall)) {
            this.objectOnDelete(trans, yc, ref);
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + ref.getID() + " delete " + ref.classMetadata().getName());
            }
        }
        ref.endProcessing();
    }

    private void unregisterFromTransparentPersistence(Transaction trans, Object obj) {
        if (!(this.activationDepthProvider() instanceof TransparentActivationDepthProvider)) {
            return;
        }
        TransparentActivationDepthProvider provider = (TransparentActivationDepthProvider)this.activationDepthProvider();
        provider.removeModified(obj, trans);
    }

    private void activateForDeletionCallback(Transaction trans, ClassMetadata classMetadata, ObjectReference ref, Object obj) {
        if (!ref.isActive() && (this.caresAboutDeleting(classMetadata) || this.caresAboutDeleted(classMetadata))) {
            int depth = classMetadata.adjustCollectionDepthToBorders(1);
            this.activate(trans, obj, new FixedActivationDepth(depth));
        }
    }

    private boolean caresAboutDeleting(ClassMetadata yc) {
        return this._callbacks.caresAboutDeleting() || yc.hasEventRegistered(this.systemTransaction(), 0);
    }

    private boolean caresAboutDeleted(ClassMetadata yc) {
        return this._callbacks.caresAboutDeleted() || yc.hasEventRegistered(this.systemTransaction(), 1);
    }

    private boolean objectCanDelete(Transaction transaction, ClassMetadata yc, ObjectInfo objectInfo) {
        return this.callbacks().objectCanDelete(transaction, objectInfo) && yc.dispatchEvent(transaction, objectInfo.getObject(), 0);
    }

    private void objectOnDelete(Transaction transaction, ClassMetadata yc, ObjectInfo reference) {
        this.callbacks().objectOnDelete(transaction, reference);
        yc.dispatchEvent(transaction, reference.getObject(), 1);
    }

    public abstract boolean delete4(Transaction var1, ObjectReference var2, Object var3, int var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object descend(Transaction trans, Object obj, String[] path) {
        Object object = this._lock;
        synchronized (object) {
            Object child;
            trans = this.checkTransaction(trans);
            ObjectReference ref = trans.referenceForObject(obj);
            if (ref == null) {
                return null;
            }
            final String fieldName = path[0];
            if (fieldName == null) {
                return null;
            }
            ClassMetadata classMetadata = ref.classMetadata();
            final ByRef foundField = new ByRef();
            classMetadata.traverseAllAspects(new TraverseFieldCommand(){

                protected void process(FieldMetadata field) {
                    if (field.canAddToQuery(fieldName)) {
                        foundField.value = field;
                    }
                }
            });
            FieldMetadata field = (FieldMetadata)foundField.value;
            if (field == null) {
                return null;
            }
            Object object2 = child = ref.isActive() ? field.get(trans, obj) : this.descendMarshallingContext(trans, ref).readFieldValue(field);
            if (path.length == 1) {
                return child;
            }
            if (child == null) {
                return null;
            }
            String[] subPath = new String[path.length - 1];
            System.arraycopy(path, 1, subPath, 0, path.length - 1);
            return this.descend(trans, child, subPath);
        }
    }

    private UnmarshallingContext descendMarshallingContext(Transaction trans, ObjectReference ref) {
        UnmarshallingContext context = new UnmarshallingContext(trans, ref, 1, false);
        context.activationDepth(this.activationDepthProvider().activationDepth(1, ActivationMode.ACTIVATE));
        return context;
    }

    public boolean detectSchemaChanges() {
        return this.configImpl().detectSchemaChanges();
    }

    public boolean dispatchsEvents() {
        return true;
    }

    protected boolean doFinalize() {
        return true;
    }

    final void shutdownHook() {
        if (this.isClosed()) {
            return;
        }
        if (this.allOperationsCompleted()) {
            Messages.logErr(this.configImpl(), 50, this.toString(), null);
            this.close();
        } else {
            this.shutdownObjectContainer();
            if (this.operationIsProcessing()) {
                Messages.logErr(this.configImpl(), 24, null, null);
            }
        }
    }

    private boolean operationIsProcessing() {
        return this._stackDepth > 0;
    }

    private boolean allOperationsCompleted() {
        return this._stackDepth == 0;
    }

    void fatalException(int msgID) {
        this.fatalException(null, msgID);
    }

    final void fatalException(Throwable t) {
        this.fatalException(t, 44);
    }

    final void fatalException(Throwable t, int msgID) {
        if (DTrace.enabled) {
            DTrace.FATAL_EXCEPTION.log(t.toString());
        }
        Messages.logErr(this.configImpl(), msgID == 44 ? 18 : msgID, null, t);
        if (!this.isClosed()) {
            this.shutdownObjectContainer();
        }
        throw new Db4oException(Messages.get(msgID));
    }

    protected void finalize() {
        if (this.doFinalize() && this.configuredForAutomaticShutDown()) {
            this.shutdownHook();
        }
    }

    private boolean configuredForAutomaticShutDown() {
        return this.configImpl() == null || this.configImpl().automaticShutDown();
    }

    void gc() {
        this._references.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectSet queryByExample(Transaction trans, final Object template) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            QueryResult res = this.asTopLevelCall(new Function4<Transaction, QueryResult>(){

                @Override
                public QueryResult apply(Transaction trans) {
                    return ObjectContainerBase.this.queryByExampleInternal(trans, template);
                }
            }, trans);
            return new ObjectSetFacade(res);
        }
    }

    private final QueryResult queryByExampleInternal(Transaction trans, Object template) {
        if (template == null || template.getClass() == Const4.CLASS_OBJECT || template == Const4.CLASS_OBJECT) {
            return this.queryAllObjects(trans);
        }
        Query q = this.query(trans);
        q.constrain(template).byExample();
        return this.executeQuery((QQuery)q);
    }

    public abstract AbstractQueryResult queryAllObjects(Transaction var1);

    public final Object tryGetByID(Transaction ta, long id) throws DatabaseClosedException {
        try {
            return this.getByID(ta, id);
        }
        catch (InvalidSlotException ise) {
        }
        catch (InvalidIDException iie) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getByID(Transaction ta, long id) throws DatabaseClosedException, InvalidIDException {
        Object object = this._lock;
        synchronized (object) {
            if (id <= 0L || id >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.checkClosed();
            ta = this.checkTransaction(ta);
            this.beginTopLevelCall();
            try {
                Object object2 = this.getByID2(ta, (int)id);
                return object2;
            }
            catch (Db4oRecoverableException exc) {
                throw exc;
            }
            catch (OutOfMemoryError e) {
                throw new Db4oRecoverableException(e);
            }
            catch (RuntimeException e) {
                throw new Db4oRecoverableException(e);
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    public Object getByID2(Transaction ta, int id) {
        Object obj = ta.objectForIdFromCache(id);
        if (obj != null) {
            return obj;
        }
        return new ObjectReference(id).read(ta, new LegacyActivationDepth(0), 1, true);
    }

    public final Object getActivatedObjectFromCache(Transaction ta, int id) {
        Object obj = ta.objectForIdFromCache(id);
        if (obj == null) {
            return null;
        }
        this.activate(ta, obj);
        return obj;
    }

    public final Object readActivatedObjectNotInCache(Transaction trans, final int id) {
        Object obj = this.asTopLevelCall(new Function4<Transaction, Object>(){

            @Override
            public Object apply(Transaction trans) {
                return new ObjectReference(id).read(trans, UnknownActivationDepth.INSTANCE, 1, true);
            }
        }, trans);
        this.activatePending(trans);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getByUUID(Transaction trans, Db4oUUID uuid) {
        Object object = this._lock;
        synchronized (object) {
            if (uuid == null) {
                return null;
            }
            HardObjectReference hardRef = this.getHardReferenceBySignature(this.checkTransaction(trans), uuid.getLongPart(), uuid.getSignaturePart());
            return hardRef._object;
        }
    }

    public HardObjectReference getHardReferenceBySignature(Transaction trans, long uuid, byte[] signature) {
        return this.uUIDIndex().getHardObjectReferenceBySignature(trans, uuid, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getID(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            this.checkClosed();
            if (obj == null) {
                return 0;
            }
            ObjectReference yo = trans.referenceForObject(obj);
            if (yo != null) {
                return yo.getID();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectInfo getObjectInfo(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            return trans.referenceForObject(obj);
        }
    }

    public final HardObjectReference getHardObjectReferenceById(Transaction trans, int id) {
        Object readObject;
        if (id <= 0) {
            return HardObjectReference.INVALID;
        }
        ObjectReference ref = trans.referenceForId(id);
        if (ref != null) {
            Object candidate = ref.getObject();
            if (candidate != null) {
                return new HardObjectReference(ref, candidate);
            }
            trans.removeReference(ref);
        }
        if ((readObject = (ref = new ObjectReference(id)).read(trans, new LegacyActivationDepth(0), 1, true)) == null) {
            return HardObjectReference.INVALID;
        }
        if (readObject != ref.getObject()) {
            return this.getHardObjectReferenceById(trans, id);
        }
        return new HardObjectReference(ref, readObject);
    }

    public final StatefulBuffer getWriter(Transaction a_trans, int a_address, int a_length) {
        if (Debug4.exceedsMaximumBlockSize(a_length)) {
            return null;
        }
        return new StatefulBuffer(a_trans, a_address, a_length);
    }

    public final Transaction systemTransaction() {
        return this._systemTransaction;
    }

    @Override
    public final Transaction transaction() {
        return this._transaction;
    }

    @Override
    public final ClassMetadata classMetadataForReflectClass(ReflectClass claxx) {
        if (null == claxx) {
            throw new ArgumentNullException();
        }
        if (this.hideClassForExternalUse(claxx)) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForClass(claxx);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.classMetadataForReflectClass(claxx);
    }

    public ClassMetadata produceClassMetadata(ReflectClass claxx) {
        if (null == claxx) {
            throw new ArgumentNullException();
        }
        if (this.hideClassForExternalUse(claxx)) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForClass(claxx);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.produceClassMetadata(claxx);
    }

    final ClassMetadata getActiveClassMetadata(ReflectClass claxx) {
        if (this.hideClassForExternalUse(claxx)) {
            return null;
        }
        return this._classCollection.getActiveClassMetadata(claxx);
    }

    private final boolean hideClassForExternalUse(ReflectClass claxx) {
        return !this.showInternalClasses() && this._handlers.ICLASS_INTERNAL.isAssignableFrom(claxx);
    }

    public int classMetadataIdForName(String name) {
        return this._classCollection.classMetadataIdForName(name);
    }

    @Override
    public ClassMetadata classMetadataForName(String name) {
        return this.classMetadataForID(this.classMetadataIdForName(name));
    }

    @Override
    public ClassMetadata classMetadataForID(int id) {
        if (DTrace.enabled) {
            DTrace.CLASSMETADATA_BY_ID.log(id);
        }
        if (id == 0) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForId(id);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.classMetadataForId(id);
    }

    @Override
    public HandlerRegistry handlers() {
        return this._handlers;
    }

    public boolean needsLockFileThread() {
        if (!Platform4.needsLockFileThread()) {
            return false;
        }
        if (this.configImpl().isReadOnly()) {
            return false;
        }
        return this.configImpl().lockFile();
    }

    protected boolean hasShutDownHook() {
        return this.configImpl().automaticShutDown();
    }

    protected void initialize1(Configuration config) {
        this._config = this.initializeConfig(config);
        this._handlers = new HandlerRegistry(this, this.configImpl().encoding(), this.configImpl().reflector());
        if (this._references != null) {
            this.gc();
            this._references.stop();
        }
        this._references = WeakReferenceSupportFactory.forObjectContainer(this);
        if (this.hasShutDownHook()) {
            Platform4.addShutDownHook(this);
        }
        this._handlers.initEncryption(this.configImpl());
        this.initialize2();
        this._stillToSet = null;
    }

    private Config4Impl initializeConfig(Configuration config) {
        Config4Impl impl = (Config4Impl)config;
        impl.container(this);
        impl.reflector().setTransaction(this.systemTransaction());
        impl.reflector().configuration(new ReflectorConfigurationImpl(impl));
        impl.taint();
        return impl;
    }

    void initialize2() {
        this.initialize2NObjectCarrier();
    }

    public ReferenceSystem createReferenceSystem() {
        ReferenceSystem referenceSystem = this._referenceSystemFactory.newReferenceSystem(this);
        this._referenceSystemRegistry.addReferenceSystem(referenceSystem);
        return referenceSystem;
    }

    void initialize2NObjectCarrier() {
        this._classCollection = new ClassMetadataRepository(this._systemTransaction);
        this._references.start();
    }

    private void initializePostOpen() {
        this._showInternalClasses = 100000;
        this.initializePostOpenExcludingTransportObjectContainer();
        this._showInternalClasses = 0;
    }

    protected void initializePostOpenExcludingTransportObjectContainer() {
        this.initializeEssentialClasses();
        this.rename(this.configImpl());
        this._classCollection.initOnUp(this._systemTransaction);
        if (this.configImpl().detectSchemaChanges()) {
            this._systemTransaction.commit();
        }
        this.configImpl().applyConfigurationItems(this);
    }

    void initializeEssentialClasses() {
        for (int i = 0; i < Const4.ESSENTIAL_CLASSES.length; ++i) {
            this.produceClassMetadata(this.reflector().forClass(Const4.ESSENTIAL_CLASSES[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isActive(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            ObjectReference ref;
            trans = this.checkTransaction(trans);
            if (obj != null && (ref = trans.referenceForObject(obj)) != null) {
                return ref.isActive();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Transaction trans, long id) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            return trans.objectForIdFromCache((int)id) != null;
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isClosed() {
        Object object = this._lock;
        synchronized (object) {
            return this._classCollection == null;
        }
    }

    boolean isServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStored(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            if (obj == null) {
                return false;
            }
            ObjectReference ref = trans.referenceForObject(obj);
            if (ref == null) {
                return false;
            }
            return !trans.isDeleted(ref.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectClass[] knownClasses() {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            return this.reflector().knownClasses();
        }
    }

    public TypeHandler4 typeHandlerForClass(ReflectClass claxx) {
        if (this.hideClassForExternalUse(claxx)) {
            return null;
        }
        TypeHandler4 typeHandler = this._handlers.typeHandlerForClass(claxx);
        if (typeHandler != null) {
            return typeHandler;
        }
        return this._classCollection.produceClassMetadata(claxx).typeHandler();
    }

    public TypeHandler4 typeHandlerForClassMetadataID(int id) {
        if (id < 1) {
            return null;
        }
        ClassMetadata classMetadata = this.classMetadataForID(id);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.typeHandler();
    }

    @Override
    public Object lock() {
        return this._lock;
    }

    public final void logMsg(int code, String msg) {
        Messages.logMsg(this.configImpl(), code, msg);
    }

    public boolean maintainsIndices() {
        return true;
    }

    void message(String msg) {
        new MessageOutput(this, msg);
    }

    public final void needsUpdate(ClassMetadata classMetadata) {
        this._pendingClassUpdates = new List4(this._pendingClassUpdates, classMetadata);
    }

    public long generateTimeStampId() {
        return this._timeStampIdGenerator.next();
    }

    public abstract int newUserObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekPersisted(Transaction trans, final Object obj, final ActivationDepth depth, final boolean committed) throws DatabaseClosedException {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            return this.asTopLevelCall(new Function4<Transaction, Object>(){

                @Override
                public Object apply(Transaction trans) {
                    trans = ObjectContainerBase.this.checkTransaction(trans);
                    ObjectReference ref = trans.referenceForObject(obj);
                    trans = committed ? ObjectContainerBase.this._systemTransaction : trans;
                    Object cloned = null;
                    if (ref != null) {
                        cloned = ObjectContainerBase.this.peekPersisted(trans, ref.getID(), depth, true);
                    }
                    return cloned;
                }
            }, trans);
        }
    }

    public final Object peekPersisted(Transaction trans, int id, ActivationDepth depth, boolean resetJustPeeked) {
        if (resetJustPeeked) {
            this._justPeeked = null;
        } else {
            TreeInt ti = new TreeInt(id);
            TreeIntObject tio = (TreeIntObject)Tree.find(this._justPeeked, ti);
            if (tio != null) {
                return tio._object;
            }
        }
        ObjectReference ref = this.peekReference(trans, id, depth, resetJustPeeked);
        return ref.getObject();
    }

    public ObjectReference peekReference(Transaction trans, int id, ActivationDepth depth, boolean resetJustPeeked) {
        ObjectReference ref = new ObjectReference(id);
        ref.peekPersisted(trans, depth);
        if (resetJustPeeked) {
            this._justPeeked = null;
        }
        return ref;
    }

    void peeked(int id, Object obj) {
        this._justPeeked = Tree.add(this._justPeeked, new TreeIntObject(id, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            System.gc();
            System.runFinalization();
            System.gc();
            this.gc();
            this._classCollection.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purge(Transaction trans, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            trans.removeObjectFromReferenceSystem(obj);
        }
    }

    final void removeFromAllReferenceSystems(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof ObjectReference) {
            this._referenceSystemRegistry.removeReference((ObjectReference)obj);
            return;
        }
        this._referenceSystemRegistry.removeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NativeQueryHandler getNativeQueryHandler() {
        Object object = this._lock;
        synchronized (object) {
            if (null == this._nativeQueryHandler) {
                this._nativeQueryHandler = new NativeQueryHandler(this);
            }
            return this._nativeQueryHandler;
        }
    }

    public final ObjectSet query(Transaction trans, Predicate predicate) {
        return this.query(trans, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> ObjectSet<T> query(Transaction trans, Predicate<T> predicate, QueryComparator<T> comparator) {
        Object object = this._lock;
        synchronized (object) {
            return this.getNativeQueryHandler().execute(this.query(trans), predicate, comparator);
        }
    }

    public final <T> ObjectSet<T> query(Transaction trans, Class<T> clazz) {
        return this.queryByExample(trans, clazz);
    }

    public final Query query(Transaction ta) {
        return new QQuery(this.checkTransaction(ta), null, null);
    }

    public abstract void raiseVersion(long var1);

    public abstract void readBytes(byte[] var1, int var2, int var3) throws Db4oIOException;

    public abstract void readBytes(byte[] var1, int var2, int var3, int var4) throws Db4oIOException;

    public final ByteArrayBuffer decryptedBufferByAddress(int address, int length) throws Db4oIOException {
        ByteArrayBuffer reader = this.rawBufferByAddress(address, length);
        this._handlers.decrypt(reader);
        return reader;
    }

    public ByteArrayBuffer rawBufferByAddress(int address, int length) {
        this.checkAddress(address);
        ByteArrayBuffer reader = new ByteArrayBuffer(length);
        this.readBytes(reader._buffer, address, length);
        return reader;
    }

    private void checkAddress(int address) throws IllegalArgumentException {
        if (address <= 0) {
            throw new IllegalArgumentException("Invalid address offset: " + address);
        }
    }

    public final StatefulBuffer readWriterByAddress(Transaction a_trans, int address, int length) throws Db4oIOException {
        this.checkAddress(address);
        StatefulBuffer reader = this.getWriter(a_trans, address, length);
        reader.readEncrypt(this, address);
        return reader;
    }

    public abstract StatefulBuffer readWriterByID(Transaction var1, int var2);

    public abstract StatefulBuffer readWriterByID(Transaction var1, int var2, boolean var3);

    public abstract ByteArrayBuffer readReaderByID(Transaction var1, int var2);

    public abstract ByteArrayBuffer readReaderByID(Transaction var1, int var2, boolean var3);

    public abstract ByteArrayBuffer[] readSlotBuffers(Transaction var1, int[] var2);

    private void reboot() {
        this.commit(null);
        this.close();
        this.open();
    }

    @Override
    public GenericReflector reflector() {
        return this._handlers._reflector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(Transaction trans, Object obj, int depth) {
        Object object = this._lock;
        synchronized (object) {
            this.refreshInternal(trans, obj, depth);
        }
    }

    protected void refreshInternal(Transaction trans, Object obj, int depth) {
        this.activate(trans, obj, this.refreshActivationDepth(depth));
    }

    private ActivationDepth refreshActivationDepth(int depth) {
        return this.activationDepthProvider().activationDepth(depth, ActivationMode.REFRESH);
    }

    @Override
    public abstract void releaseSemaphore(String var1);

    public void flagAsHandled(ObjectReference ref) {
        ref.flagAsHandled(this._topLevelCallId);
    }

    boolean flagForDelete(ObjectReference ref) {
        if (ref == null) {
            return false;
        }
        if (this.handledInCurrentTopLevelCall(ref)) {
            return false;
        }
        ref.flagForDelete(this._topLevelCallId);
        return true;
    }

    public abstract void releaseSemaphores(Transaction var1);

    void rename(Config4Impl config) {
        boolean renamedOne = false;
        if (config.rename() != null) {
            renamedOne = this.applyRenames(config);
        }
        this._classCollection.checkChanges();
        if (renamedOne) {
            this.reboot();
        }
    }

    protected boolean applyRenames(Config4Impl config) {
        boolean renamed = false;
        Iterator4 i = config.rename().iterator();
        while (i.moveNext()) {
            Rename ren = (Rename)i.current();
            if (this.alreadyApplied(ren) || !this.applyRename(ren)) continue;
            renamed = true;
        }
        return renamed;
    }

    private boolean applyRename(Rename ren) {
        if (ren.isField()) {
            return this.applyFieldRename(ren);
        }
        return this.applyClassRename(ren);
    }

    private boolean applyClassRename(Rename ren) {
        ClassMetadata classToRename = this._classCollection.getClassMetadata(ren.rFrom);
        if (classToRename == null) {
            return false;
        }
        ClassMetadata existing = this._classCollection.getClassMetadata(ren.rTo);
        if (existing != null) {
            this.logMsg(9, "class " + ren.rTo);
            return false;
        }
        classToRename.setName(ren.rTo);
        this.commitRenameFor(ren, classToRename);
        return true;
    }

    private boolean applyFieldRename(Rename ren) {
        ClassMetadata parentClass = this._classCollection.getClassMetadata(ren.rClass);
        if (parentClass == null) {
            return false;
        }
        if (!parentClass.renameField(ren.rFrom, ren.rTo)) {
            return false;
        }
        this.commitRenameFor(ren, parentClass);
        return true;
    }

    private void commitRenameFor(Rename rename, ClassMetadata classMetadata) {
        this.setDirtyInSystemTransaction(classMetadata);
        this.logMsg(8, rename.rFrom + " to " + rename.rTo);
        this.deleteInverseRenames(rename);
        this.store(this.systemTransaction(), rename);
    }

    private void deleteInverseRenames(Rename rename) {
        ObjectSet inverseRenames = this.queryInverseRenames(rename);
        while (inverseRenames.hasNext()) {
            this.delete(this.systemTransaction(), inverseRenames.next());
        }
    }

    private ObjectSet queryInverseRenames(Rename ren) {
        return this.queryByExample(this.systemTransaction(), Renames.forInverseQBE(ren));
    }

    private boolean alreadyApplied(Rename ren) {
        return this.queryByExample(this.systemTransaction(), ren).size() != 0;
    }

    public final boolean handledInCurrentTopLevelCall(ObjectReference ref) {
        return ref.isFlaggedAsHandled(this._topLevelCallId);
    }

    public abstract void reserve(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(Transaction trans) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            this.checkReadOnly();
            this.rollback1(trans);
            trans.rollbackReferenceSystem();
        }
    }

    public abstract void rollback1(Transaction var1);

    public void send(Object obj) {
        throw new NotSupportedException();
    }

    public final void store(Transaction trans, Object obj) throws DatabaseClosedException, DatabaseReadOnlyException {
        this.store(trans, obj, -2147483548);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int store(Transaction trans, Object obj, int depth) throws DatabaseClosedException, DatabaseReadOnlyException {
        Object object = this._lock;
        synchronized (object) {
            return this.storeInternal(trans, obj, depth, true);
        }
    }

    public final int storeInternal(Transaction trans, Object obj, boolean checkJustSet) throws DatabaseClosedException, DatabaseReadOnlyException {
        return this.storeInternal(trans, obj, -2147483548, checkJustSet);
    }

    public int storeInternal(Transaction trans, final Object obj, final int depth, final boolean checkJustSet) throws DatabaseClosedException, DatabaseReadOnlyException {
        this.checkReadOnly();
        return this.asTopLevelStore(new Function4<Transaction, Integer>(){

            @Override
            public Integer apply(Transaction trans) {
                return ObjectContainerBase.this.storeAfterReplication(trans, obj, depth, checkJustSet);
            }
        }, trans);
    }

    public final int storeAfterReplication(Transaction trans, Object obj, int depth, boolean checkJust) {
        Db4oType db4oType;
        if (obj instanceof Db4oType && (db4oType = this.db4oTypeStored(trans, obj)) != null) {
            return this.getID(trans, db4oType);
        }
        return this.store2(trans, obj, depth, checkJust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeByNewReplication(Db4oReplicationReferenceProvider referenceProvider, Object obj) {
        Object object = this._lock;
        synchronized (object) {
            this._replicationCallState = 1;
            this._handlers._replicationReferenceProvider = referenceProvider;
            try {
                this.store2(this.checkTransaction(), obj, 1, false);
            }
            finally {
                this._replicationCallState = 0;
                this._handlers._replicationReferenceProvider = null;
            }
        }
    }

    private final int store2(Transaction trans, Object obj, int depth, boolean checkJust) {
        int id = this.store3(trans, obj, depth, checkJust);
        if (this.stackIsSmall()) {
            this.checkStillToSet();
        }
        return id;
    }

    public void checkStillToSet() {
        List4 postponedStillToSet = null;
        while (this._stillToSet != null) {
            Iterator4Impl i = new Iterator4Impl(this._stillToSet);
            this._stillToSet = null;
            while (i.moveNext()) {
                PendingSet item = (PendingSet)i.current();
                ObjectReference ref = item.ref;
                Transaction trans = item.transaction;
                if (ref.continueSet(trans, item.depth)) continue;
                postponedStillToSet = new List4(postponedStillToSet, item);
            }
        }
        this._stillToSet = postponedStillToSet;
    }

    void notStorable(ReflectClass claxx, Object obj) {
        if (!this.configImpl().exceptionsOnNotStorable()) {
            return;
        }
        if (claxx == null) {
            throw new ObjectNotStorableException(obj.toString());
        }
        if (this._handlers.isTransient(claxx)) {
            return;
        }
        throw new ObjectNotStorableException(claxx);
    }

    public final int store3(Transaction trans, Object obj, int updateDepth, boolean checkJustSet) {
        if (obj == null || obj instanceof TransientClass) {
            return 0;
        }
        ObjectAnalyzer analyzer = new ObjectAnalyzer(this, obj);
        analyzer.analyze(trans);
        if (analyzer.notStorable()) {
            return 0;
        }
        ObjectReference ref = analyzer.objectReference();
        if (ref == null) {
            ClassMetadata classMetadata = analyzer.classMetadata();
            if (!this.objectCanNew(trans, classMetadata, obj)) {
                return 0;
            }
            ref = new ObjectReference();
            ref.store(trans, classMetadata, obj);
            trans.addNewReference(ref);
            if (obj instanceof Db4oTypeImpl) {
                ((Db4oTypeImpl)obj).setTrans(trans);
            }
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + ref.getID() + " new " + ref.classMetadata().getName());
            }
            this.flagAsHandled(ref);
            this.stillToSet(trans, ref, updateDepth);
        } else {
            if (ref.isFlaggedAsHandled(this._topLevelCallId)) {
                this.assertNotInCallback();
            }
            if (this.canUpdate()) {
                if (checkJustSet && !ref.isNew() && this.handledInCurrentTopLevelCall(ref)) {
                    return ref.getID();
                }
                if (this.updateDepthSufficient(updateDepth)) {
                    this.flagAsHandled(ref);
                    ref.writeUpdate(trans, updateDepth);
                }
            }
        }
        this.processPendingClassUpdates();
        return ref.getID();
    }

    private void assertNotInCallback() {
        if (InCallback.value()) {
            throw new Db4oIllegalStateException("Objects must not be updated in callback");
        }
    }

    private final boolean updateDepthSufficient(int updateDepth) {
        return updateDepth == -2147483548 || updateDepth > 0;
    }

    private boolean objectCanNew(Transaction transaction, ClassMetadata yc, Object obj) {
        return this.callbacks().objectCanNew(transaction, obj) && yc.dispatchEvent(transaction, obj, 8);
    }

    public abstract void setDirtyInSystemTransaction(PersistentBase var1);

    @Override
    public abstract boolean setSemaphore(String var1, int var2);

    void stringIO(LatinStringIO io) {
        this._handlers.stringIO(io);
    }

    final boolean showInternalClasses() {
        return this.isServer() || this._showInternalClasses > 0;
    }

    public synchronized void showInternalClasses(boolean show) {
        this._showInternalClasses = show ? ++this._showInternalClasses : --this._showInternalClasses;
        if (this._showInternalClasses < 0) {
            this._showInternalClasses = 0;
        }
    }

    private final boolean stackIsSmall() {
        return this._stackDepth < 20;
    }

    boolean stateMessages() {
        return true;
    }

    final List4 stillTo1(Transaction trans, List4 still, Object obj, ActivationDepth depth) {
        ClassMetadata metadata;
        if (obj == null || !depth.requiresActivation()) {
            return still;
        }
        ObjectReference ref = trans.referenceForObject(obj);
        if (ref != null) {
            if (this.handledInCurrentTopLevelCall(ref)) {
                return still;
            }
            this.flagAsHandled(ref);
            return new List4(still, new PendingActivation(ref, depth));
        }
        ReflectClass clazz = this.reflectorForObject(obj);
        if (clazz.isArray()) {
            if (!clazz.getComponentType().isPrimitive()) {
                Iterator4 arr = ArrayHandler.iterator(clazz, obj);
                while (arr.moveNext()) {
                    Object current = arr.current();
                    if (current == null) continue;
                    ClassMetadata classMetadata = this.classMetadataForObject(current);
                    still = this.stillTo1(trans, still, current, depth.descend(classMetadata));
                }
            }
            return still;
        }
        if (obj instanceof Entry) {
            still = this.stillTo1(trans, still, ((Entry)obj).key, depth);
            still = this.stillTo1(trans, still, ((Entry)obj).value, depth);
        } else if (depth.mode().isDeactivate() && (metadata = this.classMetadataForObject(obj)) != null && metadata.isStruct()) {
            metadata.forceDeactivation(trans, depth, obj);
        }
        return still;
    }

    public final void stillToActivate(ActivationContext context) {
        if (this.processedByImmediateActivation(context)) {
            return;
        }
        this._stillToActivate = this.stillTo1(context.transaction(), this._stillToActivate, context.targetObject(), context.depth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processedByImmediateActivation(ActivationContext context) {
        if (!this.stackIsSmall()) {
            return false;
        }
        if (!context.depth().requiresActivation()) {
            return true;
        }
        ObjectReference ref = context.transaction().referenceForObject(context.targetObject());
        if (ref == null) {
            return false;
        }
        if (this.handledInCurrentTopLevelCall(ref)) {
            return true;
        }
        this.flagAsHandled(ref);
        ++this._stackDepth;
        try {
            ref.activateInternal(context);
        }
        finally {
            --this._stackDepth;
        }
        return true;
    }

    public final void stillToDeactivate(Transaction trans, Object a_object, ActivationDepth a_depth, boolean a_forceUnknownDeactivate) {
        this._stillToDeactivate = this.stillTo1(trans, this._stillToDeactivate, a_object, a_depth);
    }

    void stillToSet(Transaction transaction, ObjectReference ref, int updateDepth) {
        if (this.stackIsSmall() && ref.continueSet(transaction, updateDepth)) {
            return;
        }
        this._stillToSet = new List4(this._stillToSet, new PendingSet(transaction, ref, updateDepth));
    }

    protected final void stopSession() {
        if (this.hasShutDownHook()) {
            Platform4.removeShutDownHook(this);
        }
        this._classCollection = null;
        if (this._references != null) {
            this._references.stop();
        }
        this._systemTransaction = null;
        this._transaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StoredClass storedClass(Transaction trans, Object clazz) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            ReflectClass claxx = ReflectorUtils.reflectClassFor(this.reflector(), clazz);
            if (claxx == null) {
                return null;
            }
            ClassMetadata classMetadata = this.classMetadataForReflectClass(claxx);
            if (classMetadata == null) {
                return null;
            }
            return new StoredClassImpl(trans, classMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(Transaction trans) {
        Object object = this._lock;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            StoredClass[] classMetadata = this._classCollection.storedClasses();
            StoredClass[] storedClasses = new StoredClass[classMetadata.length];
            for (int i = 0; i < classMetadata.length; ++i) {
                storedClasses[i] = new StoredClassImpl(trans, (ClassMetadata)classMetadata[i]);
            }
            return storedClasses;
        }
    }

    public LatinStringIO stringIO() {
        return this._handlers.stringIO();
    }

    @Override
    public abstract SystemInfo systemInfo();

    private final void beginTopLevelCall() {
        if (DTrace.enabled) {
            DTrace.BEGIN_TOP_LEVEL_CALL.log();
        }
        this.generateCallIDOnTopLevel();
        ++this._stackDepth;
    }

    private final void endTopLevelCall() {
        if (DTrace.enabled) {
            DTrace.END_TOP_LEVEL_CALL.log();
        }
        --this._stackDepth;
        this.generateCallIDOnTopLevel();
    }

    private final void generateCallIDOnTopLevel() {
        if (this._stackDepth == 0) {
            this._topLevelCallId = this._topLevelCallIdGenerator.next();
        }
    }

    public int stackDepth() {
        return this._stackDepth;
    }

    public void stackDepth(int depth) {
        this._stackDepth = depth;
    }

    public int topLevelCallId() {
        return this._topLevelCallId;
    }

    public void topLevelCallId(int id) {
        this._topLevelCallId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long version() {
        Object object = this._lock;
        synchronized (object) {
            return this.currentVersion();
        }
    }

    public abstract void shutdown();

    public abstract void writeDirty();

    public abstract void writeNew(Transaction var1, Pointer4 var2, ClassMetadata var3, ByteArrayBuffer var4);

    public abstract void writeTransactionPointer(int var1);

    public abstract void writeUpdate(Transaction var1, Pointer4 var2, ClassMetadata var3, ArrayType var4, ByteArrayBuffer var5);

    @Override
    public Callbacks callbacks() {
        return this._callbacks;
    }

    @Override
    public void callbacks(Callbacks cb) {
        if (cb == null) {
            throw new IllegalArgumentException();
        }
        this._callbacks = cb;
    }

    @Override
    public Config4Impl configImpl() {
        return this._config;
    }

    public UUIDFieldMetadata uUIDIndex() {
        return this._handlers.indexes()._uUID;
    }

    public VersionFieldMetadata versionIndex() {
        return this._handlers.indexes()._version;
    }

    public ClassMetadataRepository classCollection() {
        return this._classCollection;
    }

    public abstract long[] getIDsForClass(Transaction var1, ClassMetadata var2);

    public abstract QueryResult classOnlyQuery(QQueryBase var1, ClassMetadata var2);

    public abstract QueryResult executeQuery(QQuery var1);

    public void replicationCallState(int state) {
        this._replicationCallState = state;
    }

    @Override
    public abstract void onCommittedListener();

    public ReferenceSystemRegistry referenceSystemRegistry() {
        return this._referenceSystemRegistry;
    }

    @Override
    public ObjectContainerBase container() {
        return this;
    }

    public void deleteByID(Transaction transaction, int id, int cascadeDeleteDepth) {
        ObjectReference ref;
        if (id <= 0) {
            throw new IllegalArgumentException("ID: " + id);
        }
        if (cascadeDeleteDepth <= 0) {
            return;
        }
        Object obj = this.getByID2(transaction, id);
        if (obj == null) {
            return;
        }
        --cascadeDeleteDepth;
        ReflectClass claxx = this.reflectorForObject(obj);
        if (claxx.isCollection()) {
            ++cascadeDeleteDepth;
        }
        if ((ref = transaction.referenceForId(id)) == null) {
            return;
        }
        this.delete2(transaction, ref, obj, cascadeDeleteDepth, false);
    }

    ReflectClass reflectorForObject(Object obj) {
        return this.reflector().forObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R syncExec(Closure4<R> block) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            return block.run();
        }
    }

    public ObjectSet query(Predicate predicate, Comparator comparator) {
        return this.query(null, predicate, new JdkComparatorWrapper(comparator));
    }

    @Override
    public void storeAll(Transaction transaction, Iterator4 objects) {
        while (objects.moveNext()) {
            this.store(transaction, objects.current());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withTransaction(Transaction transaction, Runnable runnable) {
        Object object = this._lock;
        synchronized (object) {
            Transaction old = this._transaction;
            this._transaction = transaction;
            try {
                runnable.run();
            }
            finally {
                this._transaction = old;
            }
        }
    }

    public ThreadPool4 threadPool() {
        return this.environment().provide(ThreadPool4.class);
    }

    public Object newWeakReference(ObjectReference referent, Object obj) {
        return this._references.newWeakReference(referent, obj);
    }

    public final String toString() {
        if (this._name != null) {
            return this._name;
        }
        return this.defaultToString();
    }

    protected abstract String defaultToString();

    static class PendingSet {
        public final Transaction transaction;
        public final ObjectReference ref;
        public final int depth;

        public PendingSet(Transaction transaction_, ObjectReference ref_, int depth_) {
            this.transaction = transaction_;
            this.ref = ref_;
            this.depth = depth_;
        }
    }

    static final class PendingActivation {
        public final ObjectReference ref;
        public final ActivationDepth depth;

        public PendingActivation(ObjectReference ref_, ActivationDepth depth_) {
            this.ref = ref_;
            this.depth = depth_;
        }
    }
}

