/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.convert;

import com.db4o.internal.convert.Conversion;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.conversions.CommonConversions;
import java.util.HashMap;
import java.util.Map;

public class Converter {
    public static final int VERSION = 11;
    private static Converter _instance;
    private Map<Integer, Conversion> _conversions;
    private int _minimumVersion = Integer.MAX_VALUE;

    public static boolean convert(ConversionStage stage) {
        if (!Converter.needsConversion(stage.converterVersion())) {
            return false;
        }
        return Converter.instance().runConversions(stage);
    }

    private Converter() {
        this._conversions = new HashMap<Integer, Conversion>();
        CommonConversions.register(this);
    }

    public static Converter instance() {
        if (_instance == null) {
            _instance = new Converter();
        }
        return _instance;
    }

    public Conversion conversionFor(int version) {
        return this._conversions.get(version);
    }

    private static boolean needsConversion(int converterVersion) {
        return converterVersion < 11;
    }

    public void register(int introducedVersion, Conversion conversion) {
        if (this._conversions.containsKey(introducedVersion)) {
            throw new IllegalStateException();
        }
        if (introducedVersion < this._minimumVersion) {
            this._minimumVersion = introducedVersion;
        }
        this._conversions.put(introducedVersion, conversion);
    }

    public boolean runConversions(ConversionStage stage) {
        int startingVersion;
        for (int version = startingVersion = Math.max(stage.converterVersion() + 1, this._minimumVersion); version <= 11; ++version) {
            Conversion conversion = this.conversionFor(version);
            if (conversion == null) {
                throw new IllegalStateException("Could not find a conversion for version " + version);
            }
            stage.accept(conversion);
        }
        return true;
    }
}

