/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.array;

import com.db4o.Debug4;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.UnsupportedOldFormatException;
import com.db4o.foundation.BitMap4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.AbstractBufferContext;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Comparable4;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PreparedArrayContainsComparison;
import com.db4o.internal.PrimitiveTypeMetadata;
import com.db4o.internal.Reflection4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandlerCloneContext;
import com.db4o.internal.VersionedTypeHandler;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.handlers.array.ArrayVersionHelper;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.array.ReflectArrayIterator;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.marshall.BufferContext;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ArrayInfo;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.CascadingTypeHandler;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.TypeHandler4;
import com.db4o.typehandlers.ValueTypeHandler;

public class ArrayHandler
implements CascadingTypeHandler,
Comparable4,
ValueTypeHandler,
VariableLengthTypeHandler,
VersionedTypeHandler,
QueryableTypeHandler {
    private TypeHandler4 _handler;
    private boolean _usePrimitiveClassReflector;
    protected final ArrayVersionHelper _versionHelper = this.createVersionHelper();
    private static final int HASHCODE_FOR_NULL = 9141078;

    public ArrayHandler() {
    }

    public ArrayHandler(TypeHandler4 handler, boolean usePrimitiveClassReflector) {
        this();
        this._handler = handler;
        this._usePrimitiveClassReflector = usePrimitiveClassReflector;
    }

    protected ArrayVersionHelper createVersionHelper() {
        return new ArrayVersionHelper();
    }

    protected ReflectArray arrayReflector(ObjectContainerBase container) {
        return container.reflector().array();
    }

    public Iterator4 allElements(ObjectContainerBase container, Object a_object) {
        return ArrayHandler.allElements(this.arrayReflector(container), a_object);
    }

    public static Iterator4 allElements(ReflectArray reflectArray, Object array) {
        return new ReflectArrayIterator(reflectArray, array);
    }

    public final void cascadeActivation(ActivationContext context) {
        if (!Handlers4.isCascading(this._handler)) {
            return;
        }
        ObjectContainerBase container = context.container();
        Iterator4 all = this.allElements(container, context.targetObject());
        while (all.moveNext()) {
            context.cascadeActivationToChild(all.current());
        }
    }

    ObjectContainerBase container(Transaction trans) {
        return trans.container();
    }

    public void collectIDs(final QueryingReadContext context) {
        final TypeHandler4 handler = HandlerRegistry.correctHandlerVersion(context, this._handler);
        this.forEachElement(context, new Runnable(){

            public void run() {
                context.readId(handler);
            }
        });
    }

    protected ArrayInfo forEachElement(final AbstractBufferContext context, final Runnable elementRunnable) {
        final ArrayInfo info = this.newArrayInfo();
        this.withContent(context, new Runnable(){

            public void run() {
                if (context.buffer() == null) {
                    return;
                }
                if (ArrayHandler.this.isUntypedByteArray(context)) {
                    return;
                }
                ArrayHandler.this.readInfo(context.transaction(), context, info);
                int elementCount = info.elementCount();
                elementCount -= ArrayHandler.this.reducedCountForNullBitMap(info, context);
                for (int i = 0; i < elementCount; ++i) {
                    elementRunnable.run();
                }
            }
        });
        return info;
    }

    protected void withContent(AbstractBufferContext context, Runnable runnable) {
        runnable.run();
    }

    private int reducedCountForNullBitMap(ArrayInfo info, ReadBuffer context) {
        if (!this.hasNullBitmap(info)) {
            return 0;
        }
        return this.reducedCountForNullBitMap(info.elementCount(), this.readNullBitmap(context, info.elementCount()));
    }

    private int reducedCountForNullBitMap(int count, BitMap4 bitMap) {
        int nullCount = 0;
        for (int i = 0; i < count; ++i) {
            if (!bitMap.isTrue(i)) continue;
            ++nullCount;
        }
        return nullCount;
    }

    public void delete(final DeleteContext context) throws Db4oIOException {
        if (!this.cascadeDelete(context)) {
            return;
        }
        this.forEachElement((AbstractBufferContext)((Object)context), new Runnable(){

            public void run() {
                ArrayHandler.this._handler.delete(context);
            }
        });
    }

    private boolean cascadeDelete(DeleteContext context) {
        return context.cascadeDelete() && Handlers4.isCascading(this._handler);
    }

    public final void deletePrimitiveEmbedded(StatefulBuffer buffer, PrimitiveTypeMetadata classPrimitive) {
        buffer.readInt();
        buffer.readInt();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayHandler)) {
            return false;
        }
        ArrayHandler other = (ArrayHandler)obj;
        if (other.identifier() != this.identifier()) {
            return false;
        }
        if (this._handler == null) {
            return other._handler == null;
        }
        return this._handler.equals(other._handler) && this._usePrimitiveClassReflector == other._usePrimitiveClassReflector;
    }

    public int hashCode() {
        if (this._handler == null) {
            return 9141078;
        }
        int hc = this._handler.hashCode() >> 7;
        return this._usePrimitiveClassReflector ? hc : -hc;
    }

    protected boolean handleAsByteArray(Object obj) {
        return obj instanceof byte[];
    }

    public byte identifier() {
        return 78;
    }

    public ReflectClass primitiveClassReflector(Reflector reflector) {
        return Handlers4.primitiveClassReflector(this._handler, reflector);
    }

    protected Object readCreate(Transaction trans, ReadBuffer buffer, ArrayInfo info) {
        this.readInfo(trans, buffer, info);
        ReflectClass clazz = this.newInstanceReflectClass(trans.reflector(), info);
        if (clazz == null) {
            return null;
        }
        return this.newInstance(this.arrayReflector(this.container(trans)), info, clazz);
    }

    protected final Object newInstance(ReflectArray arrayReflector, ArrayInfo info, ReflectClass clazz) {
        return arrayReflector.newInstance(clazz, info);
    }

    protected final ReflectClass newInstanceReflectClass(Reflector reflector, ArrayInfo info) {
        if (this._usePrimitiveClassReflector) {
            return this.primitiveClassReflector(reflector);
        }
        return info.reflectClass();
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        return this;
    }

    protected void readInfo(Transaction trans, ReadBuffer buffer, ArrayInfo info) {
        int classID = buffer.readInt();
        if (this.isPreVersion0Format(classID)) {
            throw new UnsupportedOldFormatException();
        }
        this._versionHelper.readTypeInfo(trans, buffer, info, classID);
        this.reflectClassFromElementsEntry(this.container(trans), info, classID);
        this.readDimensions(info, buffer);
        if (Debug4.exceedsMaximumArrayEntries(info.elementCount(), this._usePrimitiveClassReflector)) {
            info.elementCount(0);
        }
    }

    protected void readDimensions(ArrayInfo info, ReadBuffer buffer) {
        info.elementCount(buffer.readInt());
    }

    protected boolean isPreVersion0Format(int elementCount) {
        return this._versionHelper.isPreVersion0Format(elementCount);
    }

    private void reflectClassFromElementsEntry(ObjectContainerBase container, ArrayInfo info, int classID) {
        info.reflectClass(this._versionHelper.reflectClassFromElementsEntry(container, info, classID));
    }

    protected final ReflectClass classReflector(Reflector reflector, ClassMetadata classMetadata, boolean isPrimitive) {
        return this._versionHelper.classReflector(reflector, classMetadata, isPrimitive);
    }

    public static Iterator4 iterator(ReflectClass claxx, Object obj) {
        ReflectArray reflectArray = claxx.reflector().array();
        if (reflectArray.isNDimensional(claxx)) {
            return MultidimensionalArrayHandler.allElementsMultidimensional(reflectArray, obj);
        }
        return ArrayHandler.allElements(reflectArray, obj);
    }

    protected boolean useJavaHandling() {
        return this._versionHelper.useJavaHandling();
    }

    protected int classIDFromInfo(ObjectContainerBase container, ArrayInfo info) {
        return this._versionHelper.classIDFromInfo(container, info);
    }

    private final int marshalledClassID(ObjectContainerBase container, ArrayInfo info) {
        return this.classIdToMarshalledClassId(this.classIDFromInfo(container, info), info.primitive());
    }

    public final int classIdToMarshalledClassId(int classID, boolean primitive) {
        return this._versionHelper.classIdToMarshalledClassId(classID, primitive);
    }

    protected final boolean isPrimitive(Reflector reflector, ReflectClass claxx, ClassMetadata classMetadata) {
        return this._versionHelper.isPrimitive(reflector, claxx, classMetadata);
    }

    private ReflectClass componentType(ObjectContainerBase container, Object obj) {
        return this.arrayReflector(container).getComponentType(container.reflector().forObject(obj));
    }

    public void defragment(DefragmentContext context) {
        if (Handlers4.isPrimitive(this._handler)) {
            context.incrementOffset(this.linkLength());
        } else {
            this.defragmentSlot(context);
        }
    }

    public final void defragmentSlot(DefragmentContext context) {
        if (this.isUntypedByteArray(context)) {
            return;
        }
        int classIdOffset = context.targetBuffer().offset();
        ArrayInfo info = this.newArrayInfo();
        this.readInfo(context.transaction(), context, info);
        this.defragmentWriteMappedClassId(context, info, classIdOffset);
        int elementCount = info.elementCount();
        if (this.hasNullBitmap(info)) {
            BitMap4 bitMap = this.readNullBitmap(context, elementCount);
            elementCount -= this.reducedCountForNullBitMap(elementCount, bitMap);
        }
        TypeHandler4 correctTypeHandlerVersion = this.correctHandlerVersion(context, this._handler, info);
        for (int i = 0; i < elementCount; ++i) {
            context.defragment(correctTypeHandlerVersion);
        }
    }

    private TypeHandler4 correctHandlerVersion(DefragmentContext context, TypeHandler4 handler, ArrayInfo info) {
        ClassMetadata classMetadata = this.classMetadata(context, info);
        return HandlerRegistry.correctHandlerVersion(context, handler, classMetadata);
    }

    private ClassMetadata classMetadata(DefragmentContext context, ArrayInfo info) {
        int classMetadataId = this.classIDFromInfo(this.container(context), info);
        return this.container(context).classMetadataForID(classMetadataId);
    }

    private void defragmentWriteMappedClassId(DefragmentContext context, ArrayInfo info, int classIdOffset) {
        ByteArrayBuffer targetBuffer = context.targetBuffer();
        int currentOffset = targetBuffer.offset();
        targetBuffer.seek(classIdOffset);
        int classID = this.classIDFromInfo(this.container(context), info);
        int mappedID = context.mappedID(classID);
        int marshalledMappedId = this.classIdToMarshalledClassId(mappedID, info.primitive());
        targetBuffer.writeInt(marshalledMappedId);
        targetBuffer.seek(currentOffset);
    }

    private boolean isUntypedByteArray(BufferContext context) {
        return Handlers4.isUntyped(this._handler) && this.handleAsByteArray(context);
    }

    protected boolean handleAsByteArray(BufferContext context) {
        int offset = context.offset();
        ArrayInfo info = this.newArrayInfo();
        this.readInfo(context.transaction(), context, info);
        boolean isByteArray = context.transaction().reflector().forClass(Byte.TYPE).equals(info.reflectClass());
        context.seek(offset);
        return isByteArray;
    }

    public Object read(ReadContext context) {
        ArrayInfo info = this.newArrayInfo();
        Object array = this.readCreate(context.transaction(), context, info);
        this.readElements(context, info, array);
        return array;
    }

    protected void readElements(ReadContext context, ArrayInfo info, Object array) {
        this.readInto(context, info, array);
    }

    protected ArrayInfo newArrayInfo() {
        return new ArrayInfo();
    }

    protected final void readInto(ReadContext context, ArrayInfo info, Object array) {
        if (array == null) {
            return;
        }
        if (this.handleAsByteArray(array)) {
            context.readBytes((byte[])array);
            return;
        }
        if (this.hasNullBitmap(info)) {
            BitMap4 nullBitMap = this.readNullBitmap(context, info.elementCount());
            for (int i = 0; i < info.elementCount(); ++i) {
                Object obj = nullBitMap.isTrue(i) ? null : context.readObject(this._handler);
                this.arrayReflector(this.container(context)).set(array, i, obj);
            }
        } else {
            for (int i = 0; i < info.elementCount(); ++i) {
                this.arrayReflector(this.container(context)).set(array, i, context.readObject(this._handler));
            }
        }
    }

    protected BitMap4 readNullBitmap(ReadBuffer context, int length) {
        return context.readBitMap(length);
    }

    protected final boolean hasNullBitmap(ArrayInfo info) {
        return this._versionHelper.hasNullBitmap(info);
    }

    public void write(WriteContext context, Object obj) {
        ArrayInfo info = this.newArrayInfo();
        this.analyze(this.container(context), obj, info);
        this.writeInfo(context, info);
        this.writeElements(context, obj, info);
    }

    protected void writeElements(WriteContext context, Object obj, ArrayInfo info) {
        if (this.handleAsByteArray(obj)) {
            context.writeBytes((byte[])obj);
        } else if (this.hasNullBitmap(info)) {
            BitMap4 nullItems = this.nullItemsMap(this.arrayReflector(this.container(context)), obj);
            this.writeNullBitmap(context, nullItems);
            for (int i = 0; i < info.elementCount(); ++i) {
                if (nullItems.isTrue(i)) continue;
                context.writeObject(this._handler, this.arrayReflector(this.container(context)).get(obj, i));
            }
        } else {
            for (int i = 0; i < info.elementCount(); ++i) {
                context.writeObject(this._handler, this.arrayReflector(this.container(context)).get(obj, i));
            }
        }
    }

    protected void writeInfo(WriteContext context, ArrayInfo info) {
        this.writeHeader(context, info);
        this.writeDimensions(context, info);
    }

    private void writeHeader(WriteContext context, ArrayInfo info) {
        context.writeInt(this.marshalledClassID(this.container(context), info));
        this._versionHelper.writeTypeInfo(context, info);
    }

    protected void writeDimensions(WriteContext context, ArrayInfo info) {
        context.writeInt(info.elementCount());
    }

    protected final void analyze(ObjectContainerBase container, Object obj, ArrayInfo info) {
        this.arrayReflector(container).analyze(obj, info);
        ReflectClass claxx = this.componentType(container, obj);
        ClassMetadata classMetadata = container.produceClassMetadata(claxx);
        boolean primitive = this.isPrimitive(container.reflector(), claxx, classMetadata);
        if (primitive) {
            claxx = classMetadata.classReflector();
        }
        info.primitive(primitive);
        info.reflectClass(claxx);
        this.analyzeDimensions(container, obj, info);
    }

    protected void analyzeDimensions(ObjectContainerBase container, Object obj, ArrayInfo info) {
        info.elementCount(this.arrayReflector(container).getLength(obj));
    }

    private void writeNullBitmap(WriteBuffer context, BitMap4 bitMap) {
        context.writeBytes(bitMap.bytes());
    }

    protected BitMap4 nullItemsMap(ReflectArray reflector, Object array) {
        int arrayLength = reflector.getLength(array);
        BitMap4 nullBitMap = new BitMap4(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            if (reflector.get(array, i) != null) continue;
            nullBitMap.set(i, true);
        }
        return nullBitMap;
    }

    ObjectContainerBase container(Context context) {
        return context.transaction().container();
    }

    public PreparedComparison prepareComparison(Context context, Object obj) {
        return new PreparedArrayContainsComparison(context, this, this._handler, obj);
    }

    public int linkLength() {
        return 8;
    }

    public TypeHandler4 unversionedTemplate() {
        return new ArrayHandler();
    }

    public Object deepClone(Object context) {
        TypeHandlerCloneContext typeHandlerCloneContext = (TypeHandlerCloneContext)context;
        ArrayHandler original = (ArrayHandler)typeHandlerCloneContext.original;
        ArrayHandler cloned = (ArrayHandler)Reflection4.newInstance(this);
        cloned._usePrimitiveClassReflector = original._usePrimitiveClassReflector;
        cloned._handler = typeHandlerCloneContext.correctHandlerVersion(original.delegateTypeHandler());
        return cloned;
    }

    public TypeHandler4 delegateTypeHandler() {
        return this._handler;
    }

    public String toString() {
        return "ArrayHandler(isPrimitive=" + this._usePrimitiveClassReflector + ", handler=" + this._handler + ")";
    }

    public boolean descendsIntoMembers() {
        return true;
    }
}

