/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.versions;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.versions.OpenTypeHandler2;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.ReadContext;
import com.db4o.typehandlers.TypeHandler4;
import java.io.IOException;

public class OpenTypeHandler0
extends OpenTypeHandler2 {
    public OpenTypeHandler0(ObjectContainerBase container) {
        super(container);
    }

    public Object read(ReadContext context) {
        return context.readObject();
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        StatefulBuffer reader;
        int id = 0;
        int offset = context.offset();
        try {
            id = context.readInt();
        }
        catch (Exception e) {
            // empty catch block
        }
        context.seek(offset);
        if (id != 0 && (reader = context.container().readWriterByID(context.transaction(), id)) != null) {
            ObjectHeader oh = new ObjectHeader(context.container(), (ReadWriteBuffer)reader);
            try {
                if (oh.classMetadata() != null) {
                    context.buffer(reader);
                    return oh.classMetadata().seekCandidateHandler(context);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public ObjectID readObjectID(InternalReadContext context) {
        int id = context.readInt();
        return id == 0 ? ObjectID.IS_NULL : new ObjectID(id);
    }

    public void defragment(DefragmentContext context) {
        int sourceId = context.sourceBuffer().readInt();
        if (sourceId == 0) {
            context.targetBuffer().writeInt(0);
            return;
        }
        int targetId = 0;
        try {
            targetId = context.mappedID(sourceId);
        }
        catch (MappingNotFoundException exc) {
            targetId = this.copyDependentSlot(context, sourceId);
        }
        context.targetBuffer().writeInt(targetId);
    }

    private int copyDependentSlot(DefragmentContext context, int sourceId) {
        try {
            ByteArrayBuffer sourceBuffer = context.sourceBufferById(sourceId);
            Slot targetPointerSlot = context.allocateMappedTargetSlot(sourceId, 8);
            Slot targetPayloadSlot = context.allocateTargetSlot(sourceBuffer.length());
            ByteArrayBuffer pointerBuffer = new ByteArrayBuffer(8);
            pointerBuffer.writeInt(targetPayloadSlot.address());
            pointerBuffer.writeInt(targetPayloadSlot.length());
            context.targetWriteBytes(targetPointerSlot.address(), pointerBuffer);
            DefragmentContextImpl payloadContext = new DefragmentContextImpl(sourceBuffer, (DefragmentContextImpl)context);
            int clazzId = payloadContext.copyIDReturnOriginalID();
            TypeHandler4 payloadHandler = payloadContext.typeHandlerForId(clazzId);
            TypeHandler4 versionedPayloadHandler = HandlerRegistry.correctHandlerVersion(payloadContext, payloadHandler);
            versionedPayloadHandler.defragment(payloadContext);
            payloadContext.writeToTarget(targetPayloadSlot.address());
            return targetPointerSlot.address();
        }
        catch (IOException ioexc) {
            throw new Db4oIOException(ioexc);
        }
    }
}

