/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.io.File4;
import com.db4o.internal.Platform4;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.RandomAccessFileFactory;
import com.db4o.io.Storage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileStorage
implements Storage {
    public Bin open(BinConfiguration config) throws Db4oIOException {
        return new FileBin(config);
    }

    public boolean exists(String uri) {
        File file = new File(uri);
        return file.exists() && file.length() > 0L;
    }

    public void delete(String uri) throws IOException {
        File4.delete(uri);
    }

    public void rename(String oldUri, String newUri) throws IOException {
        File4.rename(oldUri, newUri);
    }

    static class FileBin
    implements Bin {
        private final String _path;
        private RandomAccessFile _file;

        FileBin(BinConfiguration config) throws Db4oIOException {
            boolean ok = false;
            try {
                this._path = new File(config.uri()).getCanonicalPath();
                this._file = RandomAccessFileFactory.newRandomAccessFile(this._path, config.readOnly(), config.lockFile());
                if (config.initialLength() > 0L) {
                    this.write(config.initialLength() - 1L, new byte[]{0}, 1);
                }
                ok = true;
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
            finally {
                if (!ok) {
                    this.close();
                }
            }
        }

        public void close() throws Db4oIOException {
            Platform4.unlockFile(this._path, this._file);
            try {
                if (!this.isClosed()) {
                    this._file.close();
                }
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
            finally {
                this._file = null;
            }
        }

        boolean isClosed() {
            return this._file == null;
        }

        public long length() throws Db4oIOException {
            try {
                return this._file.length();
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
        }

        public int read(long pos, byte[] bytes, int length) throws Db4oIOException {
            try {
                this.seek(pos);
                return this._file.read(bytes, 0, length);
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
        }

        void seek(long pos) throws IOException {
            if (DTrace.enabled) {
                DTrace.REGULAR_SEEK.log(pos);
            }
            this._file.seek(pos);
        }

        public void sync() throws Db4oIOException {
            try {
                this._file.getFD().sync();
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
        }

        public int syncRead(long position, byte[] bytes, int bytesToRead) {
            return this.read(position, bytes, bytesToRead);
        }

        public void write(long pos, byte[] buffer, int length) throws Db4oIOException {
            this.checkClosed();
            try {
                this.seek(pos);
                this._file.write(buffer, 0, length);
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
        }

        private void checkClosed() {
            if (this.isClosed()) {
                throw new Db4oIOException();
            }
        }
    }
}

