/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Environments;
import com.db4o.foundation.Listener4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.BlockSize;
import com.db4o.io.IoAdapter;
import com.db4o.io.Storage;
import java.io.IOException;

public class IoAdapterStorage
implements Storage {
    private final IoAdapter _io;

    public IoAdapterStorage(IoAdapter io) {
        this._io = io;
    }

    public boolean exists(String uri) {
        return this._io.exists(uri);
    }

    public Bin open(BinConfiguration config) throws Db4oIOException {
        IoAdapterBin bin = new IoAdapterBin(this._io.open(config.uri(), config.lockFile(), config.initialLength(), config.readOnly()));
        Environments.my(BlockSize.class).register(bin);
        return bin;
    }

    public void delete(String uri) throws IOException {
        this._io.delete(uri);
    }

    public void rename(String oldUri, String newUri) throws IOException {
        throw new NotImplementedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IoAdapterBin
    implements Bin,
    Listener4<Integer> {
        private final IoAdapter _io;

        public IoAdapterBin(IoAdapter io) {
            this._io = io;
        }

        @Override
        public void close() {
            this._io.close();
        }

        @Override
        public long length() {
            return this._io.getLength();
        }

        @Override
        public int read(long position, byte[] buffer, int bytesToRead) {
            this._io.seek(position);
            return this._io.read(buffer, bytesToRead);
        }

        @Override
        public void sync() {
            this._io.sync();
        }

        @Override
        public int syncRead(long position, byte[] bytes, int bytesToRead) {
            return this.read(position, bytes, bytesToRead);
        }

        @Override
        public void write(long position, byte[] bytes, int bytesToWrite) {
            this._io.seek(position);
            this._io.write(bytes, bytesToWrite);
        }

        public void blockSize(int blockSize) {
            this._io.blockSize(blockSize);
        }

        @Override
        public void onEvent(Integer event) {
            this.blockSize(event);
        }
    }
}

