/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArrayFactory;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.CompositeIterable4;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.EnumerateIterator;
import com.db4o.foundation.FilteredIterator;
import com.db4o.foundation.FlatteningIterator;
import com.db4o.foundation.Function4;
import com.db4o.foundation.FunctionApplicationIterator;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.SingleValueIterator;

public class Iterators {
    public static final Object SKIP = new Object();
    public static final Iterator4 EMPTY_ITERATOR = new Iterator4(){

        public Object current() {
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            return false;
        }

        public void reset() {
            throw new NotImplementedException();
        }
    };
    public static final Iterable4 EMPTY_ITERABLE = new Iterable4(){

        public Iterator4 iterator() {
            return EMPTY_ITERATOR;
        }
    };
    static final Object NO_ELEMENT = new Object();

    public static Iterable4 enumerate(final Iterable4 iterable) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return new EnumerateIterator(iterable.iterator());
            }
        };
    }

    public static Iterator4 concat(Iterator4[] array) {
        return Iterators.concat(Iterators.iterate(array));
    }

    public static Iterator4 concat(Iterator4 iterators) {
        return new CompositeIterator4(iterators);
    }

    public static Iterable4 concat(Iterable4[] iterables) {
        return Iterators.concat(Iterators.iterable(iterables));
    }

    public static Iterable4 concat(Iterable4 iterables) {
        return new CompositeIterable4(iterables);
    }

    public static Iterator4 concat(Iterator4 first, Iterator4 second) {
        return Iterators.concat(new Iterator4[]{first, second});
    }

    public static Iterable4 concatMap(Iterable4 iterable, Function4 function) {
        return Iterators.concat(Iterators.map(iterable, function));
    }

    public static Iterator4 map(Iterator4 iterator, Function4 function) {
        return new FunctionApplicationIterator(iterator, function);
    }

    public static Iterator4 map(Object[] array, Function4 function) {
        return Iterators.map(new ArrayIterator4(array), function);
    }

    public static Iterator4 filter(Object[] array, Predicate4 predicate) {
        return Iterators.filter(new ArrayIterator4(array), predicate);
    }

    public static Iterable4 filter(final Iterable4 source, final Predicate4 predicate) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return Iterators.filter(source.iterator(), predicate);
            }
        };
    }

    public static Iterator4 filter(Iterator4 iterator, Predicate4 predicate) {
        return new FilteredIterator(iterator, predicate);
    }

    public static Iterable4 cons(final Object element) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return Iterators.iterateSingle(element);
            }
        };
    }

    public static Iterable4 cons(Iterable4 front, Object last) {
        return Iterators.concat(Iterators.iterable(new Object[]{front, Iterators.cons(last)}));
    }

    public static Iterator4 iterate(Object[] array) {
        return new ArrayIterator4(array);
    }

    public static int size(Iterable4 iterable) {
        return Iterators.size(iterable.iterator());
    }

    public static Object next(Iterator4 iterator) {
        if (!iterator.moveNext()) {
            throw new IllegalStateException();
        }
        return iterator.current();
    }

    public static int size(Iterator4 iterator) {
        int count = 0;
        while (iterator.moveNext()) {
            ++count;
        }
        return count;
    }

    public static String toString(Iterable4 i) {
        return Iterators.toString(i.iterator());
    }

    public static String toString(Iterator4 i) {
        return Iterators.join(i, "[", "]", ", ");
    }

    public static String join(Iterable4 i, String separator) {
        return Iterators.join(i.iterator(), separator);
    }

    public static String join(Iterator4 i, String separator) {
        return Iterators.join(i, "", "", separator);
    }

    public static String join(Iterator4 i, String prefix, String suffix, String separator) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        if (i.moveNext()) {
            sb.append(i.current());
            while (i.moveNext()) {
                sb.append(separator);
                sb.append(i.current());
            }
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static Object[] toArray(Iterator4 tests) {
        return Iterators.toArray(tests, new ArrayFactory(){

            public Object[] newArray(int size) {
                return new Object[size];
            }
        });
    }

    public static Object[] toArray(Iterator4 tests, ArrayFactory factory) {
        Collection4 elements = new Collection4(tests);
        return elements.toArray(factory.newArray(elements.size()));
    }

    public static Iterator4 flatten(Iterator4 iterator) {
        return new FlatteningIterator(iterator);
    }

    public static Iterable4 map(final Iterable4 iterable, final Function4 function) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return Iterators.map(iterable.iterator(), function);
            }
        };
    }

    public static Iterable4 crossProduct(Iterable4 iterables) {
        return Iterators.crossProduct((Iterable4[])Iterators.toArray(iterables.iterator(), new ArrayFactory(){

            public Object[] newArray(int size) {
                return new Iterable4[size];
            }
        }));
    }

    public static Iterable4 crossProduct(Iterable4[] iterables) {
        return Iterators.crossProduct(iterables, 0, EMPTY_ITERABLE);
    }

    private static Iterable4 crossProduct(final Iterable4[] iterables, final int level, final Iterable4 row) {
        if (level == iterables.length - 1) {
            return Iterators.map(iterables[level], new Function4(){

                public Object apply(Object arg) {
                    return Iterators.cons(row, arg);
                }
            });
        }
        return Iterators.concatMap(iterables[level], new Function4(){

            public Object apply(Object arg) {
                return Iterators.crossProduct(iterables, level + 1, Iterators.cons(row, arg));
            }
        });
    }

    public static Iterable4 iterable(final Object[] objects) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return Iterators.iterate(objects);
            }
        };
    }

    public static Iterator4 iterateSingle(Object element) {
        return new SingleValueIterator(element);
    }

    public static Iterable4 iterable(final Iterator4 iterator) {
        return new Iterable4(){

            public Iterator4 iterator() {
                return iterator;
            }
        };
    }
}

