/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.HandlerVersionRegistry;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.SharedIndexedFields;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.UntypedFieldHandler0;
import com.db4o.internal.UntypedFieldHandler2;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.fieldhandlers.FieldHandler;
import com.db4o.internal.fieldhandlers.UntypedArrayFieldHandler;
import com.db4o.internal.fieldhandlers.UntypedMultidimensionalArrayFieldHandler;
import com.db4o.internal.handlers.BooleanHandler;
import com.db4o.internal.handlers.ByteHandler;
import com.db4o.internal.handlers.CharHandler;
import com.db4o.internal.handlers.DateHandler;
import com.db4o.internal.handlers.DateHandler0;
import com.db4o.internal.handlers.DoubleHandler;
import com.db4o.internal.handlers.DoubleHandler0;
import com.db4o.internal.handlers.FirstClassObjectHandler;
import com.db4o.internal.handlers.FirstClassObjectHandler0;
import com.db4o.internal.handlers.FloatHandler;
import com.db4o.internal.handlers.FloatHandler0;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.handlers.IntHandler0;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.handlers.LongHandler0;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.PlainObjectHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.ShortHandler;
import com.db4o.internal.handlers.ShortHandler0;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.handlers.StringHandler0;
import com.db4o.internal.handlers.TypeInfo;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.ArrayHandler0;
import com.db4o.internal.handlers.array.ArrayHandler2;
import com.db4o.internal.handlers.array.ArrayHandler3;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler0;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler3;
import com.db4o.internal.marshall.SlotFormat;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.EmbeddedTypeHandler;
import com.db4o.typehandlers.TypeHandler4;

public final class HandlerRegistry {
    public static final byte HANDLER_VERSION = 4;
    private final ObjectContainerBase _container;
    private static final Db4oTypeImpl[] _db4oTypes = new Db4oTypeImpl[]{new BlobImpl()};
    private ClassMetadata _untypedArrayHandler;
    private ClassMetadata _untypedMultiDimensionalArrayHandler;
    private FieldHandler _untypedFieldHandler;
    public StringHandler _stringHandler;
    private Hashtable4 _mapIdToTypeInfo = HandlerRegistry.newHashtable();
    private Hashtable4 _mapFieldHandlerToId = HandlerRegistry.newHashtable();
    private Hashtable4 _mapTypeHandlerToId = HandlerRegistry.newHashtable();
    private Hashtable4 _mapReflectorToClassMetadata = HandlerRegistry.newHashtable();
    private int _highestBuiltinTypeID = 14;
    private final VirtualFieldMetadata[] _virtualFields = new VirtualFieldMetadata[2];
    private final Hashtable4 _mapReflectorToFieldHandler = HandlerRegistry.newHashtable();
    private final Hashtable4 _mapReflectorToTypeHandler = HandlerRegistry.newHashtable();
    private final Hashtable4 _mapFieldHandlerToReflector = HandlerRegistry.newHashtable();
    private SharedIndexedFields _indexes;
    Db4oReplicationReferenceProvider _replicationReferenceProvider;
    public final DiagnosticProcessor _diagnosticProcessor;
    public boolean i_encrypt;
    byte[] i_encryptor;
    int i_lastEncryptorByte;
    final GenericReflector _reflector;
    private final HandlerVersionRegistry _handlerVersions = new HandlerVersionRegistry(this);
    private LatinStringIO _stringIO;
    public ReflectClass ICLASS_COMPARE;
    ReflectClass ICLASS_DB4OTYPE;
    ReflectClass ICLASS_DB4OTYPEIMPL;
    public ReflectClass ICLASS_INTERNAL;
    ReflectClass ICLASS_UNVERSIONED;
    public ReflectClass ICLASS_OBJECT;
    ReflectClass ICLASS_OBJECTCONTAINER;
    public ReflectClass ICLASS_STATICCLASS;
    public ReflectClass ICLASS_STRING;
    ReflectClass ICLASS_TRANSIENTCLASS;

    HandlerRegistry(ObjectContainerBase container, byte stringEncoding, GenericReflector reflector) {
        this._stringIO = BuiltInStringEncoding.stringIoForEncoding(stringEncoding, container.configImpl().stringEncoding());
        this._container = container;
        container._handlers = this;
        this._reflector = reflector;
        this._diagnosticProcessor = container.configImpl().diagnosticProcessor();
        this.initClassReflectors(reflector);
        this._indexes = new SharedIndexedFields();
        this._virtualFields[0] = this._indexes._version;
        this._virtualFields[1] = this._indexes._uUID;
        this.registerBuiltinHandlers();
        this.registerPlatformTypes();
        this.initArrayHandlers();
        Platform4.registerPlatformHandlers(container);
    }

    private void initArrayHandlers() {
        TypeHandler4 handler = (TypeHandler4)this.fieldHandlerForId(11);
        this._untypedArrayHandler = new PrimitiveFieldHandler(this.container(), new ArrayHandler(handler, false), 12, this.ICLASS_OBJECT);
        this.mapTypeInfo(12, this._untypedArrayHandler, new UntypedArrayFieldHandler(), this._untypedArrayHandler, null);
        this._untypedMultiDimensionalArrayHandler = new PrimitiveFieldHandler(this.container(), new MultidimensionalArrayHandler(handler, false), 13, this.ICLASS_OBJECT);
        this.mapTypeInfo(13, this._untypedMultiDimensionalArrayHandler, new UntypedMultidimensionalArrayFieldHandler(), this._untypedMultiDimensionalArrayHandler, null);
    }

    private void registerPlatformTypes() {
        NetTypeHandler[] handlers = Platform4.types(this._container.reflector());
        for (int i = 0; i < handlers.length; ++i) {
            this.registerNetTypeHandler(handlers[i]);
        }
    }

    public void registerNetTypeHandler(NetTypeHandler handler) {
        handler.registerReflector(this._reflector);
        GenericConverter converter = handler instanceof GenericConverter ? (GenericConverter)((Object)handler) : null;
        this.registerBuiltinHandler(handler.getID(), handler, true, handler.getName(), converter);
    }

    private void registerBuiltinHandlers() {
        IntHandler intHandler = new IntHandler();
        this.registerBuiltinHandler(1, intHandler);
        this.registerHandlerVersion(intHandler, 0, new IntHandler0());
        LongHandler longHandler = new LongHandler();
        this.registerBuiltinHandler(2, longHandler);
        this.registerHandlerVersion(longHandler, 0, new LongHandler0());
        FloatHandler floatHandler = new FloatHandler();
        this.registerBuiltinHandler(3, floatHandler);
        this.registerHandlerVersion(floatHandler, 0, new FloatHandler0());
        BooleanHandler booleanHandler = new BooleanHandler();
        this.registerBuiltinHandler(4, booleanHandler);
        DoubleHandler doubleHandler = new DoubleHandler();
        this.registerBuiltinHandler(5, doubleHandler);
        this.registerHandlerVersion(doubleHandler, 0, new DoubleHandler0());
        ByteHandler byteHandler = new ByteHandler();
        this.registerBuiltinHandler(6, byteHandler);
        CharHandler charHandler = new CharHandler();
        this.registerBuiltinHandler(7, charHandler);
        ShortHandler shortHandler = new ShortHandler();
        this.registerBuiltinHandler(8, shortHandler);
        this.registerHandlerVersion(shortHandler, 0, new ShortHandler0());
        this._stringHandler = new StringHandler();
        this.registerBuiltinHandler(9, this._stringHandler);
        this.registerHandlerVersion(this._stringHandler, 0, new StringHandler0());
        DateHandler dateHandler = new DateHandler();
        this.registerBuiltinHandler(10, dateHandler);
        this.registerHandlerVersion(dateHandler, 0, new DateHandler0());
        this.registerUntypedHandlers();
        this.registerCompositeHandlerVersions();
    }

    private void registerUntypedHandlers() {
        int id = 11;
        this._untypedFieldHandler = new UntypedFieldHandler(this.container());
        PrimitiveFieldHandler classMetadata = new PrimitiveFieldHandler(this.container(), (TypeHandler4)this._untypedFieldHandler, id, this.ICLASS_OBJECT);
        this.map(id, classMetadata, this._untypedFieldHandler, new PlainObjectHandler(), this.ICLASS_OBJECT);
        this.registerHandlerVersion(this._untypedFieldHandler, 0, new UntypedFieldHandler0(this.container()));
        this.registerHandlerVersion(this._untypedFieldHandler, 2, new UntypedFieldHandler2(this.container()));
    }

    private void registerCompositeHandlerVersions() {
        FirstClassObjectHandler firstClassObjectHandler = new FirstClassObjectHandler();
        this.registerHandlerVersion(firstClassObjectHandler, 0, new FirstClassObjectHandler0());
        ArrayHandler arrayHandler = new ArrayHandler();
        this.registerHandlerVersion(arrayHandler, 0, new ArrayHandler0());
        this.registerHandlerVersion(arrayHandler, 2, new ArrayHandler2());
        this.registerHandlerVersion(arrayHandler, 3, new ArrayHandler3());
        MultidimensionalArrayHandler multidimensionalArrayHandler = new MultidimensionalArrayHandler();
        this.registerHandlerVersion(multidimensionalArrayHandler, 0, new MultidimensionalArrayHandler0());
        this.registerHandlerVersion(multidimensionalArrayHandler, 3, new MultidimensionalArrayHandler3());
        PrimitiveFieldHandler primitiveFieldHandler = new PrimitiveFieldHandler();
        this.registerHandlerVersion(primitiveFieldHandler, 0, primitiveFieldHandler);
        this.registerHandlerVersion(primitiveFieldHandler, 2, primitiveFieldHandler);
    }

    private void registerBuiltinHandler(int id, BuiltinTypeHandler handler) {
        this.registerBuiltinHandler(id, handler, true, null, null);
    }

    private void registerBuiltinHandler(int id, BuiltinTypeHandler typeHandler, boolean registerPrimitiveClass, String primitiveName, GenericConverter converter) {
        ReflectClass primitiveClassReflector;
        typeHandler.registerReflector(this._reflector);
        if (primitiveName == null) {
            primitiveName = typeHandler.classReflector().getName();
        }
        if (registerPrimitiveClass) {
            this._reflector.registerPrimitiveClass(id, primitiveName, converter);
        }
        ReflectClass classReflector = typeHandler.classReflector();
        PrimitiveFieldHandler classMetadata = new PrimitiveFieldHandler(this.container(), typeHandler, id, classReflector);
        this.map(id, classMetadata, typeHandler, typeHandler, classReflector);
        if (typeHandler instanceof PrimitiveHandler && (primitiveClassReflector = ((PrimitiveHandler)typeHandler).primitiveClassReflector()) != null) {
            this.mapPrimitive(0, classMetadata, typeHandler, typeHandler, primitiveClassReflector);
        }
    }

    private void map(int id, ClassMetadata classMetadata, FieldHandler fieldHandler, TypeHandler4 typeHandler, ReflectClass classReflector) {
        this.mapTypeInfo(id, classMetadata, fieldHandler, typeHandler, classReflector);
        this.mapPrimitive(id, classMetadata, fieldHandler, typeHandler, classReflector);
        if (id > this._highestBuiltinTypeID) {
            this._highestBuiltinTypeID = id;
        }
    }

    private void mapTypeInfo(int id, ClassMetadata classMetadata, FieldHandler fieldHandler, TypeHandler4 typeHandler, ReflectClass classReflector) {
        this._mapIdToTypeInfo.put(id, (Object)new TypeInfo(classMetadata, fieldHandler, typeHandler, classReflector));
    }

    private void mapPrimitive(int id, ClassMetadata classMetadata, FieldHandler fieldHandler, TypeHandler4 typeHandler, ReflectClass classReflector) {
        this._mapFieldHandlerToReflector.put(fieldHandler, (Object)classReflector);
        this.mapFieldHandler(classReflector, fieldHandler);
        this._mapReflectorToTypeHandler.put(classReflector, (Object)typeHandler);
        if (classReflector != null) {
            this._mapReflectorToClassMetadata.put(classReflector, (Object)classMetadata);
        }
        if (id != 0) {
            Integer wrappedID = new Integer(id);
            this._mapFieldHandlerToId.put(fieldHandler, (Object)wrappedID);
            this._mapTypeHandlerToId.put(typeHandler, (Object)wrappedID);
        }
    }

    public void mapFieldHandler(ReflectClass classReflector, FieldHandler fieldHandler) {
        this._mapReflectorToFieldHandler.put(classReflector, (Object)fieldHandler);
    }

    private void registerHandlerVersion(FieldHandler handler, int version, TypeHandler4 replacement) {
        if (replacement instanceof BuiltinTypeHandler) {
            ((BuiltinTypeHandler)replacement).registerReflector(this._reflector);
        }
        this._handlerVersions.put(handler, version, replacement);
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 handler, int version) {
        return this._handlerVersions.correctHandlerVersion(handler, version);
    }

    int arrayType(Object obj) {
        ReflectClass claxx = this.reflector().forObject(obj);
        if (!claxx.isArray()) {
            return 0;
        }
        if (this.reflector().array().isNDimensional(claxx)) {
            return 4;
        }
        return 3;
    }

    public final void decrypt(ByteArrayBuffer reader) {
        if (this.i_encrypt) {
            int encryptorOffSet = this.i_lastEncryptorByte;
            byte[] bytes = reader._buffer;
            for (int i = reader.length() - 1; i >= 0; --i) {
                int n = i;
                bytes[n] = (byte)(bytes[n] + this.i_encryptor[encryptorOffSet]);
                if (encryptorOffSet == 0) {
                    encryptorOffSet = this.i_lastEncryptorByte;
                    continue;
                }
                --encryptorOffSet;
            }
        }
    }

    public final void encrypt(ByteArrayBuffer reader) {
        if (this.i_encrypt) {
            byte[] bytes = reader._buffer;
            int encryptorOffSet = this.i_lastEncryptorByte;
            for (int i = reader.length() - 1; i >= 0; --i) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - this.i_encryptor[encryptorOffSet]);
                if (encryptorOffSet == 0) {
                    encryptorOffSet = this.i_lastEncryptorByte;
                    continue;
                }
                --encryptorOffSet;
            }
        }
    }

    public void oldEncryptionOff() {
        this.i_encrypt = false;
        this.i_encryptor = null;
        this.i_lastEncryptorByte = 0;
        this.container().configImpl().oldEncryptionOff();
    }

    public final ReflectClass classForID(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.classReflector;
    }

    public final TypeHandler4 typeHandlerForID(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.typeHandler;
    }

    private TypeInfo typeInfoForID(int id) {
        return (TypeInfo)this._mapIdToTypeInfo.get(id);
    }

    public final int typeHandlerID(TypeHandler4 handler) {
        if (handler instanceof ClassMetadata) {
            return ((ClassMetadata)handler).getID();
        }
        Object idAsInt = this._mapTypeHandlerToId.get(handler);
        if (idAsInt == null) {
            return 0;
        }
        return (Integer)idAsInt;
    }

    private void initClassReflectors(GenericReflector reflector) {
        this.ICLASS_COMPARE = reflector.forClass(Const4.CLASS_COMPARE);
        this.ICLASS_DB4OTYPE = reflector.forClass(Const4.CLASS_DB4OTYPE);
        this.ICLASS_DB4OTYPEIMPL = reflector.forClass(Const4.CLASS_DB4OTYPEIMPL);
        this.ICLASS_INTERNAL = reflector.forClass(Const4.CLASS_INTERNAL);
        this.ICLASS_UNVERSIONED = reflector.forClass(Const4.CLASS_UNVERSIONED);
        this.ICLASS_OBJECT = reflector.forClass(Const4.CLASS_OBJECT);
        this.ICLASS_OBJECTCONTAINER = reflector.forClass(Const4.CLASS_OBJECTCONTAINER);
        this.ICLASS_STATICCLASS = reflector.forClass(Const4.CLASS_STATICCLASS);
        this.ICLASS_STRING = reflector.forClass(String.class);
        this.ICLASS_TRANSIENTCLASS = reflector.forClass(Const4.CLASS_TRANSIENTCLASS);
        Platform4.registerCollections(reflector);
    }

    void initEncryption(Config4Impl a_config) {
        if (a_config.encrypt() && a_config.password() != null && a_config.password().length() > 0) {
            this.i_encrypt = true;
            this.i_encryptor = new byte[a_config.password().length()];
            for (int i = 0; i < this.i_encryptor.length; ++i) {
                this.i_encryptor[i] = (byte)(a_config.password().charAt(i) & 0xFF);
            }
            this.i_lastEncryptorByte = a_config.password().length() - 1;
            return;
        }
        this.oldEncryptionOff();
    }

    static Db4oTypeImpl getDb4oType(ReflectClass clazz) {
        for (int i = 0; i < _db4oTypes.length; ++i) {
            if (!clazz.isInstance(_db4oTypes[i])) continue;
            return _db4oTypes[i];
        }
        return null;
    }

    public ClassMetadata classMetadataForId(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.classMetadata;
    }

    public FieldHandler fieldHandlerForId(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.fieldHandler;
    }

    public FieldHandler fieldHandlerForClass(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isInterface()) {
            return this.untypedFieldHandler();
        }
        if (clazz.isArray()) {
            if (this.reflector().array().isNDimensional(clazz)) {
                return this._untypedMultiDimensionalArrayHandler;
            }
            return this._untypedArrayHandler;
        }
        FieldHandler fieldHandler = (FieldHandler)this._mapReflectorToFieldHandler.get(clazz);
        if (fieldHandler != null) {
            return fieldHandler;
        }
        TypeHandler4 configuredHandler = this.container().configImpl().typeHandlerForClass(clazz, (byte)4);
        if (configuredHandler != null && SlotFormat.isEmbedded(configuredHandler)) {
            this.mapFieldHandler(clazz, configuredHandler);
            return configuredHandler;
        }
        return null;
    }

    ClassMetadata classMetadataForClass(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return (ClassMetadata)this.untypedArrayHandler(clazz);
        }
        return (ClassMetadata)this._mapReflectorToClassMetadata.get(clazz);
    }

    public FieldHandler untypedFieldHandler() {
        return this._untypedFieldHandler;
    }

    public TypeHandler4 untypedObjectHandler() {
        return (TypeHandler4)this.untypedFieldHandler();
    }

    public TypeHandler4 untypedArrayHandler(ReflectClass clazz) {
        if (clazz.isArray()) {
            if (this.reflector().array().isNDimensional(clazz)) {
                return this._untypedMultiDimensionalArrayHandler;
            }
            return this._untypedArrayHandler;
        }
        return null;
    }

    public TypeHandler4 typeHandlerForClass(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        return (TypeHandler4)this._mapReflectorToTypeHandler.get(clazz);
    }

    public ReflectClass classReflectorForHandler(TypeHandler4 handler) {
        return (ReflectClass)this._mapFieldHandlerToReflector.get(handler);
    }

    public boolean isSecondClass(Object a_object) {
        if (a_object != null) {
            ReflectClass claxx = this.reflector().forObject(a_object);
            if (this._mapReflectorToFieldHandler.get(claxx) != null) {
                return true;
            }
            return Platform4.isValueType(claxx);
        }
        return false;
    }

    public boolean isSystemHandler(int id) {
        return id <= this._highestBuiltinTypeID;
    }

    public VirtualFieldMetadata virtualFieldByName(String name) {
        for (int i = 0; i < this._virtualFields.length; ++i) {
            if (!name.equals(this._virtualFields[i].getName())) continue;
            return this._virtualFields[i];
        }
        return null;
    }

    public boolean isVariableLength(TypeHandler4 handler) {
        return handler instanceof VariableLengthTypeHandler;
    }

    public SharedIndexedFields indexes() {
        return this._indexes;
    }

    public LatinStringIO stringIO() {
        return this._stringIO;
    }

    public void stringIO(LatinStringIO io) {
        this._stringIO = io;
    }

    private GenericReflector reflector() {
        return this.container().reflector();
    }

    private ObjectContainerBase container() {
        return this._container;
    }

    private static final Hashtable4 newHashtable() {
        return new Hashtable4(32);
    }

    public int fieldHandlerIdForFieldHandler(FieldHandler fieldHandler) {
        Object wrappedIdObj = this._mapFieldHandlerToId.get(fieldHandler);
        if (wrappedIdObj != null) {
            Integer wrappedId = (Integer)wrappedIdObj;
            return wrappedId;
        }
        return 0;
    }

    public TypeHandler4 configuredTypeHandler(ReflectClass claxx) {
        TypeHandler4 typeHandler = this.container().configImpl().typeHandlerForClass(claxx, (byte)4);
        if (typeHandler != null && typeHandler instanceof EmbeddedTypeHandler) {
            this._mapReflectorToTypeHandler.put(claxx, (Object)typeHandler);
        }
        return typeHandler;
    }
}

