/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.DatabaseMaximumSizeReachedException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.OldFormatException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Const4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.IDHandler;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.SystemInfoFileImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.Converter;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.HybridQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.ReferencedSlot;
import com.db4o.internal.slots.Slot;

public abstract class LocalObjectContainer
extends ExternalObjectContainer
implements InternalObjectContainer {
    private static final int DEFAULT_FREESPACE_ID = 0;
    protected FileHeader _fileHeader;
    private Collection4 i_dirty;
    private FreespaceManager _freespaceManager;
    private boolean i_isServer = false;
    private Tree i_prefetchedIDs;
    private Hashtable4 i_semaphores;
    private int _blockEndAddress;
    private Tree _freeOnCommit;
    private SystemData _systemData;

    LocalObjectContainer(Configuration config, ObjectContainerBase parentContainer) {
        super(config, parentContainer);
    }

    public Transaction newTransaction(Transaction parentTransaction, TransactionalReferenceSystem referenceSystem) {
        return new LocalTransaction(this, parentTransaction, referenceSystem);
    }

    public FreespaceManager freespaceManager() {
        return this._freespaceManager;
    }

    public abstract void blockSize(int var1);

    public void blockSizeReadFromFile(int size) {
        this.blockSize(size);
        this.setRegularEndAddress(this.fileLength());
    }

    public void setRegularEndAddress(long address) {
        this._blockEndAddress = this.bytesToBlocks(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void close2() {
        try {
            if (!this._config.isReadOnly()) {
                this.freeInternalResources();
                this.commitTransaction();
                this.shutdown();
            }
        }
        finally {
            this.shutdownObjectContainer();
        }
    }

    protected abstract void freeInternalResources();

    public void commit1(Transaction trans) {
        trans.commit();
    }

    void configureNewFile() {
        this.newSystemData(this.configImpl().freespaceSystem());
        this.systemData().converterVersion(7);
        this.createStringIO(this._systemData.stringEncoding());
        this.generateNewIdentity();
        this._freespaceManager = AbstractFreespaceManager.createNew(this);
        this.blockSize(this.configImpl().blockSize());
        this._fileHeader = new FileHeader1();
        this.setRegularEndAddress(this._fileHeader.length());
        this.initNewClassCollection();
        this.initializeEssentialClasses();
        this._fileHeader.initNew(this);
        this._freespaceManager.start(this._systemData.freespaceAddress());
    }

    private void newSystemData(byte freespaceSystem) {
        this._systemData = new SystemData();
        this._systemData.stringEncoding(this.configImpl().encoding());
        this._systemData.freespaceSystem(freespaceSystem);
    }

    public int converterVersion() {
        return this._systemData.converterVersion();
    }

    public abstract void copy(int var1, int var2, int var3, int var4, int var5);

    public long currentVersion() {
        return this._timeStampIdGenerator.lastTimeStampId();
    }

    void initNewClassCollection() {
        this.classCollection().initTables(1);
    }

    public final BTree createBTreeClassIndex(int id) {
        return new BTree(this._transaction, id, new IDHandler());
    }

    public final AbstractQueryResult newQueryResult(Transaction trans) {
        return this.newQueryResult(trans, this.config().queryEvaluationMode());
    }

    public final AbstractQueryResult newQueryResult(Transaction trans, QueryEvaluationMode mode) {
        if (mode == QueryEvaluationMode.IMMEDIATE) {
            return new IdListQueryResult(trans);
        }
        return new HybridQueryResult(trans, mode);
    }

    public final boolean delete4(Transaction ta, ObjectReference yo, int a_cascade, boolean userCall) {
        int id = yo.getID();
        StatefulBuffer reader = this.readWriterByID(ta, id);
        if (reader != null) {
            Object obj = yo.getObject();
            if (obj != null && !this.showInternalClasses() && Const4.CLASS_INTERNAL.isAssignableFrom(obj.getClass())) {
                return false;
            }
            reader.setCascadeDeletes(a_cascade);
            reader.slotDelete();
            ClassMetadata yc = yo.classMetadata();
            yc.delete(reader, obj);
            return true;
        }
        return false;
    }

    public abstract long fileLength();

    public abstract String fileName();

    public void free(Slot slot) {
        if (slot.address() == 0) {
            return;
        }
        if (this._freespaceManager == null) {
            return;
        }
        Slot blockedSlot = this.toBlockedLength(slot);
        if (DTrace.enabled) {
            DTrace.FILE_FREE.logLength(blockedSlot.address(), blockedSlot.length());
        }
        this._freespaceManager.free(blockedSlot);
    }

    public Slot toBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.bytesToBlocks(slot.length()));
    }

    public Slot toNonBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.blocksToBytes(slot.length()));
    }

    public void free(int address, int a_length) {
        this.free(new Slot(address, a_length));
    }

    final void freePrefetchedPointers() {
        if (this.i_prefetchedIDs != null) {
            this.i_prefetchedIDs.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    LocalObjectContainer.this.free(((TreeInt)a_object)._key, 8);
                }
            });
        }
        this.i_prefetchedIDs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateNewIdentity() {
        Object object = this._lock;
        synchronized (object) {
            this.setIdentity(Db4oDatabase.generate());
        }
    }

    public AbstractQueryResult queryAllObjects(Transaction trans) {
        return this.getAll(trans, this.config().queryEvaluationMode());
    }

    public AbstractQueryResult getAll(Transaction trans, QueryEvaluationMode mode) {
        AbstractQueryResult queryResult = this.newQueryResult(trans, mode);
        queryResult.loadFromClassIndexes(this.classCollection().iterator());
        return queryResult;
    }

    public final int getPointerSlot() {
        int id = this.getSlot(8).address();
        ((LocalTransaction)this.systemTransaction()).writeZeroPointer(id);
        if (this._handlers.isSystemHandler(id)) {
            return this.getPointerSlot();
        }
        if (DTrace.enabled) {
            DTrace.GET_POINTER_SLOT.log(id);
        }
        return id;
    }

    public Slot getSlot(int length) {
        int blocks = this.bytesToBlocks(length);
        Slot slot = this.getBlockedSlot(blocks);
        if (DTrace.enabled) {
            DTrace.GET_SLOT.logLength(slot.address(), slot.length());
        }
        return this.toNonBlockedLength(slot);
    }

    private final Slot getBlockedSlot(int blocks) {
        if (blocks <= 0) {
            throw new IllegalArgumentException();
        }
        if (this._freespaceManager != null) {
            Slot slot = this._freespaceManager.getSlot(blocks);
            if (slot != null) {
                return slot;
            }
            while (this.growDatabaseByConfiguredSize()) {
                slot = this._freespaceManager.getSlot(blocks);
                if (slot == null) continue;
                return slot;
            }
        }
        return this.appendBlocks(blocks);
    }

    private boolean growDatabaseByConfiguredSize() {
        int reservedStorageSpace = this.configImpl().databaseGrowthSize();
        if (reservedStorageSpace <= 0) {
            return false;
        }
        int reservedBlocks = this.bytesToBlocks(reservedStorageSpace);
        int reservedBytes = this.blocksToBytes(reservedBlocks);
        Slot slot = new Slot(this._blockEndAddress, reservedBlocks);
        this.writeBytes(new ByteArrayBuffer(reservedBytes), this._blockEndAddress, 0);
        this._freespaceManager.free(slot);
        this._blockEndAddress += reservedBlocks;
        return true;
    }

    protected final Slot appendBlocks(int blockCount) {
        int blockedStartAddress = this._blockEndAddress;
        int blockedEndAddress = this._blockEndAddress + blockCount;
        this.checkBlockedAddress(blockedEndAddress);
        this._blockEndAddress = blockedEndAddress;
        Slot slot = new Slot(blockedStartAddress, blockCount);
        return slot;
    }

    final Slot appendBytes(long bytes) {
        Slot slot = this.appendBlocks(this.bytesToBlocks(bytes));
        return this.toNonBlockedLength(slot);
    }

    private void checkBlockedAddress(int blockedAddress) {
        if (blockedAddress < 0) {
            this.switchToReadOnlyMode();
            throw new DatabaseMaximumSizeReachedException();
        }
    }

    private void switchToReadOnlyMode() {
        this._config.readOnly(true);
    }

    void ensureLastSlotWritten() {
        if (this._blockEndAddress > this.bytesToBlocks(this.fileLength())) {
            StatefulBuffer writer = this.getWriter(this.systemTransaction(), this._blockEndAddress - 1, this.blockSize());
            writer.write();
        }
    }

    public Db4oDatabase identity() {
        return this._systemData.identity();
    }

    public void setIdentity(Db4oDatabase identity) {
        this._systemData.identity(identity);
        this._timeStampIdGenerator.next();
    }

    void initialize2() {
        this.i_dirty = new Collection4();
        super.initialize2();
    }

    boolean isServer() {
        return this.i_isServer;
    }

    public final Pointer4 newSlot(int length) {
        return new Pointer4(this.getPointerSlot(), this.getSlot(length));
    }

    public final int newUserObject() {
        return this.getPointerSlot();
    }

    public void prefetchedIDConsumed(int a_id) {
        this.i_prefetchedIDs = this.i_prefetchedIDs.removeLike(new TreeIntObject(a_id));
    }

    public int prefetchID() {
        int id = this.getPointerSlot();
        this.i_prefetchedIDs = Tree.add(this.i_prefetchedIDs, new TreeInt(id));
        return id;
    }

    public ReferencedSlot produceFreeOnCommitEntry(int id) {
        TreeInt node = TreeInt.find(this._freeOnCommit, id);
        if (node != null) {
            return (ReferencedSlot)node;
        }
        ReferencedSlot slot = new ReferencedSlot(id);
        this._freeOnCommit = Tree.add(this._freeOnCommit, slot);
        return slot;
    }

    public void reduceFreeOnCommitReferences(ReferencedSlot slot) {
        if (slot.removeReferenceIsLast()) {
            this._freeOnCommit = this._freeOnCommit.removeNode(slot);
        }
    }

    public void freeDuringCommit(ReferencedSlot referencedSlot, Slot slot) {
        this._freeOnCommit = referencedSlot.free(this, this._freeOnCommit, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseVersion(long a_minimumVersion) {
        Object object = this.lock();
        synchronized (object) {
            this._timeStampIdGenerator.setMinimumNext(a_minimumVersion);
        }
    }

    public StatefulBuffer readWriterByID(Transaction a_ta, int a_id, boolean lastCommitted) {
        return (StatefulBuffer)this.readReaderOrWriterByID(a_ta, a_id, false, lastCommitted);
    }

    public StatefulBuffer readWriterByID(Transaction a_ta, int a_id) {
        return this.readWriterByID(a_ta, a_id, false);
    }

    public StatefulBuffer[] readWritersByIDs(Transaction a_ta, int[] ids) {
        StatefulBuffer[] yapWriters = new StatefulBuffer[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            yapWriters[i] = ids[i] == 0 ? null : (StatefulBuffer)this.readReaderOrWriterByID(a_ta, ids[i], false);
        }
        return yapWriters;
    }

    public ByteArrayBuffer readReaderByID(Transaction a_ta, int a_id, boolean lastCommitted) {
        return this.readReaderOrWriterByID(a_ta, a_id, true, lastCommitted);
    }

    public ByteArrayBuffer readReaderByID(Transaction trans, int id) {
        return this.readReaderByID(trans, id, false);
    }

    private final ByteArrayBuffer readReaderOrWriterByID(Transaction a_ta, int a_id, boolean useReader) {
        return this.readReaderOrWriterByID(a_ta, a_id, useReader, false);
    }

    private final ByteArrayBuffer readReaderOrWriterByID(Transaction a_ta, int a_id, boolean useReader, boolean lastCommitted) {
        if (a_id <= 0) {
            throw new IllegalArgumentException();
        }
        if (DTrace.enabled) {
            DTrace.READ_ID.log(a_id);
        }
        Slot slot = null;
        slot = !lastCommitted ? ((LocalTransaction)a_ta).getCurrentSlotOfID(a_id) : ((LocalTransaction)a_ta).getCommittedSlotOfID(a_id);
        if (slot == null) {
            return null;
        }
        if (slot.address() == 0) {
            return null;
        }
        if (DTrace.enabled) {
            DTrace.READ_SLOT.logLength(slot.address(), slot.length());
        }
        ByteArrayBuffer reader = null;
        if (useReader) {
            reader = new ByteArrayBuffer(slot.length());
        } else {
            reader = this.getWriter(a_ta, slot.address(), slot.length());
            ((StatefulBuffer)reader).setID(a_id);
        }
        reader.readEncrypt(this, slot.address());
        return reader;
    }

    protected boolean doFinalize() {
        return this._fileHeader != null;
    }

    void readThis() throws OldFormatException {
        this.newSystemData((byte)1);
        this.blockSizeReadFromFile(1);
        this._fileHeader = FileHeader.readFixedPart(this);
        this.createStringIO(this._systemData.stringEncoding());
        this.classCollection().setID(this._systemData.classCollectionID());
        this.classCollection().read(this.systemTransaction());
        Converter.convert(new ConversionStage.ClassCollectionAvailableStage(this));
        this.readHeaderVariablePart();
        if (!this._config.isReadOnly()) {
            this._freespaceManager = AbstractFreespaceManager.createNew(this, this._systemData.freespaceSystem());
            this._freespaceManager.read(this._systemData.freespaceID());
            this._freespaceManager.start(this._systemData.freespaceAddress());
        }
        if (this.freespaceMigrationRequired()) {
            this.migrateFreespace();
        }
        if (this._config.isReadOnly()) {
            return;
        }
        this.writeHeader(true, false);
        LocalTransaction trans = (LocalTransaction)this._fileHeader.interruptedTransaction();
        if (trans != null && !this.configImpl().commitRecoveryDisabled()) {
            trans.writeOld();
        }
        if (Converter.convert(new ConversionStage.SystemUpStage(this))) {
            this._systemData.converterVersion(7);
            this._fileHeader.writeVariablePart(this, 1);
            this.transaction().commit();
        }
    }

    private boolean freespaceMigrationRequired() {
        if (this._freespaceManager == null) {
            return false;
        }
        byte readSystem = this._systemData.freespaceSystem();
        byte configuredSystem = this.configImpl().freespaceSystem();
        if (this._freespaceManager.systemType() == configuredSystem) {
            return false;
        }
        if (configuredSystem != 0) {
            return true;
        }
        return AbstractFreespaceManager.migrationRequired(readSystem);
    }

    private void migrateFreespace() {
        FreespaceManager oldFreespaceManager = this._freespaceManager;
        AbstractFreespaceManager newFreespaceManager = AbstractFreespaceManager.createNew(this, this.configImpl().freespaceSystem());
        newFreespaceManager.start(0);
        this.systemData().freespaceSystem(this.configImpl().freespaceSystem());
        this._freespaceManager = newFreespaceManager;
        AbstractFreespaceManager.migrate(oldFreespaceManager, this._freespaceManager);
        this._fileHeader.writeVariablePart(this, 1);
    }

    private void readHeaderVariablePart() {
        this._fileHeader.readVariablePart(this);
        this.setNextTimeStampId(this.systemData().lastTimeStampID());
    }

    public final int createFreespaceSlot(byte freespaceSystem) {
        this._systemData.freespaceAddress(AbstractFreespaceManager.initSlot(this));
        this._systemData.freespaceSystem(freespaceSystem);
        return this._systemData.freespaceAddress();
    }

    public int ensureFreespaceSlot() {
        int address = this.systemData().freespaceAddress();
        if (address == 0) {
            return this.createFreespaceSlot(this.systemData().freespaceSystem());
        }
        return address;
    }

    public final void releaseSemaphore(String name) {
        this.releaseSemaphore(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSemaphore(Transaction trans, String name) {
        Object object = this._lock;
        synchronized (object) {
            if (this.i_semaphores == null) {
                return;
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            if (this.i_semaphores != null && trans == this.i_semaphores.get(name)) {
                this.i_semaphores.remove(name);
                this.i_semaphores.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphores(Transaction ta) {
        if (this.i_semaphores != null) {
            Hashtable4 semaphores;
            Hashtable4 hashtable4 = semaphores = this.i_semaphores;
            synchronized (hashtable4) {
                semaphores.forEachKeyForIdentity(new Visitor4(){

                    public void visit(Object a_object) {
                        semaphores.remove(a_object);
                    }
                }, ta);
                semaphores.notifyAll();
            }
        }
    }

    public final void rollback1(Transaction trans) {
        trans.rollback();
    }

    public final void setDirtyInSystemTransaction(PersistentBase a_object) {
        a_object.setStateDirty();
        a_object.cacheDirty(this.i_dirty);
    }

    public final boolean setSemaphore(String name, int timeout) {
        return this.setSemaphore(null, name, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setSemaphore(Transaction trans, String name, int timeout) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.i_semaphores == null) {
                this.i_semaphores = new Hashtable4(10);
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            trans = this.checkTransaction(trans);
            Object obj = this.i_semaphores.get(name);
            if (obj == null) {
                this.i_semaphores.put(name, (Object)trans);
                return true;
            }
            if (trans == obj) {
                return true;
            }
            long endtime = System.currentTimeMillis() + (long)timeout;
            long waitTime = timeout;
            while (waitTime > 0L) {
                try {
                    this.i_semaphores.wait(waitTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.classCollection() == null) {
                    return false;
                }
                obj = this.i_semaphores.get(name);
                if (obj == null) {
                    this.i_semaphores.put(name, (Object)trans);
                    return true;
                }
                waitTime = endtime - System.currentTimeMillis();
            }
            return false;
        }
    }

    public void setServer(boolean flag) {
        this.i_isServer = flag;
    }

    public abstract void syncFiles();

    public String toString() {
        return this.fileName();
    }

    public void shutdown() {
        this.writeHeader(false, true);
    }

    public final void commitTransaction() {
        this._transaction.commit();
    }

    public abstract void writeBytes(ByteArrayBuffer var1, int var2, int var3);

    public final void writeDirty() {
        this.writeCachedDirty();
        this.writeVariableHeader();
    }

    private void writeCachedDirty() {
        Iterator4 i = this.i_dirty.iterator();
        while (i.moveNext()) {
            PersistentBase dirty = (PersistentBase)i.current();
            dirty.write(this.systemTransaction());
            dirty.notCachedDirty();
        }
        this.i_dirty.clear();
    }

    public final void writeEncrypt(ByteArrayBuffer buffer, int address, int addressOffset) {
        this._handlers.encrypt(buffer);
        this.writeBytes(buffer, address, addressOffset);
        this._handlers.decrypt(buffer);
    }

    protected void writeVariableHeader() {
        if (!this._timeStampIdGenerator.isDirty()) {
            return;
        }
        this._systemData.lastTimeStampID(this._timeStampIdGenerator.lastTimeStampId());
        this._fileHeader.writeVariablePart(this, 2);
        this._timeStampIdGenerator.setClean();
    }

    void writeHeader(boolean startFileLockingThread, boolean shuttingDown) {
        int freespaceID = 0;
        if (shuttingDown) {
            freespaceID = this._freespaceManager.write();
            this._freespaceManager = null;
        }
        StatefulBuffer writer = this.getWriter(this.systemTransaction(), 0, this._fileHeader.length());
        this._fileHeader.writeFixedPart(this, startFileLockingThread, shuttingDown, writer, this.blockSize(), freespaceID);
        if (shuttingDown) {
            this.ensureLastSlotWritten();
        }
        this.syncFiles();
    }

    public final void writeNew(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        this.writeEncrypt(buffer, pointer.address(), 0);
        if (classMetadata == null) {
            return;
        }
        classMetadata.addToIndex(trans, pointer.id());
    }

    public abstract void overwriteDeletedBytes(int var1, int var2);

    public void overwriteDeletedBlockedSlot(Slot slot) {
        this.overwriteDeletedBytes(slot.address(), this.blocksToBytes(slot.length()));
    }

    public final void writeTransactionPointer(int address) {
        this._fileHeader.writeTransactionPointer(this.systemTransaction(), address);
    }

    public final void getSlotForUpdate(StatefulBuffer buffer) {
        Slot slot = this.getSlotForUpdate(buffer.transaction(), buffer.getID(), buffer.length());
        buffer.address(slot.address());
    }

    public final Slot getSlotForUpdate(Transaction trans, int id, int length) {
        Slot slot = this.getSlot(length);
        trans.produceUpdateSlotChange(id, slot);
        return slot;
    }

    public final void writeUpdate(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        int address = pointer.address();
        if (address == 0) {
            address = this.getSlotForUpdate(trans, pointer.id(), pointer.length()).address();
        }
        this.writeEncrypt(buffer, address, 0);
    }

    public void setNextTimeStampId(long val) {
        this._timeStampIdGenerator.setMinimumNext(val);
        this._timeStampIdGenerator.setClean();
    }

    public SystemInfo systemInfo() {
        return new SystemInfoFileImpl(this);
    }

    public FileHeader getFileHeader() {
        return this._fileHeader;
    }

    public void installDebugFreespaceManager(AbstractFreespaceManager manager) {
        this._freespaceManager = manager;
    }

    public SystemData systemData() {
        return this._systemData;
    }

    public long[] getIDsForClass(Transaction trans, ClassMetadata clazz) {
        final IntArrayList ids = new IntArrayList();
        clazz.index().traverseAll(trans, new Visitor4(){

            public void visit(Object obj) {
                ids.add((Integer)obj);
            }
        });
        return ids.asLong();
    }

    public QueryResult classOnlyQuery(Transaction trans, ClassMetadata clazz) {
        if (!clazz.hasClassIndex()) {
            return null;
        }
        AbstractQueryResult queryResult = this.newQueryResult(trans);
        queryResult.loadFromClassIndex(clazz);
        return queryResult;
    }

    public QueryResult executeQuery(QQuery query) {
        AbstractQueryResult queryResult = this.newQueryResult(query.getTransaction());
        queryResult.loadFromQuery(query);
        return queryResult;
    }

    public LocalTransaction getLocalSystemTransaction() {
        return (LocalTransaction)this.systemTransaction();
    }

    public void onCommittedListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceCount(ClassMetadata clazz, Transaction trans) {
        Object object = this.lock();
        synchronized (object) {
            return clazz.indexEntryCount(trans);
        }
    }
}

