/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.config;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.ClientServerFactory;
import com.db4o.config.Configuration;
import com.db4o.config.NativeSocketFactory;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.network.NetworkSocket;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.ObjectServerImpl;

public class ClientServerFactoryImpl
implements ClientServerFactory {
    public ObjectContainer openClient(Configuration config, String hostName, int port, String user, String password, NativeSocketFactory socketFactory) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        if (user == null || password == null) {
            throw new InvalidPasswordException();
        }
        NetworkSocket networkSocket = new NetworkSocket(socketFactory, hostName, port);
        return new ClientObjectContainer(config, networkSocket, user, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectServer openServer(Configuration config, String databaseFileName, int port, NativeSocketFactory socketFactory) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        LocalObjectContainer container = (LocalObjectContainer)Db4o.openFile(config, databaseFileName);
        if (container == null) {
            return null;
        }
        Object object = container.lock();
        synchronized (object) {
            return new ObjectServerImpl(container, port, socketFactory);
        }
    }
}

