/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.encoding;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.encoding.LatinStringEncoding;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.WriteBuffer;

public class LatinStringIO {
    public byte[] bytes(ByteArrayBuffer buffer) {
        int len = buffer.readInt();
        len = this.bytesPerChar() * len;
        byte[] res = new byte[len];
        System.arraycopy(buffer._buffer, buffer._offset, res, 0, len);
        return res;
    }

    protected int bytesPerChar() {
        return 1;
    }

    public byte encodingByte() {
        return BuiltInStringEncoding.encodingByteForEncoding(new LatinStringEncoding());
    }

    public int length(String str) {
        return str.length() + 0 + 4;
    }

    public String read(ReadBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int ii = 0; ii < length; ++ii) {
            chars[ii] = (char)(buffer.readByte() & 0xFF);
        }
        return new String(chars, 0, length);
    }

    public String read(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return new String(chars, 0, bytes.length);
    }

    public String readLengthAndString(ReadBuffer buffer) {
        int length = buffer.readInt();
        if (length == 0) {
            return "";
        }
        return this.read(buffer, length);
    }

    public int shortLength(String str) {
        return str.length() + 4;
    }

    public void write(WriteBuffer buffer, String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        for (int i = 0; i < length; ++i) {
            buffer.writeByte((byte)(chars[i] & 0xFF));
        }
    }

    public byte[] write(String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    public void writeLengthAndString(WriteBuffer buffer, String str) {
        if (str == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(str.length());
        this.write(buffer, str);
    }
}

