/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.events;

import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventException;
import com.db4o.events.EventListener4;
import com.db4o.ext.Db4oException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;

public class Event4Impl
implements Event4 {
    private Collection4 _listeners;

    public final void addListener(EventListener4 listener) {
        this.validateListener(listener);
        Collection4 listeners = new Collection4();
        listeners.add(listener);
        this.addExistingListenersTo(listeners);
        this._listeners = listeners;
        this.onListenerAdded();
    }

    private void addExistingListenersTo(Collection4 newListeners) {
        if (this._listeners == null) {
            return;
        }
        Iterator4 i = this._listeners.iterator();
        while (i.moveNext()) {
            newListeners.add(i.current());
        }
    }

    protected void onListenerAdded() {
    }

    public final void removeListener(EventListener4 listener) {
        this.validateListener(listener);
        if (null == this._listeners) {
            return;
        }
        Collection4 listeners = new Collection4();
        this.addExistingListenersTo(listeners);
        listeners.remove(listener);
        this._listeners = listeners;
    }

    public final void trigger(EventArgs args) {
        if (null == this._listeners) {
            return;
        }
        Iterator4 iterator = this._listeners.iterator();
        while (iterator.moveNext()) {
            EventListener4 listener = (EventListener4)iterator.current();
            this.onEvent(listener, this, args);
        }
    }

    private void onEvent(EventListener4 listener, Event4 e, EventArgs args) {
        try {
            listener.onEvent(e, args);
        }
        catch (Db4oException db4oException) {
            throw db4oException;
        }
        catch (Throwable exc) {
            throw new EventException(exc);
        }
    }

    private void validateListener(EventListener4 listener) {
        if (null == listener) {
            throw new ArgumentNullException();
        }
    }

    public boolean hasListeners() {
        return this._listeners != null;
    }
}

