/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;

public class DoubleHandler
extends LongHandler {
    private static final Double DEFAULTVALUE = new Double(0.0);

    public Object coerce(Reflector reflector, ReflectClass claxx, Object obj) {
        return Coercion4.toDouble(obj);
    }

    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    public Class primitiveJavaClass() {
        return Double.TYPE;
    }

    public Object read(MarshallerFamily mf, StatefulBuffer buffer, boolean redirect) throws CorruptionException {
        return mf._primitive.readDouble(buffer);
    }

    Object read1(ByteArrayBuffer buffer) {
        return this.primitiveMarshaller().readDouble(buffer);
    }

    public void write(Object a_object, ByteArrayBuffer a_bytes) {
        a_bytes.writeLong(Platform4.doubleToLong((Double)a_object));
    }

    public Object read(ReadContext context) {
        Long l = (Long)super.read(context);
        return new Double(Platform4.longToDouble(l));
    }

    public void write(WriteContext context, Object obj) {
        context.writeLong(Platform4.doubleToLong((Double)obj));
    }

    public PreparedComparison internalPrepareComparison(Object source) {
        final double sourceDouble = (Double)source;
        return new PreparedComparison(){

            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                double targetDouble = (Double)target;
                return sourceDouble == targetDouble ? 0 : (sourceDouble < targetDouble ? -1 : 1);
            }
        };
    }
}

