/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.typehandlers.EmbeddedTypeHandler;

public class StringHandler
implements IndexableTypeHandler,
BuiltinTypeHandler,
VariableLengthTypeHandler,
EmbeddedTypeHandler {
    private ReflectClass _classReflector;

    public ReflectClass classReflector() {
        return this._classReflector;
    }

    public void delete(DeleteContext context) {
    }

    byte getIdentifier() {
        return 83;
    }

    public final Object indexEntryToObject(Context context, Object indexEntry) {
        if (indexEntry instanceof Slot) {
            Slot slot = (Slot)indexEntry;
            indexEntry = context.transaction().container().bufferByAddress(slot.address(), slot.length());
        }
        return StringHandler.readStringNoDebug(context, (ReadBuffer)indexEntry);
    }

    public Object readIndexEntryFromObjectSlot(MarshallerFamily mf, StatefulBuffer buffer) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = buffer.readInt();
        int length = buffer.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return buffer.readPayloadWriter(payLoadOffSet, length);
    }

    public Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = context.readInt();
        int length = context.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return ((StatefulBuffer)context.buffer()).readPayloadWriter(payLoadOffSet, length);
    }

    public Object readIndexEntry(ByteArrayBuffer reader) {
        Slot s = new Slot(reader.readInt(), reader.readInt());
        if (this.isInvalidSlot(s)) {
            return null;
        }
        return s;
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot.address() == 0 && slot.length() == 0;
    }

    public void writeIndexEntry(ByteArrayBuffer writer, Object entry) {
        if (entry == null) {
            writer.writeInt(0);
            writer.writeInt(0);
            return;
        }
        if (entry instanceof StatefulBuffer) {
            StatefulBuffer entryAsWriter = (StatefulBuffer)entry;
            writer.writeInt(entryAsWriter.getAddress());
            writer.writeInt(entryAsWriter.length());
            return;
        }
        if (entry instanceof Slot) {
            Slot s = (Slot)entry;
            writer.writeInt(s.address());
            writer.writeInt(s.length());
            return;
        }
        throw new IllegalArgumentException();
    }

    public final void writeShort(Transaction trans, String str, ByteArrayBuffer buffer) {
        trans.container().handlers().stringIO().writeLengthAndString(buffer, str);
    }

    ByteArrayBuffer val(Object obj, Context context) {
        if (obj instanceof ByteArrayBuffer) {
            return (ByteArrayBuffer)obj;
        }
        ObjectContainerBase oc = context.transaction().container();
        if (obj instanceof String) {
            return StringHandler.writeToBuffer(oc, (String)obj);
        }
        if (obj instanceof Slot) {
            Slot s = (Slot)obj;
            return oc.bufferByAddress(s.address(), s.length());
        }
        return null;
    }

    final int compare(ByteArrayBuffer a_compare, ByteArrayBuffer a_with) {
        if (a_compare == null) {
            if (a_with == null) {
                return 0;
            }
            return 1;
        }
        if (a_with == null) {
            return -1;
        }
        return StringHandler.compare(a_compare._buffer, a_with._buffer);
    }

    public static final int compare(byte[] compare, byte[] with) {
        int start;
        int min = compare.length < with.length ? compare.length : with.length;
        for (int i = start = 4; i < min; ++i) {
            if (compare[i] == with[i]) continue;
            return with[i] - compare[i];
        }
        return with.length - compare.length;
    }

    public void defragIndexEntry(DefragmentContextImpl context) {
        context.copyID(false, true);
        context.incrementIntSize();
    }

    public void write(WriteContext context, Object obj) {
        StringHandler.internalWrite((InternalObjectContainer)context.objectContainer(), context, (String)obj);
    }

    protected static void internalWrite(InternalObjectContainer objectContainer, WriteBuffer buffer, String str) {
        StringHandler.stringIo(objectContainer).writeLengthAndString(buffer, str);
    }

    public static ByteArrayBuffer writeToBuffer(InternalObjectContainer container, String str) {
        ByteArrayBuffer buffer = new ByteArrayBuffer(StringHandler.stringIo(container).length(str));
        StringHandler.internalWrite(container, buffer, str);
        return buffer;
    }

    protected static LatinStringIO stringIo(Context context) {
        return StringHandler.stringIo((InternalObjectContainer)context.objectContainer());
    }

    protected static LatinStringIO stringIo(InternalObjectContainer objectContainer) {
        return objectContainer.container().stringIO();
    }

    public static String readString(Context context, ReadBuffer buffer) {
        String str = StringHandler.readStringNoDebug(context, buffer);
        return str;
    }

    public static String readStringNoDebug(Context context, ReadBuffer buffer) {
        return StringHandler.intern(context, StringHandler.stringIo(context).readLengthAndString(buffer));
    }

    protected static String intern(Context context, String str) {
        if (context.objectContainer().ext().configure().internStrings()) {
            return str.intern();
        }
        return str;
    }

    public Object read(ReadContext context) {
        return StringHandler.readString(context, context);
    }

    public void defragment(DefragmentContext context) {
        context.incrementOffset(this.linkLength());
    }

    public PreparedComparison prepareComparison(final Context context, Object obj) {
        final ByteArrayBuffer sourceBuffer = this.val(obj, context);
        return new PreparedComparison(){

            public int compareTo(Object target) {
                ByteArrayBuffer targetBuffer = StringHandler.this.val(target, context);
                return -StringHandler.this.compare(sourceBuffer, targetBuffer);
            }
        };
    }

    public int linkLength() {
        return 8;
    }

    public void registerReflector(Reflector reflector) {
        this._classReflector = reflector.forClass(String.class);
    }
}

