/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.array;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.AbstractBufferContext;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.ArrayHandler2;
import com.db4o.internal.handlers.array.ArrayVersionHelper;
import com.db4o.internal.handlers.array.ArrayVersionHelper0;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import java.io.IOException;

public class ArrayHandler0
extends ArrayHandler2 {
    protected ArrayVersionHelper createVersionHelper() {
        return new ArrayVersionHelper0();
    }

    protected void withContent(AbstractBufferContext context, Runnable runnable) {
        int address = context.readInt();
        int length = context.readInt();
        if (address == 0) {
            return;
        }
        ReadBuffer temp = context.buffer();
        ByteArrayBuffer indirectedBuffer = this.container(context).bufferByAddress(address, length);
        context.buffer(indirectedBuffer);
        runnable.run();
        context.buffer(temp);
    }

    public void delete(DeleteContext context) throws Db4oIOException {
        context.readSlot();
        context.defragmentRecommended();
    }

    public Object read(ReadContext readContext) {
        InternalReadContext context = (InternalReadContext)readContext;
        ByteArrayBuffer buffer = (ByteArrayBuffer)context.readIndirectedBuffer();
        if (buffer == null) {
            return null;
        }
        ReadBuffer contextBuffer = context.buffer(buffer);
        Object array = super.read(context);
        context.buffer(contextBuffer);
        return array;
    }

    public static void defragment(DefragmentContext context, ArrayHandler handler) {
        int sourceAddress = context.sourceBuffer().readInt();
        int length = context.sourceBuffer().readInt();
        if (sourceAddress == 0 && length == 0) {
            context.targetBuffer().writeInt(0);
            context.targetBuffer().writeInt(0);
            return;
        }
        Slot slot = context.allocateMappedTargetSlot(sourceAddress, length);
        ByteArrayBuffer sourceBuffer = null;
        try {
            sourceBuffer = context.sourceBufferByAddress(sourceAddress, length);
        }
        catch (IOException exc) {
            throw new Db4oIOException(exc);
        }
        DefragmentContextImpl payloadContext = new DefragmentContextImpl(sourceBuffer, (DefragmentContextImpl)context);
        handler.defragmentSlot(payloadContext);
        payloadContext.writeToTarget(slot.address());
        context.targetBuffer().writeInt(slot.address());
        context.targetBuffer().writeInt(length);
    }

    public void defragment(DefragmentContext context) {
        ArrayHandler0.defragment(context, this);
    }
}

