/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.foundation.DeepClone;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericArrayClass;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericObject;
import com.db4o.reflect.generic.GenericReflector;

public class GenericClass
implements ReflectClass,
DeepClone {
    private static final GenericField[] NO_FIELDS = new GenericField[0];
    private final GenericReflector _reflector;
    private final ReflectClass _delegate;
    private final String _name;
    private GenericClass _superclass;
    private GenericClass _array;
    private boolean _isSecondClass;
    private boolean _isPrimitive;
    private int _isCollection;
    private GenericConverter _converter;
    private GenericField[] _fields = NO_FIELDS;
    private int _declaredFieldCount = -1;
    private int _fieldCount = -1;
    private final int _hashCode;

    public GenericClass(GenericReflector reflector, ReflectClass delegateClass, String name, GenericClass superclass) {
        this._reflector = reflector;
        this._delegate = delegateClass;
        this._name = name;
        this._superclass = superclass;
        this._hashCode = this._name.hashCode();
    }

    public GenericClass arrayClass() {
        if (this._array != null) {
            return this._array;
        }
        this._array = new GenericArrayClass(this._reflector, this, this._name, this._superclass);
        this._array._isSecondClass = this._isSecondClass;
        return this._array;
    }

    public Object deepClone(Object obj) {
        GenericReflector reflector = (GenericReflector)obj;
        GenericClass superClass = null;
        if (this._superclass != null) {
            this._superclass = (GenericClass)reflector.forName(this._superclass.getName());
        }
        GenericClass ret = new GenericClass(reflector, this._delegate, this._name, superClass);
        ret._isSecondClass = this._isSecondClass;
        GenericField[] fields = new GenericField[this._fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (GenericField)this._fields[i].deepClone(reflector);
        }
        ret.initFields(fields);
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericClass)) {
            return false;
        }
        GenericClass otherGC = (GenericClass)obj;
        if (this._hashCode != otherGC.hashCode()) {
            return false;
        }
        return this._name.equals(otherGC._name);
    }

    public ReflectClass getComponentType() {
        if (this._delegate != null) {
            return this._delegate.getComponentType();
        }
        return null;
    }

    public ReflectField getDeclaredField(String name) {
        if (this._delegate != null) {
            return this._delegate.getDeclaredField(name);
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].getName().equals(name)) continue;
            return this._fields[i];
        }
        return null;
    }

    public ReflectField[] getDeclaredFields() {
        if (this._delegate != null) {
            return this._delegate.getDeclaredFields();
        }
        return this._fields;
    }

    public ReflectClass getDelegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        return this;
    }

    int getFieldCount() {
        if (this._fieldCount != -1) {
            return this._fieldCount;
        }
        this._fieldCount = 0;
        if (this._superclass != null) {
            this._fieldCount = this._superclass.getFieldCount();
        }
        if (this._declaredFieldCount == -1) {
            this._declaredFieldCount = this.getDeclaredFields().length;
        }
        this._fieldCount += this._declaredFieldCount;
        return this._fieldCount;
    }

    public ReflectMethod getMethod(String methodName, ReflectClass[] paramClasses) {
        if (this._delegate != null) {
            return this._delegate.getMethod(methodName, paramClasses);
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public ReflectClass getSuperclass() {
        if (this._superclass != null) {
            return this._superclass;
        }
        if (this._delegate == null) {
            return this._reflector.forClass(Object.class);
        }
        ReflectClass delegateSuperclass = this._delegate.getSuperclass();
        if (delegateSuperclass != null) {
            this._superclass = this._reflector.ensureDelegate(delegateSuperclass);
        }
        return this._superclass;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public void initFields(GenericField[] fields) {
        int startIndex = 0;
        if (this._superclass != null) {
            startIndex = this._superclass.getFieldCount();
        }
        this._fields = fields;
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i].setIndex(startIndex + i);
        }
    }

    public boolean isAbstract() {
        if (this._delegate != null) {
            return this._delegate.isAbstract();
        }
        return false;
    }

    public boolean isArray() {
        if (this._delegate != null) {
            return this._delegate.isArray();
        }
        return false;
    }

    public boolean isAssignableFrom(ReflectClass subclassCandidate) {
        if (subclassCandidate == null) {
            return false;
        }
        if (this.equals(subclassCandidate)) {
            return true;
        }
        if (this._delegate != null) {
            if (subclassCandidate instanceof GenericClass) {
                subclassCandidate = ((GenericClass)subclassCandidate).getDelegate();
            }
            return this._delegate.isAssignableFrom(subclassCandidate);
        }
        if (!(subclassCandidate instanceof GenericClass)) {
            return false;
        }
        return this.isAssignableFrom(subclassCandidate.getSuperclass());
    }

    public boolean isCollection() {
        if (this._isCollection == 1) {
            return true;
        }
        if (this._isCollection == -1) {
            return false;
        }
        this._isCollection = this._reflector.isCollection(this) ? 1 : -1;
        return this.isCollection();
    }

    public boolean isInstance(Object candidate) {
        if (this._delegate != null) {
            return this._delegate.isInstance(candidate);
        }
        if (!(candidate instanceof GenericObject)) {
            return false;
        }
        return this.isAssignableFrom(((GenericObject)candidate)._class);
    }

    public boolean isInterface() {
        if (this._delegate != null) {
            return this._delegate.isInterface();
        }
        return false;
    }

    public boolean isPrimitive() {
        if (this._delegate != null) {
            return this._delegate.isPrimitive();
        }
        return this._isPrimitive;
    }

    public Object newInstance() {
        if (this._delegate != null) {
            return this._delegate.newInstance();
        }
        return new GenericObject(this);
    }

    public Reflector reflector() {
        if (this._delegate != null) {
            return this._delegate.reflector();
        }
        return this._reflector;
    }

    void setConverter(GenericConverter converter) {
        this._converter = converter;
    }

    void setDeclaredFieldCount(int count) {
        this._declaredFieldCount = count;
    }

    void setPrimitive() {
        this._isPrimitive = true;
    }

    void setSecondClass() {
        this._isSecondClass = true;
    }

    public String toString() {
        return "GenericClass " + this._name;
    }

    public String toString(GenericObject obj) {
        if (this._converter == null) {
            return "(G) " + this.getName();
        }
        return this._converter.toString(obj);
    }

    public boolean ensureCanBeInstantiated() {
        if (this._delegate != null) {
            return this._delegate.ensureCanBeInstantiated();
        }
        return true;
    }

    public Object nullValue() {
        if (this._delegate == null) {
            return null;
        }
        return this._delegate.nullValue();
    }
}

