/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectClassPredicate;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.ReflectorConfiguration;
import com.db4o.reflect.generic.CollectionUpdateDepthEntry;
import com.db4o.reflect.generic.GenericArray;
import com.db4o.reflect.generic.GenericArrayClass;
import com.db4o.reflect.generic.GenericArrayReflector;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericClassBuilder;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericObject;
import com.db4o.reflect.generic.KnownClassesRepository;

public class GenericReflector
implements Reflector,
DeepClone {
    private KnownClassesRepository _repository;
    private Reflector _delegate;
    private GenericArrayReflector _array;
    private Collection4 _collectionPredicates = new Collection4();
    private Collection4 _collectionUpdateDepths = new Collection4();
    private final Hashtable4 _classByClass = new Hashtable4();
    private Transaction _trans;
    private ObjectContainerBase _stream;

    public GenericReflector(Transaction trans, Reflector delegateReflector) {
        this._repository = new KnownClassesRepository(new GenericClassBuilder(this, delegateReflector));
        this.setTransaction(trans);
        this._delegate = delegateReflector;
        if (this._delegate != null) {
            this._delegate.setParent(this);
        }
    }

    public GenericReflector(Reflector delegateReflector) {
        this(null, delegateReflector);
    }

    public Object deepClone(Object obj) {
        GenericReflector myClone = new GenericReflector(null, (Reflector)this._delegate.deepClone(this));
        myClone._collectionPredicates = (Collection4)this._collectionPredicates.deepClone(myClone);
        myClone._collectionUpdateDepths = (Collection4)this._collectionUpdateDepths.deepClone(myClone);
        return myClone;
    }

    ObjectContainerBase getStream() {
        return this._stream;
    }

    public boolean hasTransaction() {
        return this._trans != null;
    }

    public void setTransaction(Transaction trans) {
        if (trans != null) {
            this._trans = trans;
            this._stream = trans.container();
        }
        this._repository.setTransaction(trans);
    }

    public ReflectArray array() {
        if (this._array == null) {
            this._array = new GenericArrayReflector(this);
        }
        return this._array;
    }

    public int collectionUpdateDepth(ReflectClass candidate) {
        Iterator4 i = this._collectionUpdateDepths.iterator();
        while (i.moveNext()) {
            CollectionUpdateDepthEntry entry = (CollectionUpdateDepthEntry)i.current();
            if (!entry._predicate.match(candidate)) continue;
            return entry._depth;
        }
        return 2;
    }

    GenericClass ensureDelegate(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        GenericClass claxx = (GenericClass)this._repository.lookupByName(clazz.getName());
        if (claxx == null) {
            claxx = this.genericClass(clazz);
            this._repository.register(claxx);
        }
        return claxx;
    }

    private GenericClass genericClass(ReflectClass clazz) {
        String name = clazz.getName();
        GenericClass ret = name.equals(ReflectPlatform.fullyQualifiedName(GenericArray.class)) ? new GenericArrayClass(this, clazz, name, null) : new GenericClass(this, clazz, name, null);
        return ret;
    }

    public ReflectClass forClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ReflectClass claxx = (ReflectClass)this._classByClass.get(clazz);
        if (claxx != null) {
            return claxx;
        }
        if (!clazz.isArray() && ReflectPlatform.isNamedClass(clazz) && (claxx = this.forName(ReflectPlatform.fullyQualifiedName(clazz))) != null) {
            this._classByClass.put(clazz, (Object)claxx);
            return claxx;
        }
        claxx = this._delegate.forClass(clazz);
        if (claxx == null) {
            return null;
        }
        claxx = this.ensureDelegate(claxx);
        this._classByClass.put(clazz, (Object)claxx);
        return claxx;
    }

    public ReflectClass forName(String className) {
        ReflectClass clazz = this._repository.lookupByName(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this._delegate.forName(className);
        if (clazz != null) {
            return this.ensureDelegate(clazz);
        }
        return this._repository.forName(className);
    }

    public ReflectClass forObject(Object obj) {
        if (obj instanceof GenericObject) {
            return this.forGenericObject((GenericObject)obj);
        }
        if (obj instanceof GenericArray) {
            return ((GenericArray)obj)._clazz;
        }
        return this._delegate.forObject(obj);
    }

    private ReflectClass forGenericObject(GenericObject genericObject) {
        GenericClass claxx = genericObject._class;
        if (claxx == null) {
            throw new IllegalStateException();
        }
        String name = claxx.getName();
        if (name == null) {
            throw new IllegalStateException();
        }
        GenericClass existingClass = (GenericClass)this.forName(name);
        if (existingClass == null) {
            this._repository.register(claxx);
            return claxx;
        }
        if (existingClass != claxx) {
            throw new IllegalStateException();
        }
        return claxx;
    }

    public Reflector getDelegate() {
        return this._delegate;
    }

    public boolean isCollection(ReflectClass candidate) {
        Iterator4 i = this._collectionPredicates.iterator();
        while (i.moveNext()) {
            if (!((ReflectClassPredicate)i.current()).match(candidate)) continue;
            return true;
        }
        return this._delegate.isCollection(candidate.getDelegate());
    }

    public void registerCollection(Class clazz) {
        this.registerCollection(this.classPredicate(clazz));
    }

    public void registerCollection(ReflectClassPredicate predicate) {
        this._collectionPredicates.add(predicate);
    }

    private ReflectClassPredicate classPredicate(Class clazz) {
        final ReflectClass collectionClass = this.forClass(clazz);
        ReflectClassPredicate predicate = new ReflectClassPredicate(){

            public boolean match(ReflectClass candidate) {
                return collectionClass.isAssignableFrom(candidate);
            }
        };
        return predicate;
    }

    public void registerCollectionUpdateDepth(Class clazz, int depth) {
        this.registerCollectionUpdateDepth(this.classPredicate(clazz), depth);
    }

    public void registerCollectionUpdateDepth(ReflectClassPredicate predicate, int depth) {
        this._collectionUpdateDepths.add(new CollectionUpdateDepthEntry(predicate, depth));
    }

    public void register(GenericClass clazz) {
        String name = clazz.getName();
        if (this._repository.lookupByName(name) == null) {
            this._repository.register(clazz);
        }
    }

    public ReflectClass[] knownClasses() {
        Collection4 classes = new Collection4();
        this.collectKnownClasses(classes);
        return (ReflectClass[])classes.toArray(new ReflectClass[classes.size()]);
    }

    private void collectKnownClasses(Collection4 classes) {
        Iterator4 i = this._repository.classes();
        while (i.moveNext()) {
            ClassMetadata clazzMeta;
            GenericClass clazz = (GenericClass)i.current();
            if (this._stream._handlers.ICLASS_INTERNAL.isAssignableFrom(clazz) || (clazzMeta = this._stream.classMetadataForReflectClass(clazz)) != null && clazzMeta.isSecondClass() || clazz.isArray()) continue;
            classes.add(clazz);
        }
    }

    public void registerPrimitiveClass(int id, String name, GenericConverter converter) {
        GenericClass existing = (GenericClass)this._repository.lookupByID(id);
        if (existing != null) {
            if (null != converter) {
                existing.setSecondClass();
            } else {
                existing.setConverter(null);
            }
            return;
        }
        ReflectClass clazz = this._delegate.forName(name);
        GenericClass claxx = null;
        if (clazz != null) {
            claxx = this.ensureDelegate(clazz);
        } else {
            claxx = new GenericClass(this, null, name, null);
            this.register(claxx);
            claxx.initFields(new GenericField[]{new GenericField(null, null, true)});
            claxx.setConverter(converter);
        }
        claxx.setSecondClass();
        claxx.setPrimitive();
        this._repository.register(id, claxx);
    }

    public void setParent(Reflector reflector) {
    }

    public void configuration(ReflectorConfiguration config) {
        if (this._delegate != null) {
            this._delegate.configuration(config);
        }
    }
}

