/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta;

import com.db4o.ObjectContainer;
import com.db4o.activation.Activator;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.events.ClassEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectContainerEventArgs;
import com.db4o.events.ObjectEventArgs;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.EmbeddedClientObjectContainer;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.ta.Activatable;
import com.db4o.ta.NotTransparentActivationEnabled;
import com.db4o.ta.TransactionalActivator;

public class TransparentActivationSupport
implements ConfigurationItem {
    public void prepare(Configuration configuration) {
    }

    public void apply(InternalObjectContainer container) {
        container.configImpl().activationDepthProvider(new TransparentActivationDepthProvider());
        EventRegistry registry = this.eventRegistryFor(container);
        registry.instantiated().addListener(new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                TransparentActivationSupport.this.bindActivatableToActivator((ObjectEventArgs)args);
            }
        });
        registry.created().addListener(new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                TransparentActivationSupport.this.bindActivatableToActivator((ObjectEventArgs)args);
            }
        });
        registry.closing().addListener(new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                TransparentActivationSupport.this.unbindAll((InternalObjectContainer)((ObjectContainerEventArgs)args).objectContainer());
            }
        });
        final TADiagnosticProcessor processor = new TADiagnosticProcessor(container);
        registry.classRegistered().addListener(new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                ClassEventArgs cea = (ClassEventArgs)args;
                processor.onClassRegistered(cea.classMetadata());
            }
        });
    }

    private EventRegistry eventRegistryFor(ObjectContainer container) {
        return EventRegistryFactory.forObjectContainer(container);
    }

    private void unbindAll(InternalObjectContainer container) {
        Transaction transaction = container.transaction();
        if (transaction == null) {
            return;
        }
        ReferenceSystem referenceSystem = transaction.referenceSystem();
        referenceSystem.traverseReferences(new Visitor4(){

            public void visit(Object obj) {
                TransparentActivationSupport.this.unbind((ObjectReference)obj);
            }
        });
    }

    private void unbind(ObjectReference objectReference) {
        Object obj = objectReference.getObject();
        if (obj == null || !(obj instanceof Activatable)) {
            return;
        }
        this.bind(obj, null);
    }

    private void bindActivatableToActivator(ObjectEventArgs oea) {
        Object obj = oea.object();
        if (obj instanceof Activatable) {
            Transaction transaction = (Transaction)oea.transaction();
            ObjectReference objectReference = transaction.referenceForObject(obj);
            this.bind(obj, this.activatorForObject(transaction, objectReference));
        }
    }

    private void bind(Object activatable, Activator activator) {
        ((Activatable)activatable).bind(activator);
    }

    private Activator activatorForObject(Transaction transaction, ObjectReference objectReference) {
        if (this.isEmbeddedClient(transaction)) {
            return new TransactionalActivator(transaction, objectReference);
        }
        return objectReference;
    }

    private boolean isEmbeddedClient(Transaction transaction) {
        return transaction.objectContainer() instanceof EmbeddedClientObjectContainer;
    }

    private final class TADiagnosticProcessor {
        private final InternalObjectContainer _container;

        public TADiagnosticProcessor(InternalObjectContainer container) {
            this._container = container;
        }

        public void onClassRegistered(ClassMetadata clazz) {
            ReflectClass reflectClass = clazz.classReflector();
            if (this.activatableClass().isAssignableFrom(reflectClass)) {
                return;
            }
            if (this.hasNoActivatingFields(reflectClass)) {
                return;
            }
            NotTransparentActivationEnabled diagnostic = new NotTransparentActivationEnabled(clazz);
            DiagnosticProcessor processor = this._container.handlers()._diagnosticProcessor;
            processor.onDiagnostic(diagnostic);
        }

        private ReflectClass activatableClass() {
            return this._container.reflector().forClass(Activatable.class);
        }

        private boolean hasNoActivatingFields(ReflectClass clazz) {
            for (ReflectClass curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
                ReflectField[] fields = curClass.getDeclaredFields();
                if (this.hasNoActivatingFields(fields)) continue;
                return false;
            }
            return true;
        }

        private boolean hasNoActivatingFields(ReflectField[] fields) {
            for (int i = 0; i < fields.length; ++i) {
                if (!this.isActivating(fields[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isActivating(ReflectField field) {
            ReflectClass fieldType = field.getFieldType();
            return fieldType != null && !fieldType.isPrimitive();
        }
    }
}

