/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import java.io.File;
import java.io.FileWriter;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.io.BioUtils;
import org.restlet.ext.velocity.TemplateFilter;
import org.restlet.resource.Directory;
import org.restlet.test.RestletTestCase;

public class TemplateFilterTestCase
extends RestletTestCase {
    File testDir;

    public void testTemplateFilter() {
        try {
            this.testDir = new File(System.getProperty("java.io.tmpdir"), "TemplateFilterTestCase");
            BioUtils.delete((File)this.testDir, (boolean)true);
            this.testDir.mkdir();
            File testFileFm1 = new File(this.testDir, "testFm1.txt.fmt");
            FileWriter fw = new FileWriter(testFileFm1);
            fw.write("Method=${m}/Authority=${ra}");
            fw.close();
            File testFileFm2 = new File(this.testDir, "testFm2.txt");
            fw = new FileWriter(testFileFm2);
            fw.write("Method=${m}/Authority=${ra}");
            fw.close();
            File testFileVl1 = new File(this.testDir, "testVl1.txt.vm");
            fw = new FileWriter(testFileVl1);
            fw.write("Method=${m}/Path=${rp}");
            fw.close();
            File testFileVl2 = new File(this.testDir, "testVl2.txt");
            fw = new FileWriter(testFileVl2);
            fw.write("Method=${m}/Path=${rp}");
            fw.close();
            Component component = new Component();
            component.getServers().add(Protocol.HTTP, TEST_PORT);
            component.getClients().add(Protocol.FILE);
            MyFreemakerApplication freemarkerApplication = new MyFreemakerApplication(this.testDir);
            MyVelocityApplication velocityApplication = new MyVelocityApplication(this.testDir);
            component.getDefaultHost().attach("/freemarker", (Restlet)freemarkerApplication);
            component.getDefaultHost().attach("/velocity", (Restlet)velocityApplication);
            component.start();
            freemarkerApplication.getTunnelService().setExtensionsTunnel(true);
            velocityApplication.getTunnelService().setExtensionsTunnel(true);
            Client client = new Client(Protocol.HTTP);
            Response response = client.handle(new Request(Method.GET, "http://localhost:" + TEST_PORT + "/freemarker/" + testFileFm1.getName()));
            if (response.isEntityAvailable()) {
                TemplateFilterTestCase.assertEquals((String)("Method=GET/Authority=localhost:" + TEST_PORT), (String)response.getEntity().getText());
            }
            response = client.handle(new Request(Method.GET, "http://localhost:" + TEST_PORT + "/freemarker/" + testFileFm2.getName()));
            TemplateFilterTestCase.assertTrue((boolean)response.getStatus().isSuccess());
            if (response.isEntityAvailable()) {
                TemplateFilterTestCase.assertEquals((String)"Method=${m}/Authority=${ra}", (String)response.getEntity().getText());
            }
            if ((response = client.handle(new Request(Method.GET, "http://localhost:" + TEST_PORT + "/velocity/" + testFileVl1.getName()))).isEntityAvailable()) {
                TemplateFilterTestCase.assertEquals((String)"Method=GET/Path=/velocity/testVl1", (String)response.getEntity().getText());
            }
            response = client.handle(new Request(Method.GET, "http://localhost:" + TEST_PORT + "/velocity/" + testFileVl2.getName()));
            TemplateFilterTestCase.assertTrue((boolean)response.getStatus().isSuccess());
            if (response.isEntityAvailable()) {
                TemplateFilterTestCase.assertEquals((String)"Method=${m}/Path=${rp}", (String)response.getEntity().getText());
            }
            component.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MyVelocityApplication
    extends Application {
        File testDirectory;
        Directory directory;

        public MyVelocityApplication(File testDirectory) {
            this.setTestDirectory(testDirectory);
        }

        public Restlet createInboundRoot() {
            this.directory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((File)this.getTestDirectory()));
            this.directory.setNegotiatingContent(true);
            return new TemplateFilter(this.getContext(), (Restlet)this.directory);
        }

        public File getTestDirectory() {
            return this.testDirectory;
        }

        public void setTestDirectory(File testDirectory) {
            this.testDirectory = testDirectory;
        }
    }

    private static class MyFreemakerApplication
    extends Application {
        File testDirectory;
        Directory directory;

        public MyFreemakerApplication(File testDirectory) {
            this.setTestDirectory(testDirectory);
        }

        public Restlet createInboundRoot() {
            this.directory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((File)this.getTestDirectory()));
            this.directory.setNegotiatingContent(true);
            return new org.restlet.ext.freemarker.TemplateFilter(this.getContext(), (Restlet)this.directory);
        }

        public File getTestDirectory() {
            return this.testDirectory;
        }

        public void setTestDirectory(File testDirectory) {
            this.testDirectory = testDirectory;
        }
    }
}

