/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.component;

import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.representation.AppendableRepresentation;
import org.restlet.representation.Representation;
import org.restlet.test.RestletTestCase;

public class ComponentXmlTestCase
extends RestletTestCase {
    private final int port = TEST_PORT;
    private final int port2 = this.port + 1;

    public void testComponentXMLConfig() throws Exception {
        AppendableRepresentation config = new AppendableRepresentation();
        config.append((CharSequence)"<?xml version=\"1.0\"?>");
        config.append((CharSequence)"<component>");
        config.append((CharSequence)("<server protocol=\"HTTP\" port=\"" + this.port + "\" />"));
        config.append((CharSequence)("<server protocol=\"HTTP\" port=\"" + this.port2 + "\" />"));
        config.append((CharSequence)("<defaultHost hostPort=\"" + this.port2 + "\">"));
        config.append((CharSequence)"<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.component.HelloWorldApplication\" /> ");
        config.append((CharSequence)"</defaultHost>");
        config.append((CharSequence)("<host hostPort=\"" + this.port + "\">"));
        config.append((CharSequence)"<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.component.HelloWorldApplication\" /> ");
        config.append((CharSequence)"</host>");
        config.append((CharSequence)"</component>");
        Component component = new Component((Representation)config);
        component.start();
        Client client = new Client(Protocol.HTTP);
        Response response = client.handle(new Request(Method.GET, "http://localhost:" + this.port + "/efgh"));
        ComponentXmlTestCase.assertTrue((boolean)response.getStatus().isSuccess());
        ComponentXmlTestCase.assertTrue((boolean)response.isEntityAvailable());
        response = client.handle(new Request(Method.GET, "http://localhost:" + this.port + "/abcd"));
        ComponentXmlTestCase.assertTrue((boolean)response.getStatus().isClientError());
        response = client.handle(new Request(Method.GET, "http://localhost:" + this.port2 + "/abcd"));
        ComponentXmlTestCase.assertTrue((boolean)response.getStatus().isSuccess());
        ComponentXmlTestCase.assertTrue((boolean)response.isEntityAvailable());
        response = client.handle(new Request(Method.GET, "http://localhost:" + this.port2 + "/efgh"));
        ComponentXmlTestCase.assertTrue((boolean)response.getStatus().isClientError());
        component.stop();
    }
}

