/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.connector;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;

public class RiapTestCase
extends TestCase {
    private static final String DEFAULT_MSG = "no-default";
    private static final Serializable JUST_SOME_OBJ = new Serializable(){
        private static final long serialVersionUID = 1L;
    };
    private static final String ECHO_TEST_MSG = JUST_SOME_OBJ.toString();

    private String buildAggregate(String echoMessage, String echoCopy) {
        return "ORIGINAL: " + echoMessage + "\n" + "ECHOCOPY: " + echoCopy + "\n";
    }

    public void testRiap() throws Exception {
        Component comp = new Component();
        Application localOnly = new Application(){

            public Restlet createInboundRoot() {
                return new Restlet(this.getContext()){

                    public void handle(Request request, Response response) {
                        String selfBase = "riap://application";
                        Reference ref = request.getResourceRef();
                        String remainder = ref.getRemainingPart();
                        StringRepresentation result = new StringRepresentation((CharSequence)RiapTestCase.DEFAULT_MSG);
                        if (remainder.startsWith("/echo/")) {
                            result = new StringRepresentation((CharSequence)remainder.substring(6));
                        } else if (remainder.equals("/object")) {
                            result = new ObjectRepresentation(JUST_SOME_OBJ);
                        } else if (remainder.equals("/null")) {
                            result = new ObjectRepresentation((Serializable)null);
                        } else if (remainder.equals("/self-aggregated")) {
                            String echoMessage = ECHO_TEST_MSG;
                            LocalReference echoRef = new LocalReference("riap://application/echo/" + echoMessage);
                            String echoCopy = null;
                            try {
                                ClientResource r = new ClientResource((Reference)echoRef);
                                echoCopy = r.get().getText();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Assert.fail((String)("Error getting internal reference to " + echoRef));
                            }
                            Assert.assertEquals((String)"expected echoMessage back", (String)echoMessage, (String)echoCopy);
                            result = new StringRepresentation((CharSequence)RiapTestCase.this.buildAggregate(echoMessage, echoCopy));
                        }
                        response.setEntity((Representation)result);
                    }
                };
            }
        };
        comp.getInternalRouter().attach("/local", (Restlet)localOnly);
        String localBase = "riap://component/local";
        Client dispatcher = comp.getContext().getClientDispatcher();
        String msg = "this%20message";
        String echoURI = localBase + "/echo/" + msg;
        Representation echoRep = dispatcher.handle(new Request(Method.GET, echoURI)).getEntity();
        RiapTestCase.assertEquals((String)"expected echo of uri-remainder", (String)msg, (String)echoRep.getText());
        String objURI = localBase + "/object";
        Representation objRep = dispatcher.handle(new Request(Method.GET, objURI)).getEntity();
        RiapTestCase.assertSame((String)"expected specific test-object", (Object)JUST_SOME_OBJ, (Object)((ObjectRepresentation)objRep).getObject());
        String nullURI = localBase + "/null";
        Representation nullRep = dispatcher.handle(new Request(Method.GET, nullURI)).getEntity();
        RiapTestCase.assertNull((String)"expected null", (Object)((ObjectRepresentation)nullRep).getObject());
        String anyURI = localBase + "/whatever";
        Representation anyRep = dispatcher.handle(new Request(Method.GET, anyURI)).getEntity();
        RiapTestCase.assertEquals((String)"expected echo of uri-remainder", (String)DEFAULT_MSG, (String)anyRep.getText());
        String aggURI = localBase + "/self-aggregated";
        Representation aggRep = dispatcher.handle(new Request(Method.GET, aggURI)).getEntity();
        String expectedResult = this.buildAggregate(ECHO_TEST_MSG, ECHO_TEST_MSG);
        RiapTestCase.assertEquals((String)"expected specific aggregated message", (String)expectedResult, (String)aggRep.getText());
    }
}

