/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class MediaTypeTestCase
extends RestletTestCase {
    protected static final String DEFAULT_SCHEME = "http";
    protected static final String DEFAULT_SCHEMEPART = "//";

    public void assertMediaType(String name, String main, String sub, boolean concrete) {
        MediaType type = new MediaType(name);
        MediaTypeTestCase.assertEquals((String)main, (String)type.getMainType());
        MediaTypeTestCase.assertEquals((String)sub, (String)type.getSubType());
        MediaTypeTestCase.assertEquals((boolean)concrete, (boolean)type.isConcrete());
    }

    public void testConcrete() {
        this.assertMediaType("application/xml", "application", "xml", true);
        this.assertMediaType("application/ xml ", "application", "xml", true);
        this.assertMediaType(" application /xml", "application", "xml", true);
        this.assertMediaType(" application / xml ", "application", "xml", true);
        this.assertMediaType("application/atom+xml;type=entry", "application", "atom+xml", true);
    }

    public void testParameters() {
        MediaType mt = MediaType.valueOf((String)"application/atom+xml;type=entry");
        MediaTypeTestCase.assertEquals((String)"entry", (String)mt.getParameters().getFirstValue("type"));
        mt = MediaType.valueOf((String)"multipart/x-mixed-replace; boundary=\"My boundary\"");
        MediaTypeTestCase.assertEquals((String)"\"My boundary\"", (String)mt.getParameters().getFirstValue("boundary"));
    }

    public void testEquals() throws Exception {
        MediaType mt1 = new MediaType("application/xml");
        MediaType mt2 = MediaType.APPLICATION_XML;
        MediaTypeTestCase.assertTrue((boolean)mt1.equals((Object)mt2));
        MediaTypeTestCase.assertEquals((Object)mt1, (Object)mt2);
        Form mediaParams1 = new Form();
        mediaParams1.add((Object)new Parameter("charset", "ISO-8859-1"));
        MediaType mt1Bis = new MediaType("application/xml", (Series)mediaParams1);
        Form mediaParams2 = new Form();
        mediaParams2.add((Object)new Parameter("charset", "ISO-8859-1"));
        MediaType mt2Bis = new MediaType("application/xml", (Series)mediaParams2);
        Form mediaParams3 = new Form();
        mediaParams3.add((Object)new Parameter("charset", "ISO-8859-15"));
        MediaType mt3 = new MediaType("application/xml", (Series)mediaParams3);
        MediaTypeTestCase.assertTrue((boolean)mt1Bis.equals((Object)mt2Bis));
        MediaTypeTestCase.assertEquals((Object)mt1, (Object)mt2);
        MediaTypeTestCase.assertTrue((boolean)mt1Bis.equals((Object)mt1, true));
        MediaTypeTestCase.assertTrue((boolean)mt1Bis.equals((Object)mt2, true));
        MediaTypeTestCase.assertTrue((boolean)mt1Bis.equals((Object)mt3, true));
        mt1 = new MediaType("application/*");
        mt2 = MediaType.APPLICATION_ALL;
        MediaTypeTestCase.assertTrue((boolean)mt1.equals((Object)mt2));
        MediaTypeTestCase.assertEquals((Object)mt1, (Object)mt2);
    }

    public void testIncludes() throws Exception {
        MediaType mt1 = MediaType.APPLICATION_ALL;
        MediaType mt2 = MediaType.APPLICATION_XML;
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt1));
        MediaTypeTestCase.assertTrue((boolean)mt2.includes((Metadata)mt2));
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt2));
        MediaTypeTestCase.assertFalse((boolean)mt2.includes((Metadata)mt1));
        mt1 = MediaType.APPLICATION_ALL_XML;
        mt2 = MediaType.APPLICATION_XML;
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt1));
        MediaTypeTestCase.assertTrue((boolean)mt2.includes((Metadata)mt2));
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt2));
        MediaTypeTestCase.assertFalse((boolean)mt2.includes((Metadata)mt1));
        mt1 = MediaType.APPLICATION_ALL_XML;
        mt2 = MediaType.APPLICATION_ATOMPUB_SERVICE;
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt1));
        MediaTypeTestCase.assertTrue((boolean)mt2.includes((Metadata)mt2));
        MediaTypeTestCase.assertTrue((boolean)mt1.includes((Metadata)mt2));
        MediaTypeTestCase.assertFalse((boolean)mt2.includes((Metadata)mt1));
    }

    public void testMostSpecificMediaType() {
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_ALL, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.ALL, MediaType.TEXT_ALL}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_ALL, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.TEXT_ALL, MediaType.ALL}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.ALL, MediaType.TEXT_ALL, MediaType.TEXT_PLAIN}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.ALL, MediaType.TEXT_PLAIN, MediaType.TEXT_ALL}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.TEXT_ALL, MediaType.ALL, MediaType.TEXT_PLAIN}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.TEXT_ALL, MediaType.TEXT_PLAIN, MediaType.ALL}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.TEXT_PLAIN, MediaType.ALL, MediaType.TEXT_ALL}));
        MediaTypeTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)MediaType.getMostSpecific((MediaType[])new MediaType[]{MediaType.TEXT_PLAIN, MediaType.TEXT_ALL, MediaType.ALL}));
    }

    public void testNotConcrete() {
        this.assertMediaType("", "*", "*", false);
        this.assertMediaType("  ", "*", "*", false);
        this.assertMediaType("*/", "*", "*", false);
        this.assertMediaType("*/  ", "*", "*", false);
        this.assertMediaType(" * /", "*", "*", false);
        this.assertMediaType("/*", "*", "*", false);
        this.assertMediaType("  /*", "*", "*", false);
        this.assertMediaType("/ * ", "*", "*", false);
        this.assertMediaType("  / * ", "*", "*", false);
        this.assertMediaType("*/*", "*", "*", false);
        this.assertMediaType(" * /*", "*", "*", false);
        this.assertMediaType("*/ * ", "*", "*", false);
        this.assertMediaType(" * / * ", "*", "*", false);
        this.assertMediaType("/xml", "*", "xml", false);
        this.assertMediaType("/ xml ", "*", "xml", false);
        this.assertMediaType("  /xml", "*", "xml", false);
        this.assertMediaType("  / xml ", "*", "xml", false);
        this.assertMediaType("*/xml", "*", "xml", false);
        this.assertMediaType(" * /xml", "*", "xml", false);
        this.assertMediaType("*/ xml ", "*", "xml", false);
        this.assertMediaType(" * / xml ", "*", "xml", false);
        this.assertMediaType("application", "application", "*", false);
        this.assertMediaType(" application ", "application", "*", false);
        this.assertMediaType("application/", "application", "*", false);
        this.assertMediaType(" application /", "application", "*", false);
        this.assertMediaType(" application /  ", "application", "*", false);
        this.assertMediaType("application/*", "application", "*", false);
        this.assertMediaType(" application /*", "application", "*", false);
        this.assertMediaType("application/ * ", "application", "*", false);
        this.assertMediaType(" application /*", "application", "*", false);
    }

    public void testUnEquals() throws Exception {
        MediaType mt1 = new MediaType("application/xml");
        MediaType mt2 = new MediaType("application/xml2");
        MediaTypeTestCase.assertFalse((boolean)mt1.equals((Object)mt2));
        Form mediaParams1 = new Form();
        mediaParams1.add((Object)new Parameter("charset", "ISO-8859-1"));
        MediaType mt1Bis = new MediaType("application/xml", (Series)mediaParams1);
        Form mediaParams3 = new Form();
        mediaParams3.add((Object)new Parameter("charset", "ISO-8859-15"));
        MediaType mt3 = new MediaType("application/xml", (Series)mediaParams3);
        MediaTypeTestCase.assertFalse((boolean)mt1Bis.equals((Object)mt1));
        MediaTypeTestCase.assertFalse((boolean)mt1Bis.equals((Object)mt3));
        mt1 = new MediaType("application/1");
        mt2 = MediaType.APPLICATION_ALL;
        MediaTypeTestCase.assertFalse((boolean)mt1.equals((Object)mt2));
    }

    public void testValueOf() {
        MediaTypeTestCase.assertSame((Object)MediaType.APPLICATION_XML, (Object)MediaType.valueOf((String)"application/xml"));
        MediaTypeTestCase.assertSame((Object)MediaType.ALL, (Object)MediaType.valueOf((String)"*/*"));
        MediaType newType = MediaType.valueOf((String)"application/x-restlet-test");
        MediaTypeTestCase.assertEquals((String)"application", (String)newType.getMainType());
        MediaTypeTestCase.assertEquals((String)"x-restlet-test", (String)newType.getSubType());
        MediaTypeTestCase.assertEquals((String)"application/x-restlet-test", (String)newType.getName());
        MediaTypeTestCase.assertNotSame((Object)newType, (Object)MediaType.valueOf((String)"application/x-restlet-test"));
        MediaType registeredType = MediaType.register((String)"application/x-restlet-test", (String)"Restlet testcase");
        MediaTypeTestCase.assertNotSame((Object)newType, (Object)registeredType);
        MediaTypeTestCase.assertEquals((String)"application/x-restlet-test", (String)registeredType.getName());
        MediaTypeTestCase.assertEquals((String)"Restlet testcase", (String)registeredType.getDescription());
        MediaTypeTestCase.assertSame((Object)registeredType, (Object)MediaType.valueOf((String)"application/x-restlet-test"));
        MediaTypeTestCase.assertSame((Object)registeredType, (Object)MediaType.valueOf((String)"application/x-restlet-test"));
        MediaType mediaType = MediaType.valueOf((String)"application/atom+xml; name=value");
        MediaTypeTestCase.assertEquals((String)"application/atom+xml; name=value", (String)mediaType.toString());
        MediaTypeTestCase.assertEquals((Object)MediaType.APPLICATION_ATOM, (Object)mediaType.getParent());
    }

    public void testUnmodifiable() {
        Form form = new Form();
        form.add("name1", "value1");
        try {
            Series unmodifiableForm = Series.unmodifiableSeries((Series)form);
            unmodifiableForm.add("name2", "value2");
            MediaTypeTestCase.fail((String)"The series should be unmodifiable now");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

