/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.engine.http.io.KeepAliveOutputStream;
import org.restlet.test.RestletTestCase;

public class KeepAliveOutputStreamTestCase
extends RestletTestCase {
    public void testClose() throws IOException {
        MockOutputStream stream = new MockOutputStream();
        KeepAliveOutputStream out = new KeepAliveOutputStream((OutputStream)stream);
        out.close();
        KeepAliveOutputStreamTestCase.assertFalse((boolean)stream.closed);
        stream.close();
        KeepAliveOutputStreamTestCase.assertTrue((boolean)stream.closed);
    }

    public void testWrite() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        KeepAliveOutputStream out = new KeepAliveOutputStream((OutputStream)stream);
        out.write(97);
        KeepAliveOutputStreamTestCase.assertEquals((String)"a", (String)new String(stream.toByteArray()));
        out.write(new byte[]{98, 99});
        KeepAliveOutputStreamTestCase.assertEquals((String)"abc", (String)new String(stream.toByteArray()));
        out.write(new byte[]{100, 101, 102, 103}, 0, 2);
        KeepAliveOutputStreamTestCase.assertEquals((String)"abcde", (String)new String(stream.toByteArray()));
    }

    static class MockOutputStream
    extends OutputStream {
        boolean closed = false;

        MockOutputStream() {
        }

        public void close() throws IOException {
            this.closed = true;
        }

        public void write(int b) throws IOException {
        }
    }
}

