/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.representation.Representation;
import org.restlet.test.engine.BaseConnectorsTestCase;

public class PostPutTestCase
extends BaseConnectorsTestCase {
    protected void call(String uri) throws Exception {
        Client client = new Client(Protocol.HTTP);
        this.testCall(client, Method.POST, uri);
        this.testCall(client, Method.PUT, uri);
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Restlet trace = new Restlet(this.getContext()){

                    public void handle(Request request, Response response) {
                        Representation entity = request.getEntity();
                        if (entity != null) {
                            Form form = new Form(entity);
                            response.setEntity(form.getWebRepresentation());
                        }
                    }
                };
                return trace;
            }
        };
        return application;
    }

    private void testCall(Client client, Method method, String uri) throws Exception {
        Form inputForm = new Form();
        inputForm.add("a", "a");
        inputForm.add("b", "b");
        Request request = new Request(method, uri);
        request.setEntity(inputForm.getWebRepresentation());
        Response response = client.handle(request);
        PostPutTestCase.assertNotNull((Object)response.getEntity());
        Representation entity = response.getEntity();
        Form outputForm = new Form(entity);
        PostPutTestCase.assertEquals((int)2, (int)outputForm.size());
        PostPutTestCase.assertEquals((String)"a", (String)outputForm.getFirstValue("a"));
        PostPutTestCase.assertEquals((String)"b", (String)outputForm.getFirstValue("b"));
        entity.release();
    }
}

