/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.spring;

import java.util.Arrays;
import org.restlet.ext.spring.SpringBeanFinder;
import org.restlet.resource.Resource;
import org.restlet.resource.ServerResource;
import org.restlet.test.RestletTestCase;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanFinderTestCase
extends RestletTestCase {
    private static final String BEAN_NAME = "fish";
    private StaticApplicationContext applicationContext;
    private DefaultListableBeanFactory beanFactory;
    private SpringBeanFinder finder;

    private MutablePropertyValues createServerResourcePropertyValues() {
        return new MutablePropertyValues(Arrays.asList(new PropertyValue("src", (Object)"spring")));
    }

    private void registerApplicationContextBean(String beanName, Class<SomeResource> resourceClass) {
        this.applicationContext.registerPrototype(beanName, resourceClass);
        this.applicationContext.refresh();
    }

    private void registerBeanFactoryBean(String beanName, Class<?> resourceClass) {
        this.registerBeanFactoryBean(beanName, resourceClass, null);
    }

    private void registerBeanFactoryBean(String beanName, Class<?> resourceClass, MutablePropertyValues values) {
        this.beanFactory.registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(resourceClass, values));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.beanFactory = new DefaultListableBeanFactory();
        this.applicationContext = new StaticApplicationContext();
        this.finder = new SpringBeanFinder();
        this.finder.setBeanName(BEAN_NAME);
    }

    @Override
    protected void tearDown() throws Exception {
        this.beanFactory = null;
        this.applicationContext = null;
        this.finder = null;
        super.tearDown();
    }

    public void testBeanResolutionFailsWithNeitherApplicationContextOrBeanFactory() throws Exception {
        try {
            this.finder.createResource();
            SpringBeanFinderTestCase.fail((String)"Exception not thrown");
        }
        catch (IllegalStateException iae) {
            SpringBeanFinderTestCase.assertEquals((String)"Either a beanFactory or an applicationContext is required for SpringBeanFinder.", (String)iae.getMessage());
        }
    }

    public void testExceptionWhenResourceBeanIsWrongType() throws Exception {
        this.registerBeanFactoryBean(BEAN_NAME, String.class);
        this.finder.setBeanFactory((BeanFactory)this.beanFactory);
        try {
            this.finder.create();
            SpringBeanFinderTestCase.fail((String)"Exception not thrown");
        }
        catch (ClassCastException cce) {
            SpringBeanFinderTestCase.assertEquals((String)"fish does not resolve to an instance of org.restlet.resource.ServerResource", (String)cce.getMessage());
        }
    }

    public void testExceptionWhenServerResourceBeanIsWrongType() throws Exception {
        this.registerBeanFactoryBean(BEAN_NAME, String.class);
        this.finder.setBeanFactory((BeanFactory)this.beanFactory);
        try {
            this.finder.create();
            SpringBeanFinderTestCase.fail((String)"Exception not thrown");
        }
        catch (ClassCastException cce) {
            SpringBeanFinderTestCase.assertEquals((String)"fish does not resolve to an instance of org.restlet.resource.ServerResource", (String)cce.getMessage());
        }
    }

    public void testPrefersApplicationContextOverBeanFactoryIfTheBeanIsInBoth() throws Exception {
        this.registerApplicationContextBean(BEAN_NAME, SomeResource.class);
        this.registerBeanFactoryBean(BEAN_NAME, AnotherResource.class);
        this.finder.setApplicationContext((ApplicationContext)this.applicationContext);
        Resource actual = this.finder.createResource();
        SpringBeanFinderTestCase.assertNotNull((String)"Resource not found", (Object)actual);
        SpringBeanFinderTestCase.assertTrue((String)("Resource not from application context: " + actual.getClass().getName()), (boolean)(actual instanceof SomeResource));
    }

    public void testReturnsResourceBeanWhenExists() throws Exception {
        this.registerBeanFactoryBean(BEAN_NAME, SomeResource.class);
        this.finder.setBeanFactory((BeanFactory)this.beanFactory);
        Resource actual = this.finder.createResource();
        SpringBeanFinderTestCase.assertNotNull((String)"Resource not found", (Object)actual);
        SpringBeanFinderTestCase.assertTrue((String)"Resource not the correct type", (boolean)(actual instanceof SomeResource));
    }

    public void testReturnsServerResourceBeanForLongFormOfCreate() throws Exception {
        this.registerBeanFactoryBean(BEAN_NAME, SomeServerResource.class, this.createServerResourcePropertyValues());
        this.finder.setBeanFactory((BeanFactory)this.beanFactory);
        ServerResource actual = this.finder.create(SomeServerResource.class, null, null);
        SpringBeanFinderTestCase.assertNotNull((String)"Resource not found", (Object)actual);
        SpringBeanFinderTestCase.assertTrue((String)"Resource not the correct type", (boolean)(actual instanceof SomeServerResource));
        SpringBeanFinderTestCase.assertEquals((String)"Resource not from spring context", (String)"spring", (String)((SomeServerResource)actual).getSrc());
    }

    public void testReturnsServerResourceBeanWhenExists() throws Exception {
        this.registerBeanFactoryBean(BEAN_NAME, SomeServerResource.class, this.createServerResourcePropertyValues());
        this.finder.setBeanFactory((BeanFactory)this.beanFactory);
        ServerResource actual = this.finder.create();
        SpringBeanFinderTestCase.assertNotNull((String)"Resource not found", (Object)actual);
        SpringBeanFinderTestCase.assertTrue((String)"Resource not the correct type", (boolean)(actual instanceof SomeServerResource));
    }

    public void testUsesApplicationContextIfPresent() throws Exception {
        this.registerApplicationContextBean(BEAN_NAME, SomeResource.class);
        this.finder.setApplicationContext((ApplicationContext)this.applicationContext);
        Resource actual = this.finder.createResource();
        SpringBeanFinderTestCase.assertNotNull((String)"Resource not found", (Object)actual);
        SpringBeanFinderTestCase.assertTrue((String)"Resource not the correct type", (boolean)(actual instanceof SomeResource));
    }

    private static class SomeServerResource
    extends ServerResource {
        private String src;

        public SomeServerResource() {
            this.setSrc("constructor");
        }

        public String getSrc() {
            return this.src;
        }

        public void setSrc(String src) {
            this.src = src;
        }
    }

    private static class SomeResource
    extends Resource {
        private SomeResource() {
        }
    }

    private static class AnotherResource
    extends Resource {
        private AnotherResource() {
        }
    }
}

