/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.RoleChecker;
import org.restlet.representation.Representation;
import org.restlet.test.jaxrs.services.resources.SecurityContextService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class SecurityContextTest
extends JaxRsTestCase {
    private static final Class<SecurityContextService> SEC_CONT_SERV = SecurityContextService.class;

    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(SEC_CONT_SERV);
            }
        };
    }

    public boolean shouldStartServerInSetUp() {
        return false;
    }

    private boolean startServer(RoleChecker roleChecker) throws Exception {
        this.startServer(ChallengeScheme.HTTP_BASIC, roleChecker);
        return true;
    }

    public void test2() throws Exception {
        if (!this.startServer(RoleChecker.FORBID_ALL)) {
            return;
        }
        Response response = this.get();
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        response = this.getAuth(null, "ydfsdf", "ydf");
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
    }

    public void test3() throws Exception {
        if (!this.startServer(RoleChecker.FORBID_ALL)) {
            return;
        }
        Response response = this.getAuth(null, "admin", "adminPW");
        SecurityContextTest.sysOutEntityIfNotStatus(Status.CLIENT_ERROR_FORBIDDEN, response);
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
    }

    public void test4() throws Exception {
        if (!this.startServer(RoleChecker.FORBID_ALL)) {
            return;
        }
        Response response = this.post(null, new Form().getWebRepresentation(), new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "alice", "alicesSecret"));
        SecurityContextTest.sysOutEntityIfNotStatus(Status.CLIENT_ERROR_FORBIDDEN, response);
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
    }

    public void test5() throws Exception {
        if (!this.startServer(RoleChecker.FORBID_ALL)) {
            return;
        }
        Representation postEntity = new Form("abc=def").getWebRepresentation();
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "bob", "bobsSecret");
        Response response = this.post(null, postEntity, cr);
        SecurityContextTest.sysOutEntityIfNotStatus(Status.CLIENT_ERROR_FORBIDDEN, response);
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
    }

    public void testAllowAll() throws Exception {
        if (!this.startServer(RoleChecker.ALLOW_ALL)) {
            return;
        }
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "bob", "bobsSecret");
        Response response = this.get(null, cr);
        SecurityContextTest.sysOutEntityIfError(response);
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.post(null, new Form("abc=def").getWebRepresentation(), cr);
        SecurityContextTest.sysOutEntityIfError(response);
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        Reference expecretLocation = this.createReference(SEC_CONT_SERV, null);
        SecurityContextTest.assertTrue((String)("The location must start with " + expecretLocation + "; it is " + response.getLocationRef()), (boolean)response.getLocationRef().toString().startsWith(expecretLocation.toString()));
    }

    public void testAuthenticationSchemeBasic() throws Exception {
        if (!this.startServer(RoleChecker.ALLOW_ALL)) {
            return;
        }
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "bob", "bobsSecret");
        Response response = this.get("authenticationScheme", cr);
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        SecurityContextTest.assertEquals((String)"BASIC", (String)entity);
    }

    public void testForbidAll() throws Exception {
        if (!this.startServer(RoleChecker.FORBID_ALL)) {
            return;
        }
        Response response = this.get();
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        response = this.post(new Form("abc=def").getWebRepresentation());
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
    }

    public void testNoRoles() throws Exception {
        RoleChecker exampleAuthorizator = new RoleChecker(){

            public boolean isInRole(Principal principal, String role) {
                if (principal == null) {
                    throw new IllegalArgumentException("No principal given");
                }
                if (role == null) {
                    throw new IllegalArgumentException("No role given");
                }
                return role.charAt(0) == principal.getName().charAt(0);
            }
        };
        if (!this.startServer(exampleAuthorizator)) {
            return;
        }
        Response response = this.getAuth(null, "fsdf", "xyz");
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        response = this.getAuth(null, "fsdf", "baj");
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        response = this.getAuth(null, "alice", "alicesSecret");
        SecurityContextTest.sysOutEntityIfNotStatus(Status.CLIENT_ERROR_FORBIDDEN, response);
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
        response = this.getAuth(null, "bob", "bobsSecret");
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "bob", "bobsSecret");
        response = this.post(null, new Form("abc=def").getWebRepresentation(), cr);
        SecurityContextTest.sysOutEntityIfError(response);
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        response = this.accessServer(Method.PUT, SEC_CONT_SERV, null, null, cr);
        SecurityContextTest.assertEquals((Object)Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, (Object)response.getStatus());
    }

    public void testSecure() throws Exception {
        this.startServer();
        Reference reference = super.createReference("secure");
        Response response = this.get(reference);
        SecurityContextTest.assertEquals((Object)Status.REDIRECTION_PERMANENT, (Object)response.getStatus());
        reference.setScheme("https");
        SecurityContextTest.assertEquals((Object)reference, (Object)response.getLocationRef());
    }

    public void testUserPrincipalAuth() throws Exception {
        if (!this.startServer(RoleChecker.ALLOW_ALL)) {
            return;
        }
        Response response = this.getAuth("userPrincipal", "alice", "alicesSecret");
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        SecurityContextTest.assertEquals((String)"alice", (String)entity);
        response = this.getAuth("userPrincipal", "bob", "bobsSecret");
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        entity = response.getEntity().getText();
        SecurityContextTest.assertEquals((String)"bob", (String)entity);
    }

    public void testUserPrincipalNotAuth() throws Exception {
        this.startServer();
        Response response = this.get("userPrincipal");
        SecurityContextTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        SecurityContextTest.assertEquals((String)"no principal found", (String)entity);
    }
}

