/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Router;
import org.restlet.test.resource.MyResource10;

public class AnnotatedResource10TestCase
extends TestCase {
    private Component c;
    private Client client;

    protected void setUp() throws Exception {
        this.c = new Component();
        this.c.getServers().add(Protocol.HTTP, 8182);
        this.c.getDefaultHost().attach((Restlet)new TestApplication());
        this.c.start();
        this.client = new Client(Protocol.HTTP);
    }

    protected void tearDown() throws Exception {
        this.c.stop();
        this.c = null;
    }

    public void test() throws IOException, ResourceException {
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(Method.GET, "http://localhost:8182/test");
        Response response = this.client.handle(request);
        AnnotatedResource10TestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        AnnotatedResource10TestCase.assertEquals((String)"asText", (String)response.getEntity().getText());
        response.getEntity().release();
        request = new Request(Method.POST, "http://localhost:8182/test");
        response = this.client.handle(request);
        AnnotatedResource10TestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        AnnotatedResource10TestCase.assertEquals((String)"accept", (String)response.getEntity().getText());
        response.getEntity().release();
    }

    private static class TestApplication
    extends Application {
        private TestApplication() {
        }

        public Restlet createInboundRoot() {
            Router router = new Router(this.getContext());
            router.attach("/test", MyResource10.class);
            return router;
        }
    }
}

