/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.File;
import java.io.FileOutputStream;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.test.RestletTestCase;

public class FileRepresentationTestCase
extends RestletTestCase {
    private Component component;
    private File file;
    private File testDir;
    private String uri;

    public void setUp() throws Exception {
        super.setUp();
        this.uri = "http://localhost:" + TEST_PORT + "/";
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, TEST_PORT);
        this.component.start();
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "FileRepresentationTestCase");
        this.testDir.mkdirs();
        this.file = new File(this.testDir, ((Object)((Object)this)).getClass().getName());
        FileOutputStream os = new FileOutputStream(this.file);
        os.write("abc".getBytes());
        os.close();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.component.stop();
        BioUtils.delete((File)this.file);
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.component = null;
        this.file = null;
        this.testDir = null;
    }

    public void testConstructors() {
        File file = new File("test.txt");
        FileRepresentation r = new FileRepresentation(file, MediaType.TEXT_PLAIN);
        FileRepresentationTestCase.assertEquals((String)"test.txt", (String)r.getDisposition().getFilename());
        FileRepresentationTestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)r.getMediaType());
        FileRepresentationTestCase.assertNull((Object)r.getExpirationDate());
    }

    public void testFileName() throws Exception {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                return new Restlet(){

                    public void handle(Request request, Response response) {
                        response.setEntity((Representation)new FileRepresentation(FileRepresentationTestCase.this.file, MediaType.TEXT_PLAIN));
                        response.getEntity().getDisposition().setType("attachment");
                    }
                };
            }
        };
        this.component.getDefaultHost().attach((Restlet)application);
        Client client = new Client(new Context(), Protocol.HTTP);
        Request request = new Request(Method.GET, this.uri);
        Response response = client.handle(request);
        Representation entity = response.getEntity();
        FileRepresentationTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        FileRepresentationTestCase.assertEquals((String)"abc", (String)entity.getText());
        FileRepresentationTestCase.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)entity.getDisposition().getFilename());
    }
}

