/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.engine.http.header.ContentType;
import org.restlet.test.RestletTestCase;

public class ContentTypeTestCase
extends RestletTestCase {
    public void testParsingInvalid() {
        String h1 = "application/docbook+xml; version='my version 1.0'";
        try {
            new ContentType(h1);
            ContentTypeTestCase.fail((String)"Shouldn't reach this point");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParsing() {
        String h1 = "application/docbook+xml; version=\"my version 1.0\"";
        String h2 = "application/docbook+xml; version='my%20version%201.0'";
        ContentType ct1 = new ContentType(h1);
        ContentType ct2 = new ContentType(h2);
        ContentTypeTestCase.assertEquals((String)h1, (String)ct1.getMediaType().getName());
        ContentTypeTestCase.assertEquals((String)"my version 1.0", (String)ct1.getMediaType().getParameters().getFirstValue("version"));
        ContentTypeTestCase.assertEquals((String)h2, (String)ct2.getMediaType().getName());
        ContentTypeTestCase.assertEquals((String)"'my%20version%201.0'", (String)ct2.getMediaType().getParameters().getFirstValue("version"));
    }
}

