/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.engine.util.FormReader;
import org.restlet.test.RestletTestCase;

public class FormTestCase
extends RestletTestCase {
    public void testParsing() throws IOException {
        Form form = new Form();
        form.add("name", "John D. Mitchell");
        form.add("email", "john@bob.net");
        form.add("email2", "joe@bob.net");
        String query = form.encode(CharacterSet.UTF_8);
        Form newForm = new FormReader(query, CharacterSet.UTF_8, '&').read();
        String newQuery = newForm.encode(CharacterSet.UTF_8);
        FormTestCase.assertEquals((String)query, (String)newQuery);
    }

    public void testEmptyParameter() throws IOException {
        Form form = new Form();
        form.add("normalParam", "abcd");
        form.add("emptyParam", "");
        form.add("nullParam", null);
        FormTestCase.assertEquals((int)3, (int)form.size());
        FormTestCase.assertEquals((String)"abcd", (String)form.getFirstValue("normalParam"));
        FormTestCase.assertEquals((String)"", (String)form.getFirstValue("emptyParam"));
        FormTestCase.assertNull((Object)form.getFirstValue("nullParam"));
        FormTestCase.assertNull((Object)form.getFirstValue("unknownParam"));
        form = new Form("normalParam=abcd&emptyParam=&nullParam");
        FormTestCase.assertEquals((int)3, (int)form.size());
        FormTestCase.assertEquals((String)"abcd", (String)form.getFirstValue("normalParam"));
        FormTestCase.assertEquals((String)"", (String)form.getFirstValue("emptyParam"));
        FormTestCase.assertNull((Object)form.getFirstValue("nullParam"));
        FormTestCase.assertNull((Object)form.getFirstValue("unknownParam"));
    }
}

