/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.freemarker;

import freemarker.template.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.util.TreeMap;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.test.RestletTestCase;

public class FreeMarkerTestCase
extends RestletTestCase {
    public static void main(String[] args) {
        try {
            new FreeMarkerTestCase().testTemplate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testTemplate() throws Exception {
        File testDir = new File(System.getProperty("java.io.tmpdir"), "FreeMarkerTestCase");
        testDir.mkdir();
        File testFile = File.createTempFile("test", ".ftl", testDir);
        FileWriter fw = new FileWriter(testFile);
        fw.write("Value=${value}");
        fw.close();
        Configuration fmc = new Configuration();
        fmc.setDirectoryForTemplateLoading(testDir);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("value", "myValue");
        String result = new TemplateRepresentation(testFile.getName(), fmc, map, MediaType.TEXT_PLAIN).getText();
        FreeMarkerTestCase.assertEquals((String)"Value=myValue", (String)result);
        BioUtils.delete((File)testFile);
        BioUtils.delete((File)testDir, (boolean)true);
    }
}

