/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import junit.framework.AssertionFailedError;
import org.restlet.Response;
import org.restlet.data.Cookie;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.ListParamService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class ListParamTest
extends JaxRsTestCase {
    public static final boolean LATER = true;

    private void checkPathParam(Response response) throws IOException {
        ListParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ListParamTest.assertEquals((String)"p=p1\npp={pp1, pp2}", (String)response.getEntity().getText());
    }

    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ListParamService.class);
            }
        };
        return appConfig;
    }

    public void testCookieParams() throws IOException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.add(new Cookie("c", "c1"));
        cookies.add(new Cookie("c", "c2"));
        cookies.add(new Cookie("c", "c3"));
        cookies.add(new Cookie("cc", "cc1"));
        cookies.add(new Cookie("cc", "cc2"));
        cookies.add(new Cookie("cc", "cc3"));
        Response response = this.getWithCookies("cookie", cookies);
        ListParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ListParamTest.assertEquals((String)"c=c1\ncc=[cc1, cc2, cc3]", (String)response.getEntity().getText());
    }

    public void testHeaderParams() throws IOException {
        ArrayList<Parameter> addHeaders = new ArrayList<Parameter>();
        addHeaders.add(new Parameter("h", "h1"));
        addHeaders.add(new Parameter("h", "h2"));
        addHeaders.add(new Parameter("hh", "hh1"));
        addHeaders.add(new Parameter("hh", "hh2"));
        Response response = this.getWithHeaders("header", addHeaders);
        ListParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String[] entity = response.getEntity().getText().split("\\n");
        String header = entity[0];
        String headers = entity[1];
        ListParamTest.assertEquals((String)"h=h1", (String)header);
        try {
            ListParamTest.assertEquals((String)"hh=[hh1, hh2]", (String)headers);
        }
        catch (AssertionFailedError afe) {
            ListParamTest.assertEquals((String)"hh=[hh2, hh1]", (String)headers);
        }
    }

    public void testMatrixParams() throws IOException {
        Response response = this.get("matrix;m=m1;m=m2;mm=mm1;mm=mm2");
        ListParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String[] entity = response.getEntity().getText().split("\n");
        String m = entity[0];
        String mm = entity[1];
        try {
            ListParamTest.assertEquals((String)"m=m1", (String)m);
        }
        catch (AssertionFailedError afe) {
            ListParamTest.assertEquals((String)"m=m2", (String)m);
        }
        try {
            ListParamTest.assertEquals((String)"mm=[mm1, mm2]", (String)mm);
        }
        catch (AssertionFailedError afe) {
            ListParamTest.assertEquals((String)"mm=[mm2, mm1]", (String)mm);
        }
    }

    public void testPathParams() throws IOException {
    }

    public void testQueryParams() throws IOException {
        Response response = this.get("query?q=q1&q=q2&qq=qq1&qq=qq2");
        ListParamTest.assertEquals((String)"q=q1\nqq=[qq1, qq2]", (String)response.getEntity().getText());
        response = this.get("query?q=q2&q=q1&qq=qq2&qq=qq1");
        ListParamTest.assertEquals((String)"q=q2\nqq=[qq2, qq1]", (String)response.getEntity().getText());
    }
}

