/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.MatrixParamTestService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class MatrixParamTest
extends JaxRsTestCase {
    public void checkBothGiven(String subPath) throws IOException {
        Response response = this.get(subPath + ";firstname=Angela;lastname=Merkel");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
        response = this.get(subPath + ";lastname=Merkel;firstname=Angela");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
    }

    public void checkOneGiven(String subPath) throws IOException {
        Response response = this.get(subPath + ";firstname=Goofy");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"Goofy null", (String)response.getEntity().getText());
        response = this.get(subPath + ";lastname=Goofy");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"null Goofy", (String)response.getEntity().getText());
    }

    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(MatrixParamTestService.class);
            }
        };
        return appConfig;
    }

    public void testA() throws IOException {
        this.checkBothGiven("a");
        this.checkOneGiven("a");
    }

    public void testB() throws IOException {
        this.checkBothGiven("b");
        this.checkOneGiven("b");
    }

    public void testCheckUnmodifiable() {
        Response response = this.get("checkUnmodifiable");
        MatrixParamTest.assertTrue((String)"The List annotated with @MatrixParam seems to be modifiable", (boolean)response.getStatus().isSuccess());
    }

    public void testDecoded() throws IOException {
        Response response = this.get("b;firstname=George%20U.;lastname=Bush");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"George U. Bush", (String)response.getEntity().getText());
    }

    public void testEncoded() throws IOException {
        Response response = this.get("encoded;firstname=George%20U.;lastname=Bush");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"George%20U. Bush", (String)response.getEntity().getText());
    }

    public void testOne1() throws Exception {
        Response response = this.get("one;name");
        MatrixParamTest.sysOutEntityIfError(response);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
    }

    public void testOne2() throws Exception {
        Response response = this.get("one;name=");
        MatrixParamTest.sysOutEntityIfError(response);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
    }

    public void testOne3() throws Exception {
        Response response = this.get("one;name=x");
        MatrixParamTest.sysOutEntityIfError(response);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"x", (String)response.getEntity().getText());
    }

    public void testOne4() throws Exception {
        Response response = this.get("one;name2=sdf");
        MatrixParamTest.sysOutEntityIfError(response);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[null]", (String)response.getEntity().getText());
    }

    public void testSemicolon() {
        Response response1 = this.get("semicolon");
        MatrixParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response1.getStatus());
        MatrixParamTest.sysOutEntityIfError(response1);
        Response response2 = this.get("semicolon;mpA=6");
        MatrixParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response2.getStatus());
        MatrixParamTest.sysOutEntityIfError(response2);
        Response response3 = this.get("semicolon;mpB=6");
        MatrixParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response3.getStatus());
        MatrixParamTest.sysOutEntityIfError(response3);
        Response response4 = this.get("semicolon;mpB=6;mpA=5");
        MatrixParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response4.getStatus());
        MatrixParamTest.sysOutEntityIfError(response4);
        Response response5 = this.get("semicolon;mpA=5;mpB=6");
        MatrixParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response5.getStatus());
        MatrixParamTest.sysOutEntityIfError(response5);
    }

    public void testSetterDecoded() throws Exception {
        Response response1 = this.get(";decoded=abc/setterDecoded");
        MatrixParamTest.sysOutEntityIfError(response1);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        MatrixParamTest.assertEquals((String)"abc", (String)response1.getEntity().getText());
        Response response2 = this.get(";decoded=%20/setterDecoded");
        MatrixParamTest.sysOutEntityIfError(response2);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        MatrixParamTest.assertEquals((String)" ", (String)response2.getEntity().getText());
    }

    public void testSetterEncoded() throws Exception {
        Response response1 = this.get(";encoded=abc/setterEncoded");
        MatrixParamTest.sysOutEntityIfError(response1);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        MatrixParamTest.assertEquals((String)"abc", (String)response1.getEntity().getText());
        Response response2 = this.get(";encoded=%20/setterEncoded");
        MatrixParamTest.sysOutEntityIfError(response2);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        MatrixParamTest.assertEquals((String)"%20", (String)response2.getEntity().getText());
    }

    public void testSub1() throws Exception {
        Response response2 = this.get("sub;name=abc/one");
        MatrixParamTest.sysOutEntityIfError(response2);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        MatrixParamTest.assertEquals((String)"abc", (String)response2.getEntity().getText());
        Response response3 = this.get("sub/one;name=def");
        MatrixParamTest.sysOutEntityIfError(response3);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response3.getStatus());
        MatrixParamTest.assertEquals((String)"def", (String)response3.getEntity().getText());
        Response response4 = this.get("sub;name=abc/one;name=def");
        MatrixParamTest.sysOutEntityIfError(response4);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response4.getStatus());
        MatrixParamTest.assertEquals((String)"def", (String)response4.getEntity().getText());
        Response response5 = this.get("sub;name=abc/allNames;name=def");
        MatrixParamTest.sysOutEntityIfError(response5);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response5.getStatus());
        MatrixParamTest.assertEquals((String)"[abc, def]", (String)response5.getEntity().getText());
        Response response6 = this.get("allNames;name=abc");
        MatrixParamTest.sysOutEntityIfError(response6);
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response6.getStatus());
        MatrixParamTest.assertEquals((String)"[abc]", (String)response6.getEntity().getText());
    }

    public void testWithDefault() throws IOException {
        Response response = this.get("withDefault;mp=abcde");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"abcde", (String)response.getEntity().getText());
        response = this.get("withDefault;mp=");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
        response = this.get("withDefault");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"default", (String)response.getEntity().getText());
    }

    public void testWithoutDefault() throws IOException {
        Response response = this.get("withoutDefault;mp=abcde");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"abcde", (String)response.getEntity().getText());
        response = this.get("withoutDefault;mp=");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
        response = this.get("withoutDefault");
        MatrixParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest.assertEquals((String)"[null]", (String)response.getEntity().getText());
    }

    public void testWithoutPath() throws Exception {
        this.checkBothGiven("");
        this.checkOneGiven("");
    }
}

