/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import junit.framework.TestCase;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ResourceException;
import org.restlet.test.resource.MyResource4;

public class AnnotatedResource4TestCase
extends TestCase {
    private ClientResource clientResource;

    protected void setUp() throws Exception {
        Finder finder = new Finder();
        finder.setTargetClass(MyResource4.class);
        this.clientResource = new ClientResource("http://local");
        this.clientResource.setNext((Uniform)finder);
    }

    protected void tearDown() throws Exception {
        this.clientResource = null;
        super.tearDown();
    }

    public void testGet() throws IOException, ResourceException {
        Representation result = this.clientResource.get(MediaType.APPLICATION_JSON);
        AnnotatedResource4TestCase.assertNotNull((Object)result);
        AnnotatedResource4TestCase.assertEquals((String)"[\"root\"]", (String)result.getText());
        AnnotatedResource4TestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)result.getMediaType());
        result = this.clientResource.get(MediaType.APPLICATION_XML);
        AnnotatedResource4TestCase.assertNotNull((Object)result);
        AnnotatedResource4TestCase.assertEquals((String)"<root/>", (String)result.getText());
        AnnotatedResource4TestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)result.getMediaType());
        result = this.clientResource.get(MediaType.TEXT_HTML);
        AnnotatedResource4TestCase.assertNotNull((Object)result);
        AnnotatedResource4TestCase.assertEquals((String)"<html><body>root</body></html>", (String)result.getText());
        AnnotatedResource4TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)result.getMediaType());
    }
}

