/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.IOException;
import java.util.List;
import org.restlet.Request;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.engine.Engine;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.ext.crypto.internal.AwsHelper;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class AuthenticationTestCase
extends RestletTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Engine.clear();
    }

    public void testAwsS3() {
        AwsHelper helper = new AwsHelper();
        ChallengeWriter cw = new ChallengeWriter();
        ChallengeResponse challenge = new ChallengeResponse(ChallengeScheme.HTTP_AWS_S3, "0PN5J17HBGZHT7JJ3X82", "uV3F3YluFJax1cknvbcGwgjvx4QpvB+leU8dUj2o");
        Request request = new Request(Method.GET, "http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        Form httpHeaders = new Form();
        httpHeaders.add("Date", "Tue, 27 Mar 2007 19:36:42 +0000");
        helper.formatRawResponse(cw, challenge, request, (Series)httpHeaders);
        AuthenticationTestCase.assertEquals((String)"0PN5J17HBGZHT7JJ3X82:xXjDGYUmKxnwqr5KXNPGldn5LbA=", (String)cw.toString());
        cw = new ChallengeWriter();
        request.setMethod(Method.PUT);
        httpHeaders.set("Date", "Tue, 27 Mar 2007 21:15:45 +0000", true);
        httpHeaders.add("Content-Length", "94328");
        httpHeaders.add("Content-Type", "image/jpeg");
        helper.formatRawResponse(cw, challenge, request, (Series)httpHeaders);
        AuthenticationTestCase.assertEquals((String)"0PN5J17HBGZHT7JJ3X82:hcicpDDvL9SsO6AkvxqmIWkmOuQ=", (String)cw.toString());
    }

    public void testParsingBasic() throws IOException {
        String authenticate1 = "Basic realm=\"Restlet tutorial\"";
        String authorization1 = "Basic c2NvdHQ6dGlnZXI=";
        AuthenticationTestCase.assertEquals((String)authorization1, (String)AuthenticatorUtils.formatResponse((ChallengeResponse)AuthenticatorUtils.parseResponse(null, (String)authorization1, null), null, null));
        List creq = AuthenticatorUtils.parseRequest(null, (String)authenticate1, null);
        AuthenticationTestCase.assertEquals((int)creq.size(), (int)1);
        AuthenticationTestCase.assertEquals((String)authenticate1, (String)AuthenticatorUtils.formatRequest((ChallengeRequest)((ChallengeRequest)creq.get(0)), null, null));
    }

    public void testParsingDigest() throws IOException {
        String authorization1 = "Digest username=\"admin\", nonce=\"MTE3NzEwMzIwMjg0Mjo2NzFjODQyMjAyOWRlNWQ1YjFjNmEzYzJmOWRlZmE2Mw==\", uri=\"/protected/asdass\", response=\"a891ebedebb2046b83a9b7540f4e9554\", cnonce=\"MTE3NzEwMzIwMjkwMDoxNmMzODFiYzRjNWRjMmMyOTVkMWFhNDdkMTQ4OGFlMw==\", qop=auth, nc=00000001";
        String authenticate1 = "Digest realm=realm, domain=\"/protected/ /alsoProtected/\", qop=auth, algorithm=MD5, nonce=\"MTE3NzEwMzIwMjg0Mjo2NzFjODQyMjAyOWRlNWQ1YjFjNmEzYzJmOWRlZmE2Mw==\"";
        ChallengeResponse cres = AuthenticatorUtils.parseResponse(null, (String)authorization1, null);
        cres.setRawValue(null);
        AuthenticationTestCase.assertEquals((String)authorization1, (String)AuthenticatorUtils.formatResponse((ChallengeResponse)cres, null, null));
        List creq = AuthenticatorUtils.parseRequest(null, (String)authenticate1, null);
        AuthenticationTestCase.assertEquals((int)creq.size(), (int)1);
        AuthenticationTestCase.assertEquals((String)authenticate1, (String)AuthenticatorUtils.formatRequest((ChallengeRequest)((ChallengeRequest)creq.get(0)), null, null));
    }

    public void testParsingMultiValuedAuthenticate() throws IOException {
        String authenticate0 = "Basic realm=\"Restlet tutorial\"";
        String authenticate1 = "Digest realm=realm, domain=\"/protected/ /alsoProtected/\", qop=auth, algorithm=MD5, nonce=\"MTE3NzEwMzIwMjg0Mjo2NzFjODQyMjAyOWRlNWQ1YjFjNmEzYzJmOWRlZmE2Mw==\"";
        String authenticate = authenticate0 + "," + authenticate1;
        List creq = AuthenticatorUtils.parseRequest(null, (String)authenticate, null);
        AuthenticationTestCase.assertEquals((int)creq.size(), (int)2);
        AuthenticationTestCase.assertEquals((String)authenticate0, (String)AuthenticatorUtils.formatRequest((ChallengeRequest)((ChallengeRequest)creq.get(0)), null, null));
        AuthenticationTestCase.assertEquals((String)authenticate1, (String)AuthenticatorUtils.formatRequest((ChallengeRequest)((ChallengeRequest)creq.get(1)), null, null));
    }
}

