/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.javamail;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.NodeList;
import org.restlet.test.RestletTestCase;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JavaMailTestCase
extends RestletTestCase {
    private static final String _TRUSTSTORE = "d:/temp/certificats/myClientKeystore";
    private static final String DEBUG = "false";
    private static final String GMAIL_ID = "XXX";
    private static final String GMAIL_LOGIN = "XXX@gmail.com";
    private static final String GMAIL_PASSWORD = "XXX";
    private static final String GMAIL_SMTPS = "smtps://smtp.gmail.com";
    private static final String MAIL = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><email><head><subject>Test message</subject><from>restlet.testfr@yahoo.fr</from><to>restlet.testfr@yahoo.fr</to><cc>restlet.testfr@yahoo.fr</cc></head><body><![CDATA[Hi, this is a test.]]></body></email>";
    private static final String NOELIOS_LOGIN = "XXX";
    private static final String NOELIOS_PASSWORD = "XXX";
    private static final String NOELIOS_POPS = "pops://alaska.noelios.com";
    private static final String NOELIOS_SMTP = "smtp://alaska.noelios.com";
    private static final String YAHOO_ID = "XXX";
    private static final String YAHOO_PASSWORD = "XXX";
    private static final String YAHOO_POP = "pop://pop.mail.yahoo.fr";
    private static final String YAHOO_SMTP = "smtp://smtp.mail.yahoo.com";

    private void printMail(Client client, String baseUri, String href) throws IOException {
        Request request = new Request(Method.GET, baseUri + href);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.POP_BASIC, "XXX", "XXX"));
        Response response = client.handle(request);
        JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response.getEntity().write((OutputStream)System.out);
        System.out.println();
    }

    private void sendMail(Protocol protocol, Request request, boolean startTls) throws Exception {
        Client client = new Client(protocol);
        client.getContext().getParameters().add("debug", DEBUG);
        client.getContext().getParameters().add("startTls", Boolean.toString(startTls).toLowerCase());
        request.setEntity(MAIL, MediaType.APPLICATION_XML);
        Response response = client.handle(request);
        JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        client.stop();
    }

    protected void setUp() throws Exception {
        super.setUp();
        File keyStoreFile = new File(_TRUSTSTORE);
        if (keyStoreFile.exists()) {
            System.setProperty("javax.net.ssl.trustStore", keyStoreFile.getCanonicalPath());
        }
    }

    public void testPop() throws Exception {
        DomRepresentation representation;
        NodeList nodes;
        Client client = new Client(Protocol.POP);
        client.getContext().getParameters().add("debug", DEBUG);
        Request request = new Request(Method.GET, YAHOO_POP);
        ChallengeResponse challengeResponse = new ChallengeResponse(ChallengeScheme.POP_BASIC, "XXX", "XXX");
        request.setChallengeResponse(challengeResponse);
        Response response = client.handle(request);
        JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        this.testSmtp();
        if (response.isEntityAvailable() && (nodes = (representation = new DomRepresentation(response.getEntity())).getNodes("/emails/email")).getLength() > 0) {
            Node node = representation.getNode("/emails/email[1]/@href");
            String mailUrl = YAHOO_POP + node.getNodeValue();
            request = new Request(Method.GET, mailUrl);
            request.setChallengeResponse(challengeResponse);
            response = client.handle(request);
            JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
            request = new Request(Method.DELETE, mailUrl);
            request.setChallengeResponse(challengeResponse);
            response = client.handle(request);
            JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        }
        client.stop();
    }

    public void testPops() throws Exception {
        Client client = new Client(Protocol.POPS);
        client.getContext().getParameters().add("debug", DEBUG);
        String baseUri = NOELIOS_POPS;
        Request request = new Request(Method.GET, NOELIOS_POPS);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.POP_BASIC, "XXX", "XXX"));
        Response response = client.handle(request);
        JavaMailTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response.getEntity().write((OutputStream)System.out);
        System.out.println();
        DomRepresentation dom = new DomRepresentation(response.getEntity());
        for (Node node : dom.getNodes("/emails/email")) {
            NamedNodeMap attrs = node.getAttributes();
            String href = attrs.getNamedItem("href").getNodeValue();
            this.printMail(client, NOELIOS_POPS, href);
        }
        client.stop();
    }

    public void testSmtp() throws Exception {
        Request request = new Request(Method.POST, YAHOO_SMTP);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.SMTP_PLAIN, "XXX", "XXX"));
        this.sendMail(Protocol.SMTP, request, false);
    }

    public void testSmtps() throws Exception {
        Request request = new Request(Method.POST, GMAIL_SMTPS);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.SMTP_PLAIN, GMAIL_LOGIN, "XXX"));
        this.sendMail(Protocol.SMTPS, request, false);
    }

    public void testSmtpStartTls() throws Exception {
        Request request = new Request(Method.POST, NOELIOS_SMTP);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.SMTP_PLAIN, "XXX", "XXX"));
        this.sendMail(Protocol.SMTP, request, true);
    }
}

