/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.Engine;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.local.ClapClientHelper;
import org.restlet.ext.net.HttpClientHelper;
import org.restlet.ext.simple.HttpsServerHelper;
import org.restlet.ext.ssl.HttpsClientHelper;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SslBaseConnectorsTestCase
extends RestletTestCase {
    private Component component;
    private final boolean enableApacheClient = true;
    private final boolean enableInternalClient = true;
    private final boolean enableInternalServer = false;
    private final boolean enableJdkNetClient = true;
    private final boolean enableJettyServer = true;
    private final boolean enableSimpleServer = true;
    private final File testDir = new File(System.getProperty("java.io.tmpdir"), "SslBaseConnectorsTestCase");
    protected final File testKeystoreFile = new File(this.testDir, "dummy.jks");

    protected abstract void call(String var1) throws Exception;

    protected void configureSslClientParameters(Context context) {
        Series parameters = context.getParameters();
        parameters.add("truststorePath", this.testKeystoreFile.getPath());
        parameters.add("truststorePassword", "testtest");
    }

    protected void configureSslServerParameters(Context context) {
        Series parameters = context.getParameters();
        parameters.add("keystorePath", this.testKeystoreFile.getPath());
        parameters.add("keystorePassword", "testtest");
        parameters.add("keyPassword", "testtest");
        parameters.add("truststorePath", this.testKeystoreFile.getPath());
        parameters.add("truststorePassword", "testtest");
    }

    protected abstract Application createApplication(Component var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ConnectorHelper<Server> server, ConnectorHelper<Client> client) throws Exception {
        Engine engine = Engine.register((boolean)false);
        engine.getRegisteredClients().add(new ClapClientHelper(null));
        engine.getRegisteredServers().add(server);
        engine.getRegisteredClients().add(client);
        String uri = this.start();
        try {
            this.call(uri);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void setUp() throws Exception {
        block3: {
            super.setUp();
            try {
                if (this.testKeystoreFile.exists()) break block3;
                BioUtils.delete((File)this.testDir, (boolean)true);
                this.testDir.mkdir();
                Response response = new Client(Protocol.CLAP).handle(new Request(Method.GET, "clap://class/org/restlet/test/engine/dummy.jks"));
                if (response.getEntity() != null) {
                    FileOutputStream outputStream = new FileOutputStream(this.testKeystoreFile);
                    response.getEntity().write((OutputStream)outputStream);
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                    break block3;
                }
                throw new Exception("Unable to find the dummy.jks file in the classpath.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String start() throws Exception {
        this.component = new Component();
        Server server = this.component.getServers().add(Protocol.HTTPS, 0);
        this.configureSslServerParameters(server.getContext());
        Application application = this.createApplication(this.component);
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
        return "https://localhost:" + server.getEphemeralPort() + "/test";
    }

    protected void stop() throws Exception {
        if (this.component != null && this.component.isStarted()) {
            this.component.stop();
        }
        this.component = null;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        BioUtils.delete((File)this.testKeystoreFile);
        BioUtils.delete((File)this.testDir, (boolean)true);
        Engine.register();
    }

    public void testSslInternalAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testSslInternalAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testSslInternalAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testSslJettyAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.jetty.HttpsServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testSslJettyAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.jetty.HttpsServerHelper(null), (ConnectorHelper<Client>)new HttpsClientHelper(null));
    }

    public void testSslJettyAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.jetty.HttpsServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testSslSimpleAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpsServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testSslSimpleAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpsServerHelper(null), (ConnectorHelper<Client>)new HttpsClientHelper(null));
    }

    public void testSslSimpleAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpsServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }
}

